/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.SystemServiceUtils;

public class ResolutionUtils {
    public static int getScreenWidth(Context context) {
        return ResolutionUtils.getScreenSize((Context)context, null).x;
    }

    public static int getScreenWidth() {
        return ResolutionUtils.getScreenWidth(RuntimeContext.sApplicationContext);
    }

    public static int getScreenHeight() {
        return ResolutionUtils.getScreenHeight(RuntimeContext.sApplicationContext);
    }

    public static int getScreenHeight(Context context) {
        return ResolutionUtils.getScreenSize((Context)context, null).y;
    }

    public static Point getScreenSize(Context context, Point outSize) {
        Point ret = outSize == null ? new Point() : outSize;
        Display defaultDisplay = SystemServiceUtils.getWindowManager(context).getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            defaultDisplay.getSize(ret);
        } else {
            ret.x = defaultDisplay.getWidth();
            ret.y = defaultDisplay.getHeight();
        }
        return ret;
    }

    public static float convertDpToPixel(float dp, Context context) {
        try {
            if (context == null) {
                return dp;
            }
            Resources resources = context.getResources();
            DisplayMetrics metrics = resources.getDisplayMetrics();
            float px = dp * ((float)metrics.densityDpi / 160.0f);
            return px;
        }
        catch (Exception ex) {
            Log.e((String)"ResolutionUtils", (String)"Empty Catch on convertDpToPixel", (Throwable)ex);
            return -1.0f;
        }
    }

    public static int dip2Px(float dp) {
        try {
            return (int)((double)ResolutionUtils.convertDpToPixel(dp, RuntimeContext.sApplicationContext) + 0.5);
        }
        catch (Exception ex) {
            Log.e((String)"ResolutionUtils", (String)"Empty Catch on convertDpToPixel", (Throwable)ex);
            return -1;
        }
    }

    public static int px2Dip(int px) {
        try {
            return (int)ResolutionUtils.convertPixelsToDp((float)px + 0.5f, RuntimeContext.sApplicationContext);
        }
        catch (Exception ex) {
            Log.e((String)"ResolutionUtils", (String)"Empty Catch on convertDpToPixel", (Throwable)ex);
            return -1;
        }
    }

    public static int spToPx(float spValue) {
        float fontScale = RuntimeContext.sApplicationContext.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int pxToSp(float pxValue) {
        float fontScale = RuntimeContext.sApplicationContext.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static float convertPixelsToDp(float px, Context context) {
        try {
            if (context == null) {
                return px;
            }
            Resources resources = context.getResources();
            DisplayMetrics metrics = resources.getDisplayMetrics();
            float dp = px / ((float)metrics.densityDpi / 160.0f);
            return dp;
        }
        catch (Exception ex) {
            Log.e((String)"ResolutionUtils", (String)"Empty Catch on convertPixelsToDp", (Throwable)ex);
            return -1.0f;
        }
    }

    public static int getDpi(Context context) {
        return context.getResources().getDisplayMetrics().densityDpi;
    }

    public static float getScreenWidthHeightRatio(Context context, Point outSize) {
        Point ret = outSize == null ? new Point() : outSize;
        Display defaultDisplay = SystemServiceUtils.getWindowManager(context).getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            defaultDisplay.getSize(ret);
        } else {
            ret.x = defaultDisplay.getWidth();
            ret.y = defaultDisplay.getHeight();
        }
        float xf = ret.x;
        float yf = ret.y;
        return xf / yf;
    }

    public static int getDensityDPI(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics displayMetrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            windowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
        } else {
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        }
        return displayMetrics.densityDpi;
    }
}

