/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.stuckminor.loopermintor;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Looper;
import com.yy.base.stuckminor.base.IANRListener;
import com.yy.base.stuckminor.loopermintor.MsgExcuteListener;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemServiceUtils;
import java.util.Map;

class LooperANRMonitor
implements MsgExcuteListener {
    private long mTimeOutTime;
    private IQueueTaskExecutor mAnrHandler;
    private volatile boolean mMsgFinished = false;
    private Context mContext;
    private IANRListener mANRLis;
    private final Thread mThread;
    private final Thread mMainThread;
    private Runnable mAnrRunnable = new Runnable(){

        @Override
        public void run() {
            LooperANRMonitor.this.generateStackTraces();
        }
    };

    public void setANRListener(IANRListener anrLis) {
        this.mANRLis = anrLis;
    }

    public LooperANRMonitor(Context context, long timeOutTime, Thread thread) {
        this.mContext = context;
        this.mTimeOutTime = timeOutTime;
        this.mThread = thread;
        this.mMainThread = Looper.getMainLooper().getThread();
        this.mAnrHandler = YYTaskExecutor.createAQueueExcuter();
    }

    @Override
    public void start(String msg, long startRealTime, long startCPUTime) {
        this.mMsgFinished = false;
        this.mAnrHandler.removeTask(this.mAnrRunnable);
        this.mAnrHandler.execute(this.mAnrRunnable, this.mTimeOutTime);
    }

    @Override
    public void end(String msg, long startRealTime, long startCPUTime, long consumeRealTime, long consumeCPUTime) {
        this.mMsgFinished = true;
        this.mAnrHandler.removeTask(this.mAnrRunnable);
    }

    private boolean dumpStackTraces(Thread thread, StackTraceElement[] ste, StringBuilder buffer) {
        buffer.append(thread.getName() + " " + thread.getPriority() + " " + (Object)((Object)thread.getState()) + "\n");
        int index = 0;
        for (StackTraceElement e : ste) {
            String line = e.toString();
            if (this.mThread == this.mMainThread && index == 0 && "android.os.MessageQueue.nativePollOnce(Native Method)".equals(line)) {
                return false;
            }
            buffer.append("  at " + line + "\n");
            ++index;
        }
        buffer.append("\n");
        return true;
    }

    private void generateStackTraces() {
        final StringBuilder buffer = new StringBuilder();
        if (this.mThread != null) {
            StackTraceElement[] ste = this.mThread.getStackTrace();
            if (!this.dumpStackTraces(this.mThread, ste, buffer)) {
                return;
            }
        } else {
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
                if (this.dumpStackTraces(entry.getKey(), entry.getValue(), buffer)) continue;
                return;
            }
        }
        if (!this.mMsgFinished) {
            buffer.insert(0, "FreeMem:" + this.getFreeMemory() + "\n");
            YYTaskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (LooperANRMonitor.this.mANRLis != null && buffer.length() > 0) {
                        LooperANRMonitor.this.mANRLis.anrStack(buffer.toString());
                    }
                }
            });
        }
    }

    private long getFreeMemory() {
        if (this.mContext == null) {
            return 0L;
        }
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        SystemServiceUtils.getActivityManager(this.mContext).getMemoryInfo(mi);
        long availableMegs = mi.availMem / 0x100000L;
        return availableMegs;
    }

    void stop() {
        this.mMsgFinished = true;
        this.mAnrHandler.removeTask(this.mAnrRunnable);
    }
}

