/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.stuckminor;

import android.view.View;
import android.view.ViewTreeObserver;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class FPSCal {
    private static HashMap<String, FPSInfo> mFPSInfoMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startCalFPS(String key, View view) {
        if (key == null || key.trim().length() == 0 || view == null) {
            return;
        }
        Class<FPSCal> clazz = FPSCal.class;
        synchronized (FPSCal.class) {
            if (mFPSInfoMap.get(key) != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            FPSInfo fpsInfo = new FPSInfo();
            fpsInfo.setView(view);
            Class<FPSCal> clazz2 = FPSCal.class;
            synchronized (FPSCal.class) {
                mFPSInfoMap.put(key, fpsInfo);
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int endCalFPS(String key) {
        if (mFPSInfoMap.size() <= 0) {
            return -1;
        }
        if (key == null || key.trim().length() == 0) {
            return 0;
        }
        Class<FPSCal> clazz = FPSCal.class;
        synchronized (FPSCal.class) {
            FPSInfo fpsInfo = mFPSInfoMap.get(key);
            if (fpsInfo == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 0;
            }
            fpsInfo.removeObserver();
            mFPSInfoMap.remove(key);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return fpsInfo.fps();
        }
    }

    private static class FPSInfo {
        private long mStartTime;
        private long mTotalFrame;
        private ViewTreeObserver.OnPreDrawListener mLis;
        private WeakReference<View> mView;

        private FPSInfo() {
        }

        public int fps() {
            float deltaTime = (float)(System.currentTimeMillis() - this.mStartTime) / 1000.0f;
            int fps = (int)((float)this.mTotalFrame / deltaTime);
            return fps > 0 ? fps : 0;
        }

        public void setView(View view) {
            ViewTreeObserver.OnPreDrawListener lis;
            if (view == null) {
                return;
            }
            this.mView = new WeakReference<View>(view);
            this.mLis = lis = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    ++mTotalFrame;
                    return true;
                }
            };
            View view1 = (View)this.mView.get();
            if (view1 != null) {
                ViewTreeObserver observer = view1.getViewTreeObserver();
                observer.addOnPreDrawListener(lis);
            }
            this.mStartTime = System.currentTimeMillis();
        }

        public void removeObserver() {
            View view;
            if (this.mView != null && this.mLis != null && (view = (View)this.mView.get()) != null) {
                view.getViewTreeObserver().removeOnPreDrawListener(this.mLis);
            }
        }
    }
}

