/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.memoryrecycle.views;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import androidx.appcompat.widget.AppCompatButton;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.drawablerecycle.DrawableRecycler;
import com.yy.base.memoryrecycle.views.IRecycleView;
import com.yy.base.memoryrecycle.views.ViewSetTagRunnable;

public class YYButton
extends AppCompatButton
implements IRecycleView {
    private boolean mIsAttachToWindow;
    private boolean mSettingDrawable;

    public YYButton(Context context) {
        super(context);
        this.logCreate();
    }

    public YYButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        DrawableRecycler.onAttributesUpdated(context, this, attrs);
        this.logCreate();
    }

    public YYButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        DrawableRecycler.onAttributesUpdated(context, this, attrs);
        this.logCreate();
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        DrawableRecycler.onVisibilityChanged(this, visibility);
    }

    protected void onAttachedToWindow() {
        this.mIsAttachToWindow = true;
        super.onAttachedToWindow();
        DrawableRecycler.onAttachedToWindow(this);
    }

    protected void onDetachedFromWindow() {
        this.mIsAttachToWindow = false;
        super.onDetachedFromWindow();
        DrawableRecycler.onDetachedFromWindow(this);
    }

    public void setBackgroundDrawable(Drawable background) {
        this.mSettingDrawable = true;
        super.setBackgroundDrawable(background);
        DrawableRecycler.onBackgroundUpdated((IRecycleView)this, background);
        this.mSettingDrawable = false;
    }

    public void setBackgroundResource(int resid) {
        this.mSettingDrawable = true;
        super.setBackgroundResource(resid);
        DrawableRecycler.onBackgroundUpdated((IRecycleView)this, resid);
        this.mSettingDrawable = false;
    }

    public Drawable getBackground() {
        if (!this.mSettingDrawable) {
            DrawableRecycler.onGetBackground(this);
        }
        Drawable drawable2 = super.getBackground();
        if (!this.mSettingDrawable) {
            DrawableRecycler.onGetBackgroundEnd(this);
        }
        return drawable2;
    }

    @Override
    public void setBackgroundToNull() {
        super.setBackgroundDrawable(null);
    }

    @Override
    public Drawable getBackgroundInner() {
        return super.getBackground();
    }

    @Override
    public boolean isAttachToWindow() {
        return this.mIsAttachToWindow;
    }

    @Override
    public boolean closeAutoRecycleDrawables() {
        return false;
    }

    public void setTag(int key, Object tag) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            super.setTag(key, tag);
        } else {
            this.post(new ViewSetTagRunnable((View)this, key, tag));
        }
    }

    public Object getTag(int key) {
        try {
            return super.getTag(key);
        }
        catch (Exception e) {
            MLog.error("YYButton", e);
            return null;
        }
    }
}

