/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader.webpanim.decoder;

import android.content.Context;
import android.graphics.Bitmap;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.util.Preconditions;
import com.yy.base.imageloader.webpanim.decoder.WebpDrawable;
import java.security.MessageDigest;

public class WebpDrawableTransformation
implements Transformation<WebpDrawable> {
    private final Transformation<Bitmap> wrapped;

    public WebpDrawableTransformation(Transformation<Bitmap> wrapped) {
        this.wrapped = Preconditions.checkNotNull(wrapped);
    }

    @Override
    public Resource<WebpDrawable> transform(Context context, Resource<WebpDrawable> resource, int outWidth, int outHeight) {
        Resource<Bitmap> transformed;
        WebpDrawable drawable2 = resource.get();
        BitmapPool bitmapPool = Glide.get(context).getBitmapPool();
        Bitmap firstFrame = drawable2.getFirstFrame();
        BitmapResource bitmapResource = new BitmapResource(firstFrame, bitmapPool);
        if (!bitmapResource.equals(transformed = this.wrapped.transform(context, bitmapResource, outWidth, outHeight))) {
            bitmapResource.recycle();
        }
        Bitmap transformedFrame = transformed.get();
        drawable2.setFrameTransformation(this.wrapped, transformedFrame);
        return resource;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof WebpDrawableTransformation) {
            WebpDrawableTransformation other = (WebpDrawableTransformation)o;
            return this.wrapped.equals(other.wrapped);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }

    @Override
    public void updateDiskCacheKey(MessageDigest messageDigest) {
        this.wrapped.updateDiskCacheKey(messageDigest);
    }
}

