/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader;

import android.net.Uri;
import android.text.TextUtils;
import com.yy.base.imageloader.ImageFormatTransformer$WhenMappings;
import com.yy.base.imageloader.ImageFormatTransformerKt;
import com.yy.base.imageloader.ImgFormatInfo;
import com.yy.base.utils.FP;
import com.yy.base.utils.YYImageUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/yy/base/imageloader/ImageFormatTransformer;", "", "()V", "HEIF", "", "PROTOCOL_VERSION", "SIZE_DIVIDER", "levelSwing", "", "getLevelSwing", "()I", "getHeifUrlSuffix", "imgFormatInfo", "Lcom/yy/base/imageloader/ImgFormatInfo;", "getLongSideSize", "getRealRequestUrl", "getSupportSizeList", "", "getUrlSuffix", "getWebpUrlSuffix", "isHeifSupport", "", "framework-base_release"})
public final class ImageFormatTransformer {
    @NotNull
    public static final String HEIF = "heif";
    private static final String SIZE_DIVIDER = "x";
    private static final int levelSwing = 10;
    @NotNull
    public static final String PROTOCOL_VERSION = "v1";
    public static final ImageFormatTransformer INSTANCE;

    public final int getLevelSwing() {
        return levelSwing;
    }

    @JvmStatic
    @NotNull
    public static final String getRealRequestUrl(@NotNull ImgFormatInfo imgFormatInfo) {
        Intrinsics.checkParameterIsNotNull((Object)imgFormatInfo, (String)"imgFormatInfo");
        String string2 = INSTANCE.getUrlSuffix(imgFormatInfo);
        boolean bl = false;
        boolean bl2 = false;
        String $this$run = string2;
        boolean bl3 = false;
        return TextUtils.isEmpty((CharSequence)$this$run) ? imgFormatInfo.getOriginUrl() : imgFormatInfo.getOriginUrl() + $this$run;
    }

    private final String getUrlSuffix(ImgFormatInfo imgFormatInfo) {
        String string2;
        switch (ImageFormatTransformer$WhenMappings.$EnumSwitchMapping$0[imgFormatInfo.getPrioritFormat().ordinal()]) {
            case 1: {
                string2 = this.getWebpUrlSuffix(imgFormatInfo);
                break;
            }
            case 2: {
                if (this.isHeifSupport(imgFormatInfo)) {
                    string2 = this.getHeifUrlSuffix(imgFormatInfo);
                    break;
                }
                string2 = this.getWebpUrlSuffix(imgFormatInfo);
                break;
            }
            default: {
                string2 = "";
            }
        }
        return string2;
    }

    private final boolean isHeifSupport(ImgFormatInfo imgFormatInfo) {
        ImgFormatInfo imgFormatInfo2 = imgFormatInfo;
        boolean bl = false;
        boolean bl2 = false;
        ImgFormatInfo $this$run = imgFormatInfo2;
        boolean bl3 = false;
        Uri uri = Uri.parse((String)$this$run.getOriginUrl());
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.parse(originUrl)");
        List pathList = uri.getPathSegments();
        if (FP.empty(pathList)) {
            return false;
        }
        if (!pathList.contains(HEIF)) {
            return false;
        }
        String heifVersion = (String)pathList.get(pathList.indexOf(HEIF) + 1);
        if (Intrinsics.areEqual((Object)heifVersion, (Object)PROTOCOL_VERSION) ^ true) {
            return false;
        }
        int longSideSize = INSTANCE.getLongSideSize(imgFormatInfo);
        List<Integer> sizeList = INSTANCE.getSupportSizeList(imgFormatInfo);
        if (sizeList.isEmpty()) {
            return false;
        }
        Iterable $this$forEach$iv = sizeList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl4 = false;
            int n = it - longSideSize;
            boolean bl5 = false;
            if (Math.abs(n) > levelSwing) continue;
            return true;
        }
        return false;
    }

    private final String getWebpUrlSuffix(ImgFormatInfo imgFormatInfo) {
        String string2 = YYImageUtils.getThumbnailPostfixPx(imgFormatInfo.getWidth(), imgFormatInfo.getHeight(), true);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"YYImageUtils.getThumbnai\u2026gFormatInfo.height, true)");
        return string2;
    }

    private final String getHeifUrlSuffix(ImgFormatInfo imgFormatInfo) {
        Uri uri = Uri.parse((String)imgFormatInfo.getOriginUrl());
        boolean bl = false;
        boolean bl2 = false;
        Uri $this$run = uri;
        boolean bl3 = false;
        int longSize = INSTANCE.getLongSideSize(imgFormatInfo);
        List<Integer> sizeList = INSTANCE.getSupportSizeList(imgFormatInfo);
        int heifPathIndex = $this$run.getPathSegments().indexOf(HEIF);
        List list = $this$run.getPathSegments();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"pathSegments");
        List newPathSegments = CollectionsKt.toMutableList((Collection)list);
        newPathSegments.subList(heifPathIndex, heifPathIndex + 3).clear();
        Uri uri2 = $this$run;
        Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"this");
        imgFormatInfo.setOriginUrl(ImageFormatTransformerKt.resetPath(uri2, newPathSegments));
        int requestSize = 0;
        Iterable $this$forEach$iv = sizeList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl4 = false;
            int n = it - longSize;
            boolean bl5 = false;
            if (Math.abs(n) > levelSwing) continue;
            requestSize = it;
        }
        return "_heif_" + requestSize;
    }

    private final int getLongSideSize(ImgFormatInfo imgFormatInfo) {
        int n = imgFormatInfo.getWidth();
        int n2 = imgFormatInfo.getHeight();
        boolean bl = false;
        return Math.max(n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> getSupportSizeList(ImgFormatInfo imgFormatInfo) {
        void $this$mapTo$iv$iv;
        String sizesString;
        Uri uri = Uri.parse((String)imgFormatInfo.getOriginUrl());
        boolean bl = false;
        boolean bl2 = false;
        Uri $this$run = uri;
        boolean bl3 = false;
        String string2 = sizesString = (String)$this$run.getPathSegments().get($this$run.getPathSegments().indexOf(HEIF) + 2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sizesString");
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)string2, (String[])new String[]{SIZE_DIVIDER}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            void var18_18 = it;
            boolean bl5 = false;
            Integer n = Integer.parseInt((String)var18_18);
            collection.add(n);
        }
        List widthList = (List)destination$iv$iv;
        return widthList;
    }

    private ImageFormatTransformer() {
    }

    static {
        ImageFormatTransformer imageFormatTransformer;
        INSTANCE = imageFormatTransformer = new ImageFormatTransformer();
        levelSwing = 10;
    }
}

