/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.NamedThreadFactory;
import com.yy.base.taskexecutor.NewYYTaskExecutor;
import com.yy.base.taskexecutor.Prioritized;
import com.yy.base.taskexecutor.util.PriorityHelper;
import com.yy.base.utils.HardwareUtils;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class YYThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final String TAG = "YYThreadPoolExecutor";
    private final BlockingQueue<Runnable> mWorkQueue;
    private static final int CPU_COUNT = HardwareUtils.getCpuCoreCount();
    private static final long KEEP_ALIVE_TIME_MS = TimeUnit.SECONDS.toMillis(30L);
    private static final long CACHE_KEEP_ALIVE_TIME_MS = TimeUnit.SECONDS.toMillis(60L);
    private static final int MAXIMUM_AUTOMATIC_COMMON_THREAD_COUNT;
    private static final int MAXIMUM_AUTOMATIC_CACHE_CORE_THREAD_COUNT;
    private static int bestCommonThreadCount;
    private final AtomicInteger ordering = new AtomicInteger();
    private final UncaughtThrowableStrategy uncaughtThrowableStrategy = UncaughtThrowableStrategy.IGNORE;

    public static ExecutorService createPool(int type) {
        return YYThreadPoolExecutor.createPool(type, PriorityHelper.getAdjustPriority(10));
    }

    public static ExecutorService createPool(int type, int priority) {
        switch (type) {
            case -3: {
                return YYThreadPoolExecutor.newCommonBuilder(type, priority).build();
            }
            case -1: {
                return YYThreadPoolExecutor.newSingleBuilder(type, priority).build();
            }
            case -2: {
                return YYThreadPoolExecutor.newCachedBuilder(type, priority).build();
            }
        }
        return YYThreadPoolExecutor.newFixedBuilder(type, priority).build();
    }

    private static Builder newCommonBuilder(int type, int priority) {
        return new Builder(type).setCoreThreadCount(YYThreadPoolExecutor.calculateBestCommonThreadCount()).setMaxThreadCount(YYThreadPoolExecutor.calculateBestCommonThreadCount()).setPriority(priority).setThreadTimeoutMillis(KEEP_ALIVE_TIME_MS);
    }

    private static Builder newSingleBuilder(int type, int priority) {
        return new Builder(type).setCoreThreadCount(1).setPriority(priority).setMaxThreadCount(1);
    }

    private static Builder newCachedBuilder(int type, int priority) {
        return new Builder(type).setCoreThreadCount(0).setMaxThreadCount(MAXIMUM_AUTOMATIC_CACHE_CORE_THREAD_COUNT).setThreadTimeoutMillis(CACHE_KEEP_ALIVE_TIME_MS).setPriority(priority).tryAddNonCoreThreadFirst(true);
    }

    private static Builder newFixedBuilder(int type, int priority) {
        return new Builder(type).setCoreThreadCount(0).setMaxThreadCount(type).setPriority(priority).allowCoreThreadTimeOut(true);
    }

    private static int calculateBestCommonThreadCount() {
        if (bestCommonThreadCount == 0) {
            bestCommonThreadCount = Math.min(MAXIMUM_AUTOMATIC_COMMON_THREAD_COUNT, (CPU_COUNT << 1) + 5);
        }
        return bestCommonThreadCount;
    }

    @VisibleForTesting
    YYThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize + 2, keepAliveTime, unit, workQueue, threadFactory);
        if (workQueue instanceof YYPriorityPoolBlockingQueue) {
            ((YYPriorityPoolBlockingQueue)workQueue).mPool = this;
        }
        this.mWorkQueue = workQueue;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new LoadTask<T>(runnable, value, this.ordering.getAndIncrement());
    }

    @Override
    public void execute(@NonNull Runnable command) {
        if (this.isShutdown()) {
            return;
        }
        Runnable task = null;
        try {
            task = !(command instanceof NewYYTaskExecutor.Task) ? NewYYTaskExecutor.Task.obtain(command, -9999, null) : command;
            super.execute(task);
        }
        catch (RejectedExecutionException ignore) {
            boolean result;
            MLog.error((Object)"YYTaskExecutor", "This will not happen!", new Object[0]);
            if (task != null && !(result = this.mWorkQueue.offer(task))) {
                MLog.error((Object)"YYTaskExecutor", "can not offer to queue!", new Object[0]);
                NewYYTaskExecutor.execute(task);
            }
        }
        catch (Throwable t) {
            MLog.error((Object)"YYTaskExecutor", "execute fail: ", t, new Object[0]);
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return null;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        Future future;
        super.afterExecute(r, t);
        if (t == null && r instanceof Future && (future = (Future)((Object)r)).isDone() && !future.isCancelled()) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                this.uncaughtThrowableStrategy.handle(e);
            }
            catch (ExecutionException e) {
                this.uncaughtThrowableStrategy.handle(e);
            }
        }
    }

    @Override
    public void allowCoreThreadTimeOut(boolean value) {
        super.allowCoreThreadTimeOut(false);
    }

    static {
        int n = CPU_COUNT > 4 && RuntimeContext.sPhoneType > 1 ? 20 : (MAXIMUM_AUTOMATIC_COMMON_THREAD_COUNT = RuntimeContext.isPhoneSuperLow() ? 8 : 15);
        MAXIMUM_AUTOMATIC_CACHE_CORE_THREAD_COUNT = CPU_COUNT > 4 && RuntimeContext.sPhoneType > 1 ? 64 : (RuntimeContext.isPhoneSuperLow() ? 16 : 32);
    }

    static class LoadTask<T>
    extends FutureTask<T>
    implements Prioritized,
    Comparable<Prioritized> {
        private final int priority;
        private final int order;

        LoadTask(Runnable runnable, T result, int order) {
            super(runnable, result);
            this.priority = runnable instanceof Prioritized ? ((Prioritized)((Object)runnable)).getPriority() : 10;
            this.order = order;
        }

        public boolean equals(Object o) {
            if (o instanceof LoadTask) {
                LoadTask other = (LoadTask)o;
                return this.order == other.order && this.priority == other.priority;
            }
            return false;
        }

        public int hashCode() {
            int result = this.priority;
            result = 31 * result + this.order;
            return result;
        }

        @Override
        public int compareTo(Prioritized loadTask) {
            int result = loadTask.getPriority() - this.priority;
            if (result == 0 && loadTask instanceof LoadTask) {
                result = this.order - ((LoadTask)loadTask).order;
            }
            return result;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }
    }

    public static enum UncaughtThrowableStrategy {
        IGNORE,
        LOG{

            @Override
            protected void handle(Throwable t) {
                MLog.error((Object)YYThreadPoolExecutor.TAG, "Request threw uncaught throwable", t, new Object[0]);
            }
        }
        ,
        THROW{

            @Override
            protected void handle(Throwable t) {
                super.handle(t);
                throw new RuntimeException(t);
            }
        };


        protected void handle(Throwable t) {
        }
    }

    public static final class Builder {
        private int corePoolSize;
        private int maximumPoolSize;
        private long threadTimeoutMillis = 0L;
        private boolean allowCoreThreadTimeOut;
        private int priority = 10;
        private boolean tryAddNonCoreThreadFirst;
        private int type;

        Builder(int type) {
            this.type = type;
        }

        public Builder allowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
            return this;
        }

        public Builder tryAddNonCoreThreadFirst(boolean tryAddNonCoreThreadFirst) {
            this.tryAddNonCoreThreadFirst = tryAddNonCoreThreadFirst;
            return this;
        }

        public Builder setThreadTimeoutMillis(long threadTimeoutMillis) {
            this.threadTimeoutMillis = threadTimeoutMillis;
            return this;
        }

        public Builder setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder setCoreThreadCount(@IntRange(from=0L) int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public Builder setMaxThreadCount(@IntRange(from=1L) int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
            return this;
        }

        private String getPrefixByType() {
            if (this.type == -1) {
                return "single";
            }
            if (this.type == -2) {
                return "cached";
            }
            if (this.type == -3) {
                return "common";
            }
            return "fixed(" + this.type + ")";
        }

        public YYThreadPoolExecutor build() {
            YYThreadPoolExecutor executor = this.type == -1 ? new YYThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.threadTimeoutMillis, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(this.getPrefixByType(), this.priority)) : new YYThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.threadTimeoutMillis, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new YYPriorityPoolBlockingQueue(this.tryAddNonCoreThreadFirst), new NamedThreadFactory(this.getPrefixByType(), this.priority));
            return executor;
        }
    }

    private static final class YYPriorityPoolBlockingQueue
    extends PriorityBlockingQueue<Runnable> {
        private static final long serialVersionUID = -8433631594405999454L;
        private volatile YYThreadPoolExecutor mPool;
        private int mCapacity = Integer.MAX_VALUE;
        private int poolSize;

        YYPriorityPoolBlockingQueue() {
        }

        YYPriorityPoolBlockingQueue(boolean tryAddNonCoreThreadFirst) {
            if (tryAddNonCoreThreadFirst) {
                this.mCapacity = 0;
            }
        }

        YYPriorityPoolBlockingQueue(int capacity) {
            this.mCapacity = capacity;
        }

        @Override
        public boolean offer(@NonNull Runnable runnable) {
            if (this.isEmpty()) {
                return super.offer(runnable);
            }
            this.poolSize = this.mPool.getPoolSize();
            if (this.mPool != null && this.mPool.getActiveCount() < this.poolSize) {
                return super.offer(runnable);
            }
            if (this.mCapacity <= this.size() && this.mPool != null && this.poolSize < this.mPool.getMaximumPoolSize() - 3) {
                return false;
            }
            return super.offer(runnable);
        }
    }
}

