/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.logger;

import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.LogRunnable;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hago.xlog.LogOptions;

public interface ILog {
    public void verbose(Object var1, String var2, Object ... var3);

    public void debug(Object var1, String var2, Object ... var3);

    public void info(Object var1, String var2, Object ... var3);

    public void warn(Object var1, String var2, Object ... var3);

    public void error(Object var1, String var2, Object ... var3);

    public void error(Object var1, String var2, Throwable var3, Object ... var4);

    public void error(Object var1, Throwable var2);

    public void trace(Object var1, String var2);

    public void flushCacheLogs();

    default public String tag(Object tag) {
        String threadInfo;
        String flag;
        if (tag == null) {
            flag = "";
        } else {
            String string2 = flag = tag instanceof String ? (String)tag : tag.getClass().getSimpleName();
        }
        if (RuntimeContext.sApplicationContext != null && RuntimeContext.sIsMainProcess) {
            boolean mainThread = YYTaskExecutor.isMainThread();
            if (mainThread) {
                threadInfo = "[MainThread]";
            } else {
                Thread thread = Thread.currentThread();
                threadInfo = "[" + thread.getName() + "-" + thread.getId() + "]";
            }
        } else {
            Thread thread = Thread.currentThread();
            threadInfo = "[" + thread.getName() + "-" + thread.getId() + "]";
        }
        flag = threadInfo + flag;
        return flag;
    }

    default public LogRunnable createLogRunnable(int level, Object obj, String format, Object ... args) {
        LogRunnable runnable = new LogRunnable();
        runnable.setLogLevel(level);
        runnable.setTag(this.tag(obj));
        runnable.setFormat(format);
        runnable.setArgs(args);
        runnable.setTime();
        if (level == LogOptions.LEVEL_ERROR) {
            runnable.setThrowable(null);
        }
        return runnable;
    }
}

