/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.kvo.list;

import androidx.annotation.NonNull;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.list.KvoListHelper;
import com.yy.base.event.kvo.list.KvoListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class KvoList<T>
implements List<T> {
    private List<T> mList;
    private final KvoSource mSource;
    private final String mName;

    public KvoList(KvoSource source, String name) {
        this(source, name, null);
    }

    public KvoList(KvoSource source, String name, List<T> list) {
        this.mSource = source;
        this.mName = name;
        this.mList = list == null ? new ArrayList() : list;
    }

    public void setWrappedList(List<T> list) {
        this.mList = list;
        KvoListHelper.notifyReload(this.mSource, this.mName, this);
    }

    public List<T> wrappedList() {
        return this.mList;
    }

    public String name() {
        return this.mName;
    }

    public KvoSource source() {
        return this.mSource;
    }

    @Override
    public void add(int location, T object) {
        this.mList.add(location, object);
        KvoListHelper.notifyInsert(this.mSource, this.mName, this, location, 1);
    }

    @Override
    public boolean add(T object) {
        int oldSize = this.size();
        boolean result = this.mList.add(object);
        if (result) {
            KvoListHelper.notifyInsert(this.mSource, this.mName, this, oldSize, 1);
        }
        return result;
    }

    @Override
    public boolean addAll(int location, Collection<? extends T> collection) {
        boolean result = this.mList.addAll(location, collection);
        if (result) {
            KvoListHelper.notifyInsert(this.mSource, this.mName, this, location, collection.size());
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        int oldSize = this.size();
        boolean result = this.mList.addAll(collection);
        if (result) {
            KvoListHelper.notifyInsert(this.mSource, this.mName, this, oldSize, collection.size());
        }
        return result;
    }

    @Override
    public void clear() {
        int preSize = this.size();
        this.mList.clear();
        KvoListHelper.notifyRangeRemove(this.mSource, this.mName, this, 0, preSize);
    }

    @Override
    public T remove(int location) {
        T t = this.mList.remove(location);
        KvoListHelper.notifyRangeRemove(this.mSource, this.mName, this, location, 1);
        return t;
    }

    @Override
    public boolean remove(Object object) {
        int index = this.mList.indexOf(object);
        if (index >= 0) {
            this.mList.remove(index);
            KvoListHelper.notifyRangeRemove(this.mSource, this.mName, this, index, 1);
        }
        return index >= 0;
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("invalid index fromIndex: " + fromIndex + " toIndex: " + toIndex);
        }
        this.mList.subList(fromIndex, toIndex).clear();
        KvoListHelper.notifyRangeRemove(this.mSource, this.mName, this, fromIndex, toIndex - fromIndex);
    }

    public void rangeReplace(int fromIndex, int toIndex, @NonNull Collection<? extends T> collection) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex || toIndex + 1 - fromIndex != collection.size()) {
            throw new IndexOutOfBoundsException("invalid index fromIndex: " + fromIndex + " toIndex: " + toIndex + " collectionSize : " + collection.size());
        }
        List<T> subList = this.mList.subList(fromIndex, toIndex);
        subList.clear();
        subList.addAll(collection);
        KvoListHelper.notifyRangeReplace(this.mSource, this.mName, this, fromIndex, toIndex - fromIndex);
    }

    public void set(@NonNull Collection<? extends T> newCollection) {
        this.mList.clear();
        this.mList.addAll(newCollection);
        KvoListHelper.notifyReload(this.mSource, this.mName, this);
    }

    @Override
    public T set(int location, T object) {
        T t = this.mList.set(location, object);
        KvoListHelper.notifyRangeReplace(this.mSource, this.mName, this, location, 1);
        return t;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.doCollectionOperation(collection, true);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.doCollectionOperation(collection, false);
    }

    private boolean doCollectionOperation(Collection<?> collection, boolean positive) {
        boolean result = false;
        Iterator<T> it = this.mList.iterator();
        KvoListHelper.NSRange currentRange = null;
        int i = 0;
        int currentDeleteLength = 0;
        while (it.hasNext()) {
            T t = it.next();
            if (collection.contains(t) == positive) {
                it.remove();
                if (currentRange == null) {
                    currentRange = new KvoListHelper.NSRange(i, 1);
                } else {
                    ++currentRange.length;
                }
                result = true;
            } else if (currentRange != null) {
                KvoListHelper.notifyRangeRemove(this.mSource, this.mName, this.mList, currentRange.position - currentDeleteLength, currentRange.length);
                currentDeleteLength += currentRange.length;
                currentRange = null;
            }
            ++i;
        }
        if (currentRange != null) {
            KvoListHelper.notifyRangeRemove(this.mSource, this.mName, this.mList, currentRange.position - currentDeleteLength, currentRange.length);
        }
        return result;
    }

    public void move(int fromIndex, int toIndex) {
        if (fromIndex != toIndex) {
            T t = this.mList.remove(fromIndex);
            this.mList.add(toIndex, t);
            KvoListHelper.notifyMove(this.mSource, this.mName, this, fromIndex, toIndex);
        }
    }

    @Override
    public List<T> subList(int start, int end) {
        return this.mList.subList(start, end);
    }

    @Override
    public int size() {
        return this.mList.size();
    }

    @Override
    public Object[] toArray() {
        return this.mList.toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.mList.toArray(array);
    }

    @Override
    public boolean isEmpty() {
        return this.mList.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new KvoListIterator(this.mSource, this.mName, this);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.mList.lastIndexOf(object);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new KvoListIterator(this.mSource, this.mName, this);
    }

    @Override
    public ListIterator<T> listIterator(int location) {
        return new KvoListIterator(this.mSource, this.mName, this, location);
    }

    @Override
    public boolean contains(Object object) {
        return this.mList.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.mList.containsAll(collection);
    }

    @Override
    public T get(int location) {
        return this.mList.get(location);
    }

    @Override
    public int indexOf(Object object) {
        return this.mList.indexOf(object);
    }
}

