/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.logger.MLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventBundle {
    public static final int EVENT_BUNDLE_FLAG_NONE = 0;
    private int mFlag = 0;
    private List<Object> mAllArgs = new ArrayList<Object>();
    private Map<String, Object> mKeyArgs = new HashMap<String, Object>();

    public EventBundle() {
    }

    public EventBundle(EventBundle other) {
        this();
        this.putAll(other);
    }

    @NonNull
    public List<Object> allArgs() {
        return this.mAllArgs;
    }

    @NonNull
    public Map<String, Object> keyArgs() {
        return this.mKeyArgs;
    }

    @Nullable
    public <T> T getArgWithKey(String key) {
        try {
            return (T)this.mKeyArgs.get(key);
        }
        catch (ClassCastException e) {
            MLog.error((Object)"FrameWork_Event", "EventBundle getArgWithKey failed : " + e.toString(), new Object[0]);
            return null;
        }
    }

    public boolean hasArg(String key) {
        return this.mKeyArgs.containsKey(key);
    }

    @Nullable
    public <T> T getArgWithIndex(int index) {
        if (this.mAllArgs.size() > index && index >= 0) {
            try {
                return (T)this.mAllArgs.get(index);
            }
            catch (ClassCastException e) {
                MLog.error((Object)"FrameWork_Event", "EventBundle getArgWithIndex failed : " + e.toString(), new Object[0]);
            }
        }
        return null;
    }

    public void addArg(Object arg) {
        this.mAllArgs.add(arg);
    }

    public void addArgs(Object ... args) {
        Collections.addAll(this.mAllArgs, args);
    }

    public void putArg(@NonNull String key, @Nullable Object arg) {
        if (this.mKeyArgs.put(key, arg) == null) {
            this.addArg(arg);
        }
    }

    public void putAll(@NonNull EventBundle other) {
        this.mAllArgs.addAll(other.mAllArgs);
        this.mKeyArgs.putAll(other.mKeyArgs);
        this.mFlag |= other.mFlag;
    }
}

