/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.guid;

import com.yy.base.guid.IGuid;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import java.util.UUID;

public class GuidImpl
implements IGuid {
    public static final String TAG = "GUID_LOG";
    protected volatile String mGuid = "";

    @Override
    public void init() {
        MLog.info(TAG, "init", new Object[0]);
        this.mGuid = this.queryUUIDFromPref();
        if (StringUtils.isEmpty(this.mGuid)) {
            YYTaskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (StringUtils.isEmpty(GuidImpl.this.mGuid) || GuidImpl.this.isValidUUID(GuidImpl.this.mGuid)) {
                        GuidImpl.this.mGuid = GuidImpl.this.generateUUID();
                        GuidImpl.this.saveUUID(GuidImpl.this.mGuid);
                    } else {
                        GuidImpl.this.saveUUIDToPref(GuidImpl.this.mGuid);
                    }
                }
            });
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.info("GuidImpl", "%s", this.mGuid);
        }
    }

    @Override
    public String getGuid() {
        try {
            if (this.mGuid == null || this.mGuid.length() < 1) {
                this.mGuid = this.queryUUIDFromPref();
            }
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "getGuid error:", e, new Object[0]);
            this.mGuid = "";
        }
        if (this.mGuid == null) {
            this.mGuid = "";
        }
        return this.mGuid;
    }

    protected String generateUUID() {
        String uuid = UUID.randomUUID().toString();
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug(TAG, "Generate UUID =%s", uuid);
        }
        return uuid;
    }

    protected void saveUUID(String value) {
        this.saveUUIDToPref(value);
    }

    protected void saveUUIDToPref(String value) {
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug(TAG, "Save UUID to pref=%s", value);
        }
        SettingFlags.setStringValue("guidnew", value);
    }

    protected String queryUUIDFromPref() {
        String uuid = SettingFlags.getStringValue("guidnew");
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug(TAG, "Query UUID from pref after=%s", uuid);
        }
        return uuid;
    }

    protected boolean isValidUUID(String value) {
        return value.matches("[A-Za-z0-9\\-]{36}");
    }
}

