/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.memoryrecycle.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import com.yy.base.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.drawablerecycle.DrawableRecycler;
import com.yy.base.memoryrecycle.views.BitmapCheckerProxy;
import com.yy.base.memoryrecycle.views.IImageRecycleView;
import com.yy.base.memoryrecycle.views.IRecycleView;
import com.yy.base.memoryrecycle.views.Monitor;
import com.yy.base.memoryrecycle.views.ViewSetTagRunnable;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;

public class YYImageView
extends ImageView
implements IImageRecycleView {
    protected boolean mIsAttachToWindow;

    public YYImageView(Context context) {
        super(context);
        this.updateAttr(context, null);
        this.logCreate();
    }

    public YYImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.updateAttr(context, attrs);
        this.logCreate();
        DrawableRecycler.onAttributesUpdated(context, this, attrs);
    }

    public YYImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.updateAttr(context, attrs);
        this.logCreate();
        DrawableRecycler.onAttributesUpdated(context, this, attrs);
    }

    private void updateAttr(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.YYImageView);
        int srcId = typedArray.getResourceId(R.styleable.YYImageView_src_async, 0);
        if (srcId != 0) {
            this.setSrcAsync(srcId);
        }
        typedArray.recycle();
    }

    public void setSrcAsync(@DrawableRes int resId) {
        if (resId == 0) {
            this.setImageDrawableToNull();
            return;
        }
        if (this.isInEditMode()) {
            this.setImageResource(resId);
        } else {
            YYTaskExecutor.execute(() -> {
                Drawable drawable2 = Build.VERSION.SDK_INT >= 21 ? this.getResources().getDrawable(resId, this.getContext().getTheme()) : this.getResources().getDrawable(resId);
                YYTaskExecutor.postToMainThread(() -> this.setImageDrawable(drawable2));
            });
        }
    }

    public void setVisibility(int visibility) {
        int oldVisibility = this.getVisibility();
        super.setVisibility(visibility);
        if (oldVisibility != visibility) {
            DrawableRecycler.onVisibilityChanged(this, visibility);
        }
    }

    public void draw(Canvas canvas) {
        block8: {
            if (RuntimeContext.sIsDebuggable || Build.VERSION.SDK_INT < 21) {
                super.draw(canvas);
            } else {
                try {
                    super.draw(canvas);
                }
                catch (RuntimeException e) {
                    boolean needCatch = false;
                    String errorInfo = e.getMessage();
                    if (StringUtils.isNotEmpty(errorInfo) && errorInfo.contains("Canvas: trying to use a recycled bitmap")) {
                        needCatch = true;
                    }
                    if (needCatch) {
                        MLog.error("YYImageView", e);
                        Monitor.IExceptionCallBack iExceptionCallBack = Monitor.getExceptionCallBack();
                        if (iExceptionCallBack != null) {
                            iExceptionCallBack.onYYImageViewDrawRecycleBitmapException(e);
                        }
                    }
                    throw new RuntimeException(e);
                }
                catch (StackOverflowError error) {
                    if (SystemUtils.isAsus()) break block8;
                    throw new RuntimeException(error);
                }
            }
        }
    }

    protected void onAttachedToWindow() {
        this.mIsAttachToWindow = true;
        super.onAttachedToWindow();
        DrawableRecycler.onAttachedToWindow(this);
    }

    protected void onDetachedFromWindow() {
        this.mIsAttachToWindow = false;
        super.onDetachedFromWindow();
        DrawableRecycler.onDetachedFromWindow(this);
    }

    public void setBackgroundDrawable(Drawable background) {
        super.setBackgroundDrawable(background);
        DrawableRecycler.onBackgroundUpdated((IRecycleView)this, background);
    }

    public void setBackgroundResource(int resid) {
        super.setBackgroundResource(resid);
        DrawableRecycler.onBackgroundUpdated((IRecycleView)this, resid);
    }

    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        DrawableRecycler.onImageUpdated((IRecycleView)this, drawable2);
        BitmapCheckerProxy.INSTANCE.check((ImageView)this, drawable2);
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        BitmapCheckerProxy.INSTANCE.check((ImageView)this, bm);
    }

    public void setImageResource(int resid) {
        super.setImageResource(resid);
        DrawableRecycler.onImageUpdated((IRecycleView)this, resid);
    }

    public Drawable getDrawable() {
        DrawableRecycler.onGetDrawable(this);
        Drawable drawable2 = super.getDrawable();
        DrawableRecycler.onGetDrawableEnd(this);
        BitmapCheckerProxy.INSTANCE.check((ImageView)this, drawable2);
        return drawable2;
    }

    public Drawable getBackground() {
        DrawableRecycler.onGetBackground(this);
        Drawable drawable2 = super.getBackground();
        DrawableRecycler.onGetBackgroundEnd(this);
        return drawable2;
    }

    public void setTag(int key, Object tag) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            super.setTag(key, tag);
        } else {
            this.post(new ViewSetTagRunnable((View)this, key, tag));
        }
    }

    public Object getTag(int key) {
        try {
            return super.getTag(key);
        }
        catch (Exception e) {
            MLog.error("YYImageView", e);
            return null;
        }
    }

    @Override
    public void setImageDrawableToNull() {
        super.setImageDrawable(null);
    }

    @Override
    public void setBackgroundToNull() {
        super.setBackgroundDrawable(null);
    }

    @Override
    public Drawable getBackgroundInner() {
        return super.getBackground();
    }

    @Override
    public boolean isAttachToWindow() {
        return this.mIsAttachToWindow;
    }

    @Override
    public boolean closeAutoRecycleDrawables() {
        return false;
    }

    @Override
    public Drawable getImageDrawableInner() {
        return super.getDrawable();
    }
}

