/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Registry;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.resource.bitmap.BitmapDrawableDecoder;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.heif.decoder.ByteBufferBitmapHeifDecoder;
import com.yy.base.imageloader.heif.decoder.HeifDownsampler;
import com.yy.base.imageloader.heif.decoder.StreamBitmapHeifDecoder;
import com.yy.base.imageloader.webpanim.decoder.AnimatedWebpBitmapDecoder;
import com.yy.base.imageloader.webpanim.decoder.ByteBufferAnimatedBitmapDecoder;
import com.yy.base.imageloader.webpanim.decoder.ByteBufferBitmapWebpDecoder;
import com.yy.base.imageloader.webpanim.decoder.ByteBufferWebpDecoder;
import com.yy.base.imageloader.webpanim.decoder.StreamAnimatedBitmapDecoder;
import com.yy.base.imageloader.webpanim.decoder.StreamBitmapWebpDecoder;
import com.yy.base.imageloader.webpanim.decoder.StreamWebpDecoder;
import com.yy.base.imageloader.webpanim.decoder.WebpDownsampler;
import com.yy.base.imageloader.webpanim.decoder.WebpDrawable;
import com.yy.base.imageloader.webpanim.decoder.WebpDrawableEncoder;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class GlideRegistry {
    public static void registry(ModelLoaderFactory<GlideUrl, InputStream> modelLoaderFactory) {
        Resources resources = RuntimeContext.sApplicationContext.getResources();
        BitmapPool bitmapPool = Glide.get(RuntimeContext.sApplicationContext).getBitmapPool();
        ArrayPool arrayPool = Glide.get(RuntimeContext.sApplicationContext).getArrayPool();
        WebpDownsampler webpDownsampler = new WebpDownsampler(Glide.get(RuntimeContext.sApplicationContext).getRegistry().getImageHeaderParsers(), resources.getDisplayMetrics(), bitmapPool, arrayPool);
        AnimatedWebpBitmapDecoder bitmapDecoder = new AnimatedWebpBitmapDecoder(arrayPool, bitmapPool);
        ByteBufferBitmapWebpDecoder byteBufferBitmapDecoder = new ByteBufferBitmapWebpDecoder(webpDownsampler);
        StreamBitmapWebpDecoder streamBitmapDecoder = new StreamBitmapWebpDecoder(webpDownsampler, arrayPool);
        ByteBufferWebpDecoder byteBufferWebpDecoder = new ByteBufferWebpDecoder(RuntimeContext.sApplicationContext, arrayPool, bitmapPool);
        HeifDownsampler heifDownsampler = new HeifDownsampler(Glide.get(RuntimeContext.sApplicationContext).getRegistry().getImageHeaderParsers(), resources.getDisplayMetrics(), bitmapPool, arrayPool);
        StreamBitmapHeifDecoder streamBitmapHeifDecoder = new StreamBitmapHeifDecoder(heifDownsampler);
        ByteBufferBitmapHeifDecoder byteBufferBitmapHeifDecoder = new ByteBufferBitmapHeifDecoder(heifDownsampler);
        Registry registry = Glide.get(RuntimeContext.sApplicationContext).getRegistry();
        if (modelLoaderFactory != null) {
            registry.replace(GlideUrl.class, InputStream.class, modelLoaderFactory);
        } else if (RuntimeContext.sIsDebuggable) {
            throw new RuntimeException("Glide network modelLoaderFactory is null");
        }
        registry.prepend("Bitmap", ByteBuffer.class, Bitmap.class, byteBufferBitmapHeifDecoder).prepend("BitmapDrawable", ByteBuffer.class, BitmapDrawable.class, new BitmapDrawableDecoder<ByteBuffer>(resources, byteBufferBitmapDecoder)).prepend("BitmapDrawable", InputStream.class, BitmapDrawable.class, new BitmapDrawableDecoder<InputStream>(resources, streamBitmapDecoder)).prepend("Bitmap", ByteBuffer.class, Bitmap.class, new ByteBufferAnimatedBitmapDecoder(bitmapDecoder)).prepend("Bitmap", InputStream.class, Bitmap.class, new StreamAnimatedBitmapDecoder(bitmapDecoder)).prepend(ByteBuffer.class, WebpDrawable.class, byteBufferWebpDecoder).prepend(InputStream.class, WebpDrawable.class, new StreamWebpDecoder(byteBufferWebpDecoder, arrayPool)).prepend(WebpDrawable.class, new WebpDrawableEncoder()).prepend(InputStream.class, Bitmap.class, streamBitmapHeifDecoder);
    }
}

