/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.cache.lru;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.cache.lru.LruNode;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HotEndLruCache<K, V> {
    private static final int HOT_COLD_BOUNDARY = 2;
    private int mCurSize = 0;
    private int mMaxSize = 0;
    private int mHotSize = 0;
    private int mMaxHotSize = 0;
    private final HashMap<K, LruNode<K, V>> mLocationMap = new HashMap(100);
    private LruNode<K, V> mHotHead = null;
    private LruNode<K, V> mColdHead = null;
    private final ReentrantReadWriteLock mLock = new ReentrantReadWriteLock();

    public HotEndLruCache(int maxSize, float hotPercent) {
        this.resize(maxSize, hotPercent);
    }

    public void resize(int maxSize, float hotPercent) {
        if (maxSize < 2 || hotPercent < 0.0f || hotPercent >= 1.0f) {
            throw new RuntimeException("HotEndLruCache size parameters error");
        }
        this.mLock.writeLock().lock();
        this.mMaxSize = maxSize;
        this.mMaxHotSize = Math.min(maxSize - 1, Math.max(1, (int)((float)maxSize * hotPercent)));
        this.mLock.readLock().lock();
        this.mLock.writeLock().unlock();
        boolean needTrim = this.mCurSize > this.mMaxSize;
        this.mLock.readLock().unlock();
        if (needTrim) {
            this.trimTo(this.mMaxSize);
        }
    }

    @Nullable
    public V get(@NonNull K key) {
        this.mLock.readLock().lock();
        LruNode<K, V> node = this.mLocationMap.get(key);
        if (node != null) {
            node.visitCount = Math.max(0, node.visitCount) + 1;
        }
        this.mLock.readLock().unlock();
        return node == null ? null : (V)node.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(@NonNull K newKey, @NonNull V newValue) {
        LruNode<K, V> oldNode;
        LruNode<K, V> newNode = new LruNode<K, V>(newKey, newValue, this.getSize(newValue));
        if (newNode.size > this.mMaxSize) {
            return false;
        }
        this.mLock.writeLock().lock();
        try {
            oldNode = this.mLocationMap.put(newKey, newNode);
            if (oldNode != null) {
                int lastVisitCount = oldNode.visitCount;
                this.removeNode(oldNode);
                newNode.visitCount = lastVisitCount + 1;
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
        if (oldNode != null) {
            this.onNodeRemoved(true, false, oldNode);
        }
        this.onPut(newNode);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPut(@NonNull LruNode<K, V> newNode) {
        boolean trimmed = this.trimTo(this.mMaxSize - newNode.size);
        this.mLock.writeLock().lock();
        try {
            if (this.mHotHead != null && this.mColdHead != null && trimmed) {
                this.insertBefore(newNode, this.mColdHead);
                this.mColdHead = newNode;
                newNode.isColdNode = true;
                this.mCurSize += newNode.size;
            } else {
                if (this.mHotHead != null) {
                    this.insertBefore(newNode, this.mHotHead);
                } else {
                    newNode.pre = newNode;
                    newNode.next = newNode.pre;
                }
                boolean isDoubleHead = this.mColdHead == this.mHotHead;
                this.mHotHead = newNode;
                this.mHotSize += newNode.size;
                this.mCurSize += newNode.size;
                if (this.mColdHead == null) {
                    if (this.mCurSize > this.mMaxHotSize) {
                        this.setColdHead(this.mHotHead.pre);
                    }
                } else if (this.mHotSize > this.mMaxHotSize) {
                    if (isDoubleHead && this.mColdHead.pre != this.mColdHead) {
                        this.mHotSize -= this.mColdHead.size;
                        this.mColdHead.isColdNode = true;
                    }
                    this.setColdHead(this.mColdHead.pre);
                }
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    protected int getSize(@NonNull V value) {
        return 1;
    }

    public final boolean trimTo(int targetSize) {
        LruNode removed = null;
        while (true) {
            LruNode coldTail;
            this.mLock.writeLock().lock();
            if (this.mCurSize <= targetSize) break;
            while (true) {
                coldTail = this.mHotHead.pre;
                if (coldTail.visitCount < 2) break;
                coldTail.visitCount = 1;
                this.setHotHead(coldTail);
                while (this.mHotSize > this.mMaxHotSize && this.setColdHead(this.mColdHead.pre)) {
                }
            }
            removed = coldTail;
            this.mLocationMap.remove(removed.key);
            this.removeNode(removed);
            this.mLock.writeLock().unlock();
            this.onNodeRemoved(false, false, removed);
        }
        this.mLock.writeLock().unlock();
        return removed != null;
    }

    private void insertBefore(@NonNull LruNode<K, V> newNode, @NonNull LruNode<K, V> existNode) {
        newNode.next = existNode;
        newNode.pre = existNode.pre;
        existNode.pre.next = newNode;
        existNode.pre = newNode;
    }

    protected void onNodeRemoved(boolean replaced, boolean manually, @NonNull LruNode<K, V> node) {
        if (replaced) {
            MLog.error((Object)"HotEndLruCache", "replace node may break the unique of object: " + node.key.toString(), new Object[0]);
            if (RuntimeContext.sIsDebuggable) {
                throw new UnsupportedOperationException("replace node may break the unique of object: " + node.key.toString());
            }
        }
    }

    @Nullable
    public final V remove(@NonNull K key) {
        LruNode<K, V> node;
        this.mLock.writeLock().lock();
        try {
            node = this.mLocationMap.remove(key);
            if (node != null) {
                node.visitCount = -1;
                if (node.pre != null) {
                    this.removeNode(node);
                }
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
        if (node == null) {
            return null;
        }
        this.onNodeRemoved(false, true, node);
        return node.value;
    }

    private void removeNode(@NonNull LruNode<K, V> node) {
        if (node.next == node) {
            this.setHotHead(null);
            this.setColdHead(null);
        } else {
            node.next.pre = node.pre;
            node.pre.next = node.next;
            if (this.mHotHead == node) {
                this.setHotHead(node.next);
            }
            if (this.mColdHead == node) {
                this.setColdHead(node.next);
            }
        }
        this.mCurSize -= node.size;
        if (!node.isColdNode) {
            this.mHotSize -= node.size;
        }
    }

    private void setHotHead(@Nullable LruNode<K, V> node) {
        if (node != null) {
            if (node.isColdNode) {
                this.mHotSize += node.size;
            }
            node.isColdNode = false;
        }
        this.mHotHead = node;
    }

    private boolean setColdHead(@Nullable LruNode<K, V> node) {
        this.mColdHead = node;
        if (node == null || this.mHotHead == node) {
            return false;
        }
        if (!node.isColdNode) {
            this.mHotSize -= node.size;
        }
        node.isColdNode = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int traverseTrim(int maxCount, @NonNull TraverseCallback<K, V> callback) {
        this.mLock.writeLock().lock();
        try {
            int count;
            if (this.mHotHead == null) {
                int n = 0;
                return n;
            }
            LruNode node = this.mHotHead.pre;
            for (count = 0; count < maxCount; ++count) {
                LruNode pre;
                if (!callback.onTraverse(node.key, node.value)) {
                    node.visitCount = 1;
                    this.setHotHead(node);
                    while (this.mHotSize > this.mMaxHotSize && this.setColdHead(this.mColdHead.pre)) {
                    }
                }
                if ((pre = node.pre) == node) break;
                node = pre;
            }
            int n = count;
            return n;
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    public void clear() {
        this.mLock.writeLock().lock();
        this.mLocationMap.clear();
        this.setHotHead(null);
        this.setColdHead(null);
        this.mCurSize = 0;
        this.mHotSize = 0;
        this.mLock.writeLock().unlock();
    }

    public final int size() {
        return this.mCurSize;
    }

    public final int maxSize() {
        return this.mMaxSize;
    }

    public final int maxHotSize() {
        return this.mMaxHotSize;
    }

    public String toString() {
        return "HotEndLruCache{mCurSize=" + this.mCurSize + ", mMaxSize=" + this.mMaxSize + ", mHotSize=" + this.mHotSize + ", mMaxHotSize=" + this.mMaxHotSize + ", mHotHead=" + this.mHotHead + ", mColdHead=" + this.mColdHead + '}';
    }

    public static interface TraverseCallback<K, V> {
        public boolean onTraverse(@NonNull K var1, @NonNull V var2);
    }
}

