/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.logger.perf;

import com.yy.base.env.ConstDef;
import com.yy.base.logger.MLog;
import com.yy.base.logger.PathLog;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class PerfActionLog {
    public static final String TAG_START_UP = "StarupPerfActionLog";
    public static final String TAG_CHANNEL_OPT = "ChannelOptPerfActionLog";
    public static final String START_MAINPROCESS_PREFIX = "StartMainProcess_";
    public static final String TASK_PREFIX = "Task_";
    public static final String FILE_PREFIX = "File_";
    public static final String IPC_PREFIX = "IPC_";
    public static final String DATA_PARSE_PREFIX = "DataParse_";
    public static final String NET_PREFIX = "Net_";
    public static final String IMAGELOADER_PREFIX = "ImageLoader_";
    public static final String DOWNLODER_PREFIX = "Downloader_";
    public static final String VIEW_CREATE_PREFIX = "ViewCreate_";
    public static final String SHAREDP_INIT_PREFIX = "SharedPInit_";
    public static final String SHAREDP_SAVE_PREFIX = "SharedPSave_";
    public static final String THREAD_CREATE_PREFIX = "ThreadCreate_";
    public static final String CONTROLLER_CREATE_PREFIX = "ControllerCreate_";
    public static final String MODULELOADER_CREATE_PREFIX = "ModuleLoad_";
    public static final String SERVICE_REGISTER_PREFIX = "ServiceRegister_";
    public static final String SERVICE_CREATE_PREFIX = "ServiceCreate_";
    public static final String MSG_HANDLER_PREFIX = "MsgHandler_";
    public static final String DATABOX_PREFIX = "DataBox_";
    public static final String MAIN_LOOPER_PREFIX = "MainLooper_";
    private static boolean sSwitchOn = false;
    private static final ArrayList<PathLog.IPathLogItem> sPathLogItems = new ArrayList(2);
    private static final HashMap<String, PathLog.IPathLogItem> sKeyAndItems = new HashMap(2);

    public static void setSwitch(boolean switchOn) {
        if (SystemUtils.isShowEnvSetting()) {
            sSwitchOn = switchOn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(String tag, String startMsgFromat, Object ... args) {
        if (!sSwitchOn) {
            return;
        }
        ArrayList<PathLog.IPathLogItem> arrayList = sPathLogItems;
        synchronized (arrayList) {
            PathLog.IPathLogItem item = PathLog.startWithInfoLevel(tag, startMsgFromat, args);
            sPathLogItems.add(item);
            sKeyAndItems.put(tag, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(String msgFormat, Object ... args) {
        if (!sSwitchOn) {
            return;
        }
        msgFormat = msgFormat + " " + Thread.currentThread().toString();
        ArrayList<PathLog.IPathLogItem> arrayList = sPathLogItems;
        synchronized (arrayList) {
            for (PathLog.IPathLogItem item : sPathLogItems) {
                item.add(msgFormat, args);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void end(String tag, String msgFormat, Object ... args) {
        if (!sSwitchOn) {
            return;
        }
        PathLog.IPathLogItem item = null;
        ArrayList<PathLog.IPathLogItem> arrayList = sPathLogItems;
        synchronized (arrayList) {
            item = sKeyAndItems.get(tag);
            if (item != null) {
                sPathLogItems.remove(item);
                sKeyAndItems.remove(tag);
            }
        }
        if (item != null) {
            String logRootDir = FileStorageUtils.getInstance().getDirAndCreate(true, ConstDef.LOG_DIR).getAbsolutePath();
            String exceptionTxt = logRootDir + File.separator + "PerfActionLog.txt";
            File file = new File(exceptionTxt);
            if (YYFileUtils.isFileExisted(file.getAbsolutePath()) && file.length() > 0x1400000L) {
                MLog.error((Object)"PerfActionLog", " delete by file exceed size!", new Object[0]);
                try {
                    YYFileUtils.delete(file);
                }
                catch (Exception e) {
                    MLog.error((Object)"PerfActionLog", " delete" + e.toString(), new Object[0]);
                }
            }
            MLog.info("PerfActionLog", "end filesize:%s", file.length());
            item.endToFile(file, "End!\n", new Object[0]);
        }
    }
}

