/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp.request;

import com.yy.base.okhttp.callback.Callback;
import com.yy.base.okhttp.request.RequestCall;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public abstract class OkHttpRequest {
    protected String url;
    protected Object tag;
    protected Map<String, String> params;
    protected Map<String, String> headers;
    protected int id;
    protected Request.Builder builder = new Request.Builder();
    protected OkHttpClient executor;
    private String originUrl;

    protected OkHttpRequest(OkHttpClient executor, String url, Object tag, Map<String, String> params, Map<String, String> headers, int id2) {
        this.executor = executor;
        this.url = url;
        this.originUrl = url;
        this.tag = tag;
        this.params = params;
        this.headers = headers;
        this.id = id2;
        if (url == null) {
            throw new IllegalArgumentException("url can not be null.");
        }
        this.initBuilder();
    }

    private void initBuilder() {
        this.builder.url(this.url).tag(this.tag);
        this.appendHeaders();
    }

    public void replaceUrl(String url) {
        this.url = url;
        this.initBuilder();
    }

    protected abstract RequestBody buildRequestBody();

    protected RequestBody wrapRequestBody(RequestBody requestBody, Callback callback) {
        return requestBody;
    }

    protected abstract Request.Builder buildRequest(RequestBody var1);

    public RequestCall build() {
        return new RequestCall(this);
    }

    public Request.Builder generateRequest(Callback callback) {
        RequestBody requestBody = this.buildRequestBody();
        RequestBody wrappedRequestBody = this.wrapRequestBody(requestBody, callback);
        Request.Builder request = this.buildRequest(wrappedRequestBody);
        return request;
    }

    protected void appendHeaders() {
        Headers.Builder headerBuilder = new Headers.Builder();
        if (this.headers == null || this.headers.isEmpty()) {
            return;
        }
        for (String key : this.headers.keySet()) {
            headerBuilder.add(key, this.headers.get(key));
        }
        this.builder.headers(headerBuilder.build());
    }

    public int getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public final String getOrigin() {
        return this.originUrl;
    }

    public OkHttpClient getOkHttpClient() {
        return this.executor;
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            return null;
        }
        return new HashMap<String, String>(this.headers);
    }
}

