/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request;

import androidx.annotation.Nullable;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.RequestCoordinator;

public final class ErrorRequestCoordinator
implements RequestCoordinator,
Request {
    @Nullable
    private final RequestCoordinator parent;
    private Request primary;
    private Request error;

    public ErrorRequestCoordinator(@Nullable RequestCoordinator parent) {
        this.parent = parent;
    }

    public void setRequests(Request primary, Request error) {
        this.primary = primary;
        this.error = error;
    }

    @Override
    public void begin() {
        if (!this.primary.isRunning()) {
            this.primary.begin();
        }
    }

    @Override
    public void clear() {
        this.primary.clear();
        if (this.error.isRunning()) {
            this.error.clear();
        }
    }

    @Override
    public boolean isRunning() {
        return this.primary.isFailed() ? this.error.isRunning() : this.primary.isRunning();
    }

    @Override
    public boolean isComplete() {
        return this.primary.isFailed() ? this.error.isComplete() : this.primary.isComplete();
    }

    @Override
    public boolean isResourceSet() {
        return this.primary.isFailed() ? this.error.isResourceSet() : this.primary.isResourceSet();
    }

    @Override
    public boolean isCleared() {
        return this.primary.isFailed() ? this.error.isCleared() : this.primary.isCleared();
    }

    @Override
    public boolean isFailed() {
        return this.primary.isFailed() && this.error.isFailed();
    }

    @Override
    public void recycle() {
        this.primary.recycle();
        this.error.recycle();
    }

    @Override
    public boolean isEquivalentTo(Request o) {
        if (o instanceof ErrorRequestCoordinator) {
            ErrorRequestCoordinator other = (ErrorRequestCoordinator)o;
            return this.primary.isEquivalentTo(other.primary) && this.error.isEquivalentTo(other.error);
        }
        return false;
    }

    @Override
    public boolean canSetImage(Request request) {
        return this.parentCanSetImage() && this.isValidRequest(request);
    }

    private boolean parentCanSetImage() {
        return this.parent == null || this.parent.canSetImage(this);
    }

    @Override
    public boolean canNotifyStatusChanged(Request request) {
        return this.parentCanNotifyStatusChanged() && this.isValidRequest(request);
    }

    @Override
    public boolean canNotifyCleared(Request request) {
        return this.parentCanNotifyCleared() && this.isValidRequest(request);
    }

    private boolean parentCanNotifyCleared() {
        return this.parent == null || this.parent.canNotifyCleared(this);
    }

    private boolean parentCanNotifyStatusChanged() {
        return this.parent == null || this.parent.canNotifyStatusChanged(this);
    }

    private boolean isValidRequest(Request request) {
        return request.equals(this.primary) || this.primary.isFailed() && request.equals(this.error);
    }

    @Override
    public boolean isAnyResourceSet() {
        return this.parentIsAnyResourceSet() || this.isResourceSet();
    }

    private boolean parentIsAnyResourceSet() {
        return this.parent != null && this.parent.isAnyResourceSet();
    }

    @Override
    public void onRequestSuccess(Request request) {
        if (this.parent != null) {
            this.parent.onRequestSuccess(this);
        }
    }

    @Override
    public void onRequestFailed(Request request) {
        if (!request.equals(this.error)) {
            if (!this.error.isRunning()) {
                this.error.begin();
            }
            return;
        }
        if (this.parent != null) {
            this.parent.onRequestFailed(this);
        }
    }
}

