/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp.websocket.ws;

import com.yy.base.env.RuntimeContext;
import com.yy.base.okhttp.websocket.StatInitDelegate;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import java.util.HashMap;

public class WsStat {
    private static final String ACT_WS_PERFORMANCE = "wsperf";
    private static final String SUCESS = "0";
    private static final String CONNECTED = "1";
    private static final String CONNECTING = "0";
    private static final String CODE = "code";
    private static final String ABVALUE = "ab_value";
    private static final String CONNECTTIMES = "connect_times";
    private static final String ERRMSG = "err_msg";
    private static final String USETIME = "use_time";
    private static final String PONGTIMES = "pong_times";
    private static final String CONNECT_STATUS = "connect_status";
    private static final String IS_FIRST = "is_first";
    private static final String SESSION_ID = "session_id";
    private static final String IS_FRONT = "is_front";

    public static void statWsOpenSucess(int connectionTimes, long useTime, int pongTimes, boolean isFirst, long timestampId) {
        if (!StatInitDelegate.isStatSwitchOn(ACT_WS_PERFORMANCE, "")) {
            return;
        }
        HashMap<String, String> statMap = new HashMap<String, String>();
        statMap.put(CODE, "0");
        statMap.put(CONNECTTIMES, connectionTimes + "");
        statMap.put(USETIME, useTime + "");
        statMap.put(PONGTIMES, pongTimes + "");
        statMap.put(CONNECT_STATUS, "0");
        statMap.put(IS_FIRST, isFirst ? CONNECTED : "0");
        statMap.put(SESSION_ID, timestampId + "");
        statMap.put(IS_FRONT, RuntimeContext.sIsForeground ? CONNECTED : "0");
        StatInitDelegate.stat(statMap, ACT_WS_PERFORMANCE, false);
    }

    public static void statWsFail(boolean isConnected, boolean isFirst, int connectionTimes, long useTime, int pongTimes, String errmsg, int code, long timestampId) {
        if (!StatInitDelegate.isStatSwitchOn(ACT_WS_PERFORMANCE, "")) {
            return;
        }
        code = NetworkUtils.isNetworkAvailable(RuntimeContext.sApplicationContext) ? (StringUtils.equalsIgnoreCase("" + code, "0") ? 111 : code) : 250;
        HashMap<String, String> statMap = new HashMap<String, String>();
        statMap.put(CODE, code + "");
        statMap.put(CONNECTTIMES, connectionTimes + "");
        statMap.put(USETIME, useTime + "");
        statMap.put(PONGTIMES, pongTimes + "");
        statMap.put(ERRMSG, errmsg);
        statMap.put(CONNECT_STATUS, isConnected ? CONNECTED : "0");
        statMap.put(IS_FIRST, isFirst ? CONNECTED : "0");
        statMap.put(SESSION_ID, timestampId + "");
        statMap.put(IS_FRONT, RuntimeContext.sIsForeground ? CONNECTED : "0");
        StatInitDelegate.stat(statMap, ACT_WS_PERFORMANCE, false);
    }
}

