/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor;

import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.DefaultThreadFactory;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class YYProxyScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static boolean sUseProxy = true;
    private int corePoolSize = 0;
    private int maxCorePoolSize = 1;
    private long keepAliveTime = 0L;
    private TimeUnit unit;
    private ThreadFactory defaultThreadFactory;
    private RejectedExecutionHandler handler;
    private ArrayList<ScheduledFuture<?>> fixedScheduledFutures = new ArrayList(12);
    private ArrayList<WeakReference<ScheduledFuture<?>>> delayScheduledFutures = new ArrayList(12);
    private static RejectedExecutionHandler sHandler = new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        }
    };

    public YYProxyScheduledThreadPoolExecutor(int corePoolSize, String tag) {
        this(corePoolSize, null, null, tag);
    }

    public YYProxyScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, String tag) {
        this(corePoolSize, threadFactory, null, tag);
    }

    public YYProxyScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler, String tag) {
        this(corePoolSize, null, handler, tag);
    }

    public YYProxyScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler, String tag) {
        this(corePoolSize, Integer.MAX_VALUE, 10L, TimeUnit.MILLISECONDS, threadFactory, handler, tag);
    }

    public YYProxyScheduledThreadPoolExecutor(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory defaultThreadFactory, RejectedExecutionHandler handler, String tag) {
        super(1, new DefaultThreadFactory("YYScheduledTask-"));
        this.corePoolSize = corePoolSize;
        this.maxCorePoolSize = maxPoolSize;
        this.unit = unit;
        this.keepAliveTime = keepAliveTime;
        this.defaultThreadFactory = defaultThreadFactory;
        this.handler = handler;
    }

    private ScheduledThreadPoolExecutor getRealExecutor() {
        return YYTaskExecutor.getScheduledThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        ScheduledFuture<?> task = this.getRealExecutor().scheduleAtFixedRate(command, initialDelay, period, unit);
        MyScheduledFuture myScheduledFuture = new MyScheduledFuture(task, command);
        ArrayList<ScheduledFuture<?>> arrayList = this.fixedScheduledFutures;
        synchronized (arrayList) {
            this.fixedScheduledFutures.add(myScheduledFuture);
        }
        return myScheduledFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (delay <= 0L) {
            return this.getRealExecutor().schedule(command, delay, unit);
        }
        ScheduledFuture<?> task = this.getRealExecutor().schedule(command, delay, unit);
        ArrayList<WeakReference<ScheduledFuture<?>>> arrayList = this.delayScheduledFutures;
        synchronized (arrayList) {
            this.delayScheduledFutures.add(new WeakReference(task));
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledFuture<?> schedule(Callable callable, long delay, TimeUnit unit) {
        if (delay <= 0L) {
            return this.getRealExecutor().schedule(callable, delay, unit);
        }
        ScheduledFuture task = this.getRealExecutor().schedule(callable, delay, unit);
        ArrayList<WeakReference<ScheduledFuture<?>>> arrayList = this.delayScheduledFutures;
        synchronized (arrayList) {
            this.delayScheduledFutures.add(new WeakReference(task));
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        ScheduledFuture<?> task = this.getRealExecutor().scheduleWithFixedDelay(command, initialDelay, delay, unit);
        MyScheduledFuture myScheduledFuture = new MyScheduledFuture(task, command);
        ArrayList<ScheduledFuture<?>> arrayList = this.fixedScheduledFutures;
        synchronized (arrayList) {
            this.fixedScheduledFutures.add(myScheduledFuture);
        }
        return myScheduledFuture;
    }

    @Override
    public void execute(Runnable command) {
        this.getRealExecutor().execute(command);
    }

    @Override
    public void shutdown() {
        this.cancelAllScheduledFutures();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.cancelAllScheduledFutures();
        return new ArrayList<Runnable>(0);
    }

    @Override
    public void allowCoreThreadTimeOut(boolean value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllScheduledFutures() {
        ArrayList<Object> arrayList = this.fixedScheduledFutures;
        synchronized (arrayList) {
            for (ScheduledFuture<?> task : this.fixedScheduledFutures) {
                try {
                    task.cancel(false);
                }
                catch (Throwable e) {
                    if (SystemUtils.isShowEnvSetting()) {
                        throw new RuntimeException(e);
                    }
                    MLog.error("YYProxyScheduledThreadPoolExecutor", e);
                }
            }
            this.fixedScheduledFutures.clear();
        }
        arrayList = this.delayScheduledFutures;
        synchronized (arrayList) {
            ScheduledFuture item = null;
            for (WeakReference<ScheduledFuture<?>> taskWeak : this.delayScheduledFutures) {
                item = (ScheduledFuture)taskWeak.get();
                try {
                    if (item == null || item.isDone()) continue;
                    item.cancel(false);
                }
                catch (Throwable e) {
                    if (SystemUtils.isShowEnvSetting()) {
                        throw new RuntimeException(e);
                    }
                    MLog.error("YYProxyScheduledThreadPoolExecutor", e);
                }
            }
            this.delayScheduledFutures.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMyScheduledFutureCanceled(MyScheduledFuture task) {
        ArrayList<ScheduledFuture<?>> arrayList = this.fixedScheduledFutures;
        synchronized (arrayList) {
            this.fixedScheduledFutures.remove(task);
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return true;
    }

    public Future<?> submit(Callable task) {
        return this.getRealExecutor().submit(task);
    }

    public Future<?> submit(Runnable task, Object result) {
        return this.getRealExecutor().submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.getRealExecutor().submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.getRealExecutor().invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.getRealExecutor().invokeAll(tasks, timeout, unit);
    }

    private class MyScheduledFuture
    implements ScheduledFuture<Object> {
        private ScheduledFuture scheduledFuture = null;

        public MyScheduledFuture(ScheduledFuture real, Runnable command) {
            this.scheduledFuture = real;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.scheduledFuture.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.scheduledFuture.compareTo(o);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            YYProxyScheduledThreadPoolExecutor.this.onMyScheduledFutureCanceled(this);
            return this.scheduledFuture.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.scheduledFuture.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.scheduledFuture.isDone();
        }

        @Override
        public Object get() throws ExecutionException, InterruptedException {
            return this.scheduledFuture.get();
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            return this.scheduledFuture.get(timeout, unit);
        }
    }
}

