/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.ExifInterface;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.util.Util;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageConfig;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import java.util.regex.Pattern;

public class ImageUtil {
    private static final String TAG = "ImageUtil";
    private static Pattern urlPattern = Pattern.compile("[a-zA-Z_0-9\\.\\-\\(\\)\\%]+");

    private static String getCacheKey(String url, int width, int height) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }
        return new StringBuilder(url.length() + 12).append("#W").append(width).append("#H").append(height).append(url).toString();
    }

    public static void loadImageResource(int resource, RecycleImageView recycleImageView, ImageConfig imageConfig) {
        if (recycleImageView == null) {
            MLog.error((Object)TAG, "recycleImageView is null", new Object[0]);
            return;
        }
        BitmapDrawable resourceDrawable = ImageUtil.getBitmapDrawableFromResource(imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight(), resource);
        recycleImageView.setImageDrawable((Drawable)resourceDrawable);
    }

    public static void loadImageResource(String resource, RecycleImageView recycleImageView, ImageConfig imageConfig, int blankBitmapResource) {
        if (recycleImageView == null) {
            MLog.error((Object)TAG, "recycleImageView is null", new Object[0]);
            return;
        }
        int resourceId = RuntimeContext.sApplicationContext.getResources().getIdentifier(resource, "drawable", RuntimeContext.sApplicationContext.getPackageName());
        if (resourceId == 0) {
            resourceId = blankBitmapResource;
        }
        BitmapDrawable resourceDrawable = ImageUtil.getBitmapDrawableFromResource(imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight(), resourceId);
        recycleImageView.setImageDrawable((Drawable)resourceDrawable);
    }

    public static void loadImageBackgroundResource(int resource, View view, ImageConfig imageConfig) {
        if (view == null) {
            return;
        }
        BitmapDrawable resourceDrawable = ImageUtil.getBitmapDrawableFromResource(imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight(), resource);
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground((Drawable)resourceDrawable);
        } else {
            view.setBackgroundDrawable((Drawable)resourceDrawable);
        }
    }

    public static void loadImageBackgroundResource(String resource, View view, ImageConfig imageConfig, int blankBitmapResource) {
        if (view == null) {
            return;
        }
        int resourceId = RuntimeContext.sApplicationContext.getResources().getIdentifier(resource, "drawable", RuntimeContext.sApplicationContext.getPackageName());
        if (resourceId == 0) {
            resourceId = blankBitmapResource;
        }
        BitmapDrawable resourceDrawable = ImageUtil.getBitmapDrawableFromResource(imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight(), resourceId);
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground((Drawable)resourceDrawable);
        } else {
            view.setBackgroundDrawable((Drawable)resourceDrawable);
        }
    }

    public static void loadImageBackgroundResource(String resource, RecycleImageView recycleImageView, ImageConfig imageConfig, int blankBitmapResource) {
        if (recycleImageView == null) {
            MLog.error((Object)TAG, "recycleImageView is null", new Object[0]);
            return;
        }
        int resourceId = RuntimeContext.sApplicationContext.getResources().getIdentifier(resource, "drawable", RuntimeContext.sApplicationContext.getPackageName());
        if (resourceId == 0) {
            resourceId = blankBitmapResource;
        }
        BitmapDrawable resourceDrawable = ImageUtil.getBitmapDrawableFromResource(imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight(), resourceId);
        recycleImageView.setBackgroundDrawable((Drawable)resourceDrawable);
    }

    public static BitmapDrawable getBitmapDrawableFromResource(int imageWidth, int imageHeight, int loadingBitmapResource) {
        String key = ImageUtil.getCacheKey(String.valueOf(loadingBitmapResource), imageWidth, imageHeight);
        BitmapDrawable loadingBitmapDrawable = ImageLoader.getBitmapFromCache(key);
        if (loadingBitmapDrawable == null && loadingBitmapResource > 0) {
            Bitmap loadingBitmap = ImageUtil.decodeSampledBitmapFromResourceId(RuntimeContext.sApplicationContext, loadingBitmapResource, imageWidth, imageHeight, null);
            loadingBitmapDrawable = Build.VERSION.SDK_INT > 11 ? new BitmapDrawable(RuntimeContext.sApplicationContext.getResources(), loadingBitmap) : new BitmapDrawable(RuntimeContext.sApplicationContext.getResources(), loadingBitmap);
            if (loadingBitmap != null) {
                ImageLoader.addBitmapToCache(key, loadingBitmapDrawable);
            }
        }
        return loadingBitmapDrawable;
    }

    public static BitmapDrawable getBitmapDrawableFromResource(int loadingBitmapResource, ImageConfig config) {
        String key = ImageUtil.getCacheKey(String.valueOf(loadingBitmapResource), config.getImagePrecision().getWidth(), config.getImagePrecision().getHeight());
        BitmapDrawable loadingBitmapDrawable = ImageLoader.getBitmapFromCache(key);
        if (loadingBitmapDrawable == null && loadingBitmapResource > 0) {
            Bitmap loadingBitmap = ImageUtil.decodeSampledBitmapFromResourceId(RuntimeContext.sApplicationContext, loadingBitmapResource, config);
            loadingBitmapDrawable = Build.VERSION.SDK_INT > 11 ? new BitmapDrawable(RuntimeContext.sApplicationContext.getResources(), loadingBitmap) : new BitmapDrawable(RuntimeContext.sApplicationContext.getResources(), loadingBitmap);
            if (loadingBitmap != null) {
                ImageLoader.addBitmapToCache(key, loadingBitmapDrawable);
            }
        }
        return loadingBitmapDrawable;
    }

    public static Bitmap decodeSampledBitmapFile(String path, ImageConfig config) {
        return ImageUtil.decodeSampledBitmapFile(path, config, false);
    }

    public static Bitmap decodeSampledBitmapFile(String path, ImageConfig config, boolean rorate) {
        if (path == null || path.length() == 0) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inPreferredConfig = config.getImageTransparency().getBitmapConfig();
            options.inJustDecodeBounds = true;
            YYImageUtils.decodeFile(path, options);
            options.inSampleSize = ImageUtil.calculateInSampleSize(options, config.getImagePrecision().getWidth(), config.getImagePrecision().getHeight());
            options.inJustDecodeBounds = false;
            bitmap = YYImageUtils.decodeFile(path, options);
        }
        catch (OutOfMemoryError e) {
            MLog.error((Object)TAG, "Decode file oom.", new Object[0]);
            System.gc();
        }
        if (rorate) {
            bitmap = ImageUtil.rorateBitmap(path, bitmap);
        }
        return bitmap;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            int n = inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
            if (inSampleSize <= 0) {
                inSampleSize = 1;
            }
            float totalPixels = width * height;
            float totalReqPixelsCap = reqWidth * reqHeight * 2;
            while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixelsCap || ImageUtil.isBitmapOverSize(inSampleSize, width, height)) {
                ++inSampleSize;
            }
        }
        return inSampleSize;
    }

    public static Bitmap rorateBitmap(String filePath, Bitmap bitmap) {
        Bitmap resizedBitmap = null;
        try {
            ExifInterface exif = new ExifInterface(filePath);
            int orientation = exif.getAttributeInt("Orientation", 1);
            Matrix matrix = new Matrix();
            int rotate = 0;
            switch (orientation) {
                case 8: {
                    rotate = 270;
                    break;
                }
                case 3: {
                    rotate = 180;
                    break;
                }
                case 6: {
                    rotate = 90;
                    break;
                }
                case 5: {
                    rotate = 45;
                    break;
                }
            }
            matrix.postRotate((float)rotate);
            resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, "RotateBitmap error", new Object[0]);
            return bitmap;
        }
        return resizedBitmap;
    }

    public static boolean isBitmapOverSize(int sampleSize, int width, int height) {
        int correctSampleSize = sampleSize;
        if (sampleSize > 2) {
            correctSampleSize = sampleSize / 2 * 2;
        }
        return width / correctSampleSize > 4096 || height / correctSampleSize > 4096;
    }

    public static Bitmap decodeSampledBitmapFromResourceId(Context context, int resourceId, ImageConfig config) {
        return ImageUtil.decodeSampledBitmapFromResourceId(context, resourceId, config.getImagePrecision().getWidth(), config.getImagePrecision().getHeight(), config);
    }

    public static Bitmap decodeSampledBitmapFromResourceId(Context context, int resourceId, int reqWidth, int reqHeight, ImageConfig imageConfig) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inPreferredConfig = imageConfig != null ? imageConfig.getImageTransparency().getBitmapConfig() : Bitmap.Config.RGB_565;
        BitmapFactory.decodeResource((Resources)context.getResources(), (int)resourceId, (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtil.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        try {
            return BitmapFactory.decodeResource((Resources)context.getResources(), (int)resourceId, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError e) {
            MLog.error((Object)TAG, "decodeSampledBitmapFromResourceId oom.", new Object[0]);
            System.gc();
            return null;
        }
    }

    public static Bitmap decodeSampledBitmapFromByteArray(byte[] bytes, int reqWidth, int reqHeight, Object cache, ImageConfig imageConfig) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inPreferredConfig = imageConfig != null ? imageConfig.getImageTransparency().getBitmapConfig() : Bitmap.Config.RGB_565;
        BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
        options.inSampleSize = ImageUtil.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        if (Build.VERSION.SDK_INT > 11) {
            ImageUtil.addInBitmapOptions(options, cache);
        }
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
    }

    @TargetApi(value=11)
    private static void addInBitmapOptions(BitmapFactory.Options options, Object cache) {
    }

    public static Bitmap decodeSampledBitmapFromByteArray(byte[] bytes, ImageConfig imageConfig) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inPreferredConfig = imageConfig != null ? imageConfig.getImageTransparency().getBitmapConfig() : Bitmap.Config.RGB_565;
        BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
        options.inSampleSize = imageConfig == null ? ImageUtil.calculateInSampleSize(options, ImageConfig.defaultImageConfig().getImagePrecision().getWidth(), ImageConfig.defaultImageConfig().getImagePrecision().getHeight()) : ImageUtil.calculateInSampleSize(options, imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight());
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
    }

    public static int getBitmapSize(Bitmap bitmap) {
        if (bitmap == null) {
            return 0;
        }
        if (Build.VERSION.SDK_INT > 12) {
            return bitmap.getByteCount();
        }
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    public static void loadCorpImageWithNineBg(final RecycleImageView recycleImageView, final String url, final int placeholderNinePngId) {
        if (recycleImageView == null) {
            return;
        }
        recycleImageView.setBackgroundResource(placeholderNinePngId);
        ImageLoader.loadImage(recycleImageView, url, -1, -1, new ImageLoader.ImageLoadListener(){

            @Override
            public void onLoadFailed(Exception e) {
                if (recycleImageView != null) {
                    recycleImageView.setBackgroundResource(placeholderNinePngId);
                }
            }

            @Override
            public void onResourceReady(Object resource, boolean isFromMemoryCache, DataSource dataSource) {
                if (recycleImageView != null) {
                    recycleImageView.setBackgroundDrawable(null);
                    Log.i((String)"wuziyi", (String)"banner success null");
                }
                Log.i((String)"wuziyi", (String)("banner success url:" + url));
            }
        });
    }

    public static boolean isHttp(String url) {
        return !StringUtils.isEmpty(url) && url.startsWith("http");
    }

    public static boolean isWebPAnim(String url) {
        if (StringUtils.isEmpty(url)) {
            return false;
        }
        return url.contains("webp") && url.contains("anim");
    }

    public static boolean isWebPUrl(String url) {
        return ImageUtil.isMatchFileExtension(url, "webp");
    }

    public static boolean isGifUrl(String url) {
        return ImageUtil.isMatchFileExtension(url, "gif");
    }

    public static boolean isGif(String url) {
        return ImageUtil.isGifUrl(url);
    }

    public static boolean isPng(String url) {
        return ImageUtil.isMatchFileExtension(url, "png");
    }

    public static boolean isJpg(String url) {
        return ImageUtil.isMatchFileExtension(url, "jpg") || ImageUtil.isMatchFileExtension(url, "jpeg");
    }

    public static boolean isHeif(String url) {
        return ImageUtil.isMatchFileExtension(url, "heic") || ImageUtil.isMatchFileExtension(url, "HEIC");
    }

    private static boolean isMatchFileExtension(String url, String extName) {
        String ext = ImageUtil.getFileExtensionFromUrl(url);
        return StringUtils.equalsIgnoreCase(extName, ext);
    }

    public static boolean isValidDimensions(int width, int height) {
        return ImageUtil.isValidDimension(width) && ImageUtil.isValidDimension(height);
    }

    public static boolean isValidDimension(int dimen) {
        return dimen > 0 || dimen == Integer.MIN_VALUE;
    }

    public static int checkBitmapSize(Bitmap bitmap, String url) {
        if (url == null || bitmap == null) {
            return 0;
        }
        if (RuntimeContext.sIsDebuggable) {
            if (bitmap.isRecycled()) {
                return 0;
            }
            int bitmapSize = Util.getBitmapByteSize(bitmap);
            if (bitmapSize > 0x300000) {
                MLog.info("ImageLoader", "bitmap is over 3M, please check! url:" + url, new Object[0]);
            } else if (bitmapSize > 0x200000) {
                MLog.info("ImageLoader", "bitmap is over 2M, please check! url:" + url, new Object[0]);
            } else if (bitmapSize > 0x100000) {
                MLog.info("ImageLoader", "bitmap is over 1M, please check! url:" + url, new Object[0]);
            }
            return bitmapSize;
        }
        return 0;
    }

    public static String getFileExtensionFromUrl(String url) {
        long now = SystemClock.elapsedRealtime();
        String extension = "";
        if (!TextUtils.isEmpty((CharSequence)url)) {
            int dotPos;
            int filenamePos;
            String filename;
            int query;
            int fragment = url.lastIndexOf(35);
            if (fragment > 0) {
                url = url.substring(0, fragment);
            }
            if ((query = url.lastIndexOf(63)) > 0) {
                url = url.substring(0, query);
            }
            String string2 = filename = 0 <= (filenamePos = url.lastIndexOf(47)) ? url.substring(filenamePos + 1) : url;
            if (!filename.isEmpty() && (dotPos = filename.lastIndexOf(46)) >= 0 && urlPattern.matcher(filename).matches() && 0 <= dotPos) {
                extension = filename.substring(dotPos + 1);
            }
        }
        return extension;
    }
}

