/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.thread;

import android.os.Process;
import androidx.annotation.NonNull;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class PriorityThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final int mPriority;

    public PriorityThreadFactory(String poolName, int priority) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = "pool-" + poolName + "-" + poolNumber.getAndIncrement() + "-thread-" + priority + "-";
        this.mPriority = priority;
    }

    @Override
    public Thread newThread(@NonNull Runnable r) {
        PriorityThread t = new PriorityThread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L, this.mPriority);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        return t;
    }

    private static class PriorityThread
    extends Thread {
        private int mPriority;

        PriorityThread(ThreadGroup group, Runnable target, String name, long stackSize, int priority) {
            super(group, target, name, stackSize);
            this.mPriority = priority;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)this.mPriority);
            super.run();
        }
    }
}

