/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SystemServiceUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class ToastCompat
extends Toast {
    private static final String TAG = "ToastCompat";

    public ToastCompat(Context context) {
        super(context);
    }

    public static Toast makeText(Context context, CharSequence text, int duration) {
        ToastCompat result = new ToastCompat(context);
        Resources resources = context.getResources();
        View v = SystemServiceUtils.getLayoutInflater(context).inflate(resources.getIdentifier("transient_notification", "layout", "android"), null);
        TextView tv = (TextView)v.findViewById(resources.getIdentifier("message", "id", "android"));
        tv.setText(text);
        result.setView(v);
        result.setDuration(duration);
        return result;
    }

    public static Toast makeText(Context context, int resId, int duration) throws Resources.NotFoundException {
        return ToastCompat.makeText(context, context.getResources().getText(resId), duration);
    }

    public void show() {
        if (ToastCompat.needToHack()) {
            this.tryToHack();
        }
        super.show();
    }

    public static boolean needToHack() {
        return Build.VERSION.SDK_INT == 25;
    }

    private void tryToHack() {
        try {
            Object mTN = ToastCompat.getFieldValue((Object)this, "mTN");
            if (mTN != null) {
                Object rawHandler;
                boolean isSuccess = false;
                Object rawShowRunnable = ToastCompat.getFieldValue(mTN, "mShow");
                if (rawShowRunnable != null && rawShowRunnable instanceof Runnable) {
                    isSuccess = ToastCompat.setFieldValue(mTN, "mShow", new InternalRunnable((Runnable)rawShowRunnable));
                }
                if (!isSuccess && (rawHandler = ToastCompat.getFieldValue(mTN, "mHandler")) != null && rawHandler instanceof Handler) {
                    isSuccess = ToastCompat.setFieldValue(rawHandler, "mCallback", new InternalHandlerCallback((Handler)rawHandler));
                }
                if (!isSuccess) {
                    MLog.info(TAG, "tryToHack error.", new Object[0]);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static boolean setFieldValue(Object object, String fieldName, Object newFieldValue) {
        Field field = ToastCompat.getDeclaredField(object, fieldName);
        if (field != null) {
            try {
                int accessFlags = field.getModifiers();
                if (Modifier.isFinal(accessFlags)) {
                    Field modifiersField = Field.class.getDeclaredField("accessFlags");
                    modifiersField.setAccessible(true);
                    modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                }
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set(object, newFieldValue);
                return true;
            }
            catch (Exception e) {
                MLog.error(TAG, e);
            }
        }
        return false;
    }

    private static Object getFieldValue(Object obj, String fieldName) {
        Field field = ToastCompat.getDeclaredField(obj, fieldName);
        return ToastCompat.getFieldValue(obj, field);
    }

    private static Object getFieldValue(Object obj, Field field) {
        if (field != null) {
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return field.get(obj);
            }
            catch (Exception e) {
                MLog.error(TAG, e);
            }
        }
        return null;
    }

    private static Field getDeclaredField(Object obj, String fieldName) {
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                return field;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    private class InternalHandlerCallback
    implements Handler.Callback {
        private final Handler mHandler;

        public InternalHandlerCallback(Handler mHandler) {
            this.mHandler = mHandler;
        }

        public boolean handleMessage(Message msg) {
            try {
                this.mHandler.handleMessage(msg);
            }
            catch (Throwable e) {
                MLog.error(ToastCompat.TAG, e);
            }
            return true;
        }
    }

    private class InternalRunnable
    implements Runnable {
        private final Runnable mRunnable;

        public InternalRunnable(Runnable mRunnable) {
            this.mRunnable = mRunnable;
        }

        @Override
        public void run() {
            try {
                this.mRunnable.run();
            }
            catch (Throwable e) {
                MLog.error(ToastCompat.TAG, e);
            }
        }
    }
}

