/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader;

import android.app.Activity;
import android.app.Application;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.yy.base.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.IRecycler;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.imageloader.webpanim.decoder.WebpDrawable;
import com.yy.base.logger.MLog;

public class GifHandler {
    private static final String TAG = "ImageAuto_GifHandler";
    private static IRecycler sRecycler;
    private static IRecoverInterceptor sRecoverInterceptor;

    public static void init(Application application, IRecycler recycler) {
        sRecycler = recycler;
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
                GifHandler.restartGif(activity);
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
                GifHandler.stopGif(activity);
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        });
    }

    private static void stopGif(Activity activity) {
        View rootView = activity.getWindow().getDecorView();
        if (rootView instanceof ViewGroup) {
            rootView.setTag(R.id.yy_gif_auto_pause_id, (Object)true);
        }
    }

    public static void stopGif(ViewGroup viewGroup) {
        if (viewGroup == null) {
            return;
        }
        viewGroup.setTag(R.id.yy_gif_auto_pause_id, (Object)true);
    }

    private static void restartGif(Activity activity) {
        View rootView = activity.getWindow().getDecorView();
        if (rootView instanceof ViewGroup) {
            rootView.setTag(R.id.yy_gif_auto_pause_id, (Object)false);
            GifHandler.restartGif((ViewGroup)rootView);
        }
    }

    private static boolean restartGif(ImageView child) {
        if (child == null) {
            return false;
        }
        if (child instanceof RecycleImageView) {
            Drawable drawable2;
            boolean needCheckGifRestart;
            boolean bl = needCheckGifRestart = child.getTag(R.id.yy_gif_set_visible) instanceof Boolean ? (Boolean)child.getTag(R.id.yy_gif_set_visible) : false;
            if (needCheckGifRestart && !GifHandler.needPauseGif((RecycleImageView)child) && ((drawable2 = ((RecycleImageView)child).getImageDrawableInner()) instanceof GifDrawable || drawable2 instanceof WebpDrawable)) {
                child.setTag(R.id.yy_gif_set_visible, (Object)false);
                drawable2.setVisible(true, true);
                if (RuntimeContext.isInGray()) {
                    MLog.info(TAG, "restartGif:%s", child.toString());
                }
                return true;
            }
        }
        return false;
    }

    public static void restartGif(ViewGroup viewGroup) {
        View view;
        if (sRecoverInterceptor != null && (view = sRecoverInterceptor.getRecoverView(viewGroup)) != viewGroup) {
            if (view instanceof ViewGroup) {
                viewGroup = (ViewGroup)view;
                GifHandler.restartGif(viewGroup);
            } else if (view instanceof ImageView) {
                GifHandler.restartGif((ImageView)view);
            }
            return;
        }
        if (viewGroup != null) {
            viewGroup.setTag(R.id.yy_gif_auto_pause_id, (Object)false);
        }
        int childSize = viewGroup.getChildCount();
        View child = null;
        for (int i = 0; i < childSize; ++i) {
            child = viewGroup.getChildAt(i);
            if (child == null) continue;
            if (child instanceof ViewGroup) {
                GifHandler.restartGif((ViewGroup)child);
                continue;
            }
            if (!(child instanceof ImageView)) continue;
            GifHandler.restartGif((ImageView)child);
        }
    }

    public static void onImageDrawableUpdated(RecycleImageView imageView, Drawable drawable2) {
    }

    public static void onDraw(RecycleImageView recycleImageView, Drawable drawable2) {
        if (recycleImageView == null) {
            return;
        }
        if (drawable2 instanceof GifDrawable || drawable2 instanceof WebpDrawable) {
            boolean needCheckGifRestart;
            boolean bl = needCheckGifRestart = recycleImageView.getTag(R.id.yy_gif_set_visible) instanceof Boolean ? (Boolean)recycleImageView.getTag(R.id.yy_gif_set_visible) : false;
            if (needCheckGifRestart) {
                if (!drawable2.isVisible()) {
                    if (!GifHandler.needPauseGif(recycleImageView)) {
                        recycleImageView.setTag(R.id.yy_gif_set_visible, false);
                        drawable2.setVisible(true, true);
                        if (RuntimeContext.isInGray()) {
                            MLog.info(TAG, "restartGif:%s", recycleImageView);
                        }
                    }
                } else {
                    recycleImageView.setTag(R.id.yy_gif_set_visible, false);
                }
            }
        }
    }

    public static void invalidateDrawable(RecycleImageView recycleImageView, Drawable dr) {
        if (recycleImageView == null) {
            return;
        }
        if (dr instanceof GifDrawable || dr instanceof WebpDrawable) {
            if (dr.isVisible()) {
                if (GifHandler.needPauseGif(recycleImageView)) {
                    dr.setVisible(false, false);
                    recycleImageView.setTag(R.id.yy_gif_set_visible, true);
                    if (RuntimeContext.isInGray()) {
                        MLog.info(TAG, "pauseGif:%s", recycleImageView.toString());
                    }
                } else {
                    recycleImageView.setTag(R.id.yy_gif_set_visible, false);
                }
            } else {
                boolean needCheckGifRestart;
                boolean bl = needCheckGifRestart = recycleImageView.getTag(R.id.yy_gif_set_visible) instanceof Boolean ? (Boolean)recycleImageView.getTag(R.id.yy_gif_set_visible) : false;
                if (needCheckGifRestart && !GifHandler.needPauseGif(recycleImageView)) {
                    recycleImageView.setTag(R.id.yy_gif_set_visible, false);
                    dr.setVisible(true, true);
                    if (RuntimeContext.isInGray()) {
                        MLog.info(TAG, "restart:%s", recycleImageView.toString());
                    }
                }
            }
        }
    }

    public static void onVisibilityChanged(RecycleImageView view, int visibility) {
        if (visibility != 0) {
            view.setTag(R.id.yy_gif_set_visible, false);
        }
    }

    private static boolean needPauseGif(RecycleImageView recycleImageView) {
        if (recycleImageView == null) {
            return false;
        }
        boolean need = false;
        ViewParent parent = recycleImageView.getParent();
        if (parent == null) {
            need = true;
        } else {
            while (parent instanceof ViewGroup) {
                if (((ViewGroup)parent).getTag(R.id.yy_gif_auto_pause_id) instanceof Boolean && ((Boolean)((ViewGroup)parent).getTag(R.id.yy_gif_auto_pause_id)).booleanValue()) {
                    need = true;
                    break;
                }
                if ((parent = parent.getParent()) != null) continue;
                need = true;
                break;
            }
        }
        return need;
    }

    public static void setRecoverInterceptor(IRecoverInterceptor recoverInterceptor) {
        sRecoverInterceptor = recoverInterceptor;
    }

    public static interface IRecoverInterceptor {
        public View getRecoverView(ViewGroup var1);
    }
}

