/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.kvo.list;

import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.list.KvoList;
import com.yy.base.event.kvo.list.KvoListHelper;
import java.util.ListIterator;

public class KvoListIterator<T>
implements ListIterator<T> {
    private final KvoSource mKvoSource;
    private final String mName;
    private final ListIterator<T> mIterator;
    private final KvoList<T> mKvoList;
    private int mLastOperation = 0;

    public KvoListIterator(KvoSource kvoSource, String name, KvoList<T> list) {
        this(kvoSource, name, list, 0);
    }

    public KvoListIterator(KvoSource kvoSource, String name, KvoList<T> list, int index) {
        this.mKvoSource = kvoSource;
        this.mKvoList = list;
        this.mIterator = list.wrappedList().listIterator(index);
        this.mName = name;
    }

    @Override
    public boolean hasNext() {
        return this.mIterator.hasNext();
    }

    @Override
    public T next() {
        this.mLastOperation = 1;
        return this.mIterator.next();
    }

    @Override
    public boolean hasPrevious() {
        return this.mIterator.hasPrevious();
    }

    @Override
    public T previous() {
        this.mLastOperation = 2;
        return this.mIterator.previous();
    }

    @Override
    public int nextIndex() {
        return this.mIterator.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.mIterator.previousIndex();
    }

    @Override
    public void remove() {
        this.mIterator.remove();
        KvoListHelper.notifyRangeRemove(this.mKvoSource, this.mName, this.mKvoList, this.mIterator.nextIndex(), 1);
    }

    @Override
    public void set(T t) {
        this.mIterator.set(t);
        KvoListHelper.notifyRangeReplace(this.mKvoSource, this.mName, this.mKvoList, this.mLastOperation == 1 ? this.mIterator.previousIndex() : this.mIterator.nextIndex(), 1);
    }

    @Override
    public void add(T t) {
        this.mIterator.add(t);
        KvoListHelper.notifyInsert(this.mKvoSource, this.mName, this.mKvoList, this.mIterator.previousIndex(), 1);
    }
}

