/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.kvo;

import androidx.annotation.NonNull;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.core.EventReceiver;
import com.yy.base.event.core.helper.DefaultEventThreadWrapper;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoEventReceiver;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoHelper;
import com.yy.base.logger.MLog;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class Kvo {
    public static final String KVO_LOG_TAG = "KvoEvent";

    public static void autoBindingTo(@NonNull KvoSource source, @NonNull Object dst) {
        ArrayList<KvoHelper.KvoMethodNode> nodes = KvoHelper.getKvoMethods(source, dst);
        for (KvoHelper.KvoMethodNode node : nodes) {
            KvoMethodAnnotation annotation = node.methodAnnotation;
            source.addBinding(source.declaredKvoField((String)annotation.name()).eventAction, Kvo.buildKvoEventReceiver(annotation, dst, node.method));
        }
    }

    public static void autoBindingTo(@NonNull KvoSource source, @NonNull Object dst, int flag) {
        ArrayList<KvoHelper.KvoMethodNode> nodes = KvoHelper.getKvoMethods(source, dst);
        for (KvoHelper.KvoMethodNode node : nodes) {
            KvoMethodAnnotation annotation = node.methodAnnotation;
            if (annotation.flag() != flag) continue;
            source.addBinding(source.declaredKvoField((String)annotation.name()).eventAction, Kvo.buildKvoEventReceiver(annotation, dst, node.method));
        }
    }

    public static void autoUnbindingFrom(@NonNull KvoSource source, @NonNull Object dst) {
        ArrayList<KvoHelper.KvoMethodNode> nodes = KvoHelper.getKvoMethods(source, dst);
        for (KvoHelper.KvoMethodNode node : nodes) {
            KvoMethodAnnotation annotation = node.methodAnnotation;
            source.removeBinding(source.declaredKvoField((String)annotation.name()).eventAction, Kvo.buildKvoEventReceiver(annotation, dst, node.method));
        }
    }

    public static void autoUnbindingFrom(@NonNull KvoSource source, @NonNull Object dst, int flag) {
        ArrayList<KvoHelper.KvoMethodNode> nodes = KvoHelper.getKvoMethods(source, dst);
        for (KvoHelper.KvoMethodNode node : nodes) {
            KvoMethodAnnotation annotation = node.methodAnnotation;
            if (annotation.flag() != flag) continue;
            source.removeBinding(source.declaredKvoField((String)annotation.name()).eventAction, Kvo.buildKvoEventReceiver(annotation, dst, node.method));
        }
    }

    public static void addKvoBinding(@NonNull KvoSource source, @NonNull Object target, @NonNull String methodName) {
        block2: {
            try {
                Method method = target.getClass().getMethod(methodName, KvoEventIntent.class);
                Kvo.addKvoBinding(source, target, method);
            }
            catch (NoSuchMethodException e) {
                MLog.error((Object)KVO_LOG_TAG, "add kvo binding failed :" + e.toString(), new Object[0]);
                if (!RuntimeContext.sIsDebuggable) break block2;
                throw new RuntimeException("method " + methodName + " not found in class " + target.getClass().getName() + ", please check again");
            }
        }
    }

    public static void addKvoBinding(@NonNull KvoSource source, @NonNull Object target, @NonNull Method method) {
        KvoMethodAnnotation methodAnnotation = method.getAnnotation(KvoMethodAnnotation.class);
        if (methodAnnotation != null) {
            source.addBinding(source.declaredKvoField((String)methodAnnotation.name()).eventAction, Kvo.buildKvoEventReceiver(methodAnnotation, target, method));
        }
    }

    public static void removeKvoBinding(@NonNull KvoSource source, @NonNull Object target, @NonNull String methodName) {
        try {
            Method method = target.getClass().getMethod(methodName, KvoEventIntent.class);
            Kvo.removeKvoBinding(source, target, method);
        }
        catch (NoSuchMethodException e) {
            MLog.error((Object)KVO_LOG_TAG, "remove kvo binding failed :" + e.toString(), new Object[0]);
        }
    }

    public static void removeKvoBinding(@NonNull KvoSource source, @NonNull Object target, @NonNull Method method) {
        KvoMethodAnnotation methodAnnotation = method.getAnnotation(KvoMethodAnnotation.class);
        if (methodAnnotation != null) {
            source.removeBinding(source.declaredKvoField((String)methodAnnotation.name()).eventAction, Kvo.buildKvoEventReceiver(methodAnnotation, target, method));
        }
    }

    private static EventReceiver buildKvoEventReceiver(@NonNull KvoMethodAnnotation annotation, @NonNull Object target, @NonNull Method method) {
        return new KvoEventReceiver(target, method, DefaultEventThreadWrapper.thread(annotation.thread()), annotation.priority(), annotation.flag());
    }
}

