/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.logger;

import android.os.Looper;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.printer.AndroidPrinter;
import com.yy.base.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Locale;

public class Utils {
    private static Thread sMainThread = null;

    public static String createMessage(String messageFormat, Object ... args) {
        try {
            return args == null || args.length == 0 ? messageFormat : StringUtils.formatWitUSLocal(messageFormat, args);
        }
        catch (Exception e) {
            if (RuntimeContext.sIsDebuggable) {
                AndroidPrinter.log("E/:", "Utils format error:", e, messageFormat, new Object[0]);
            }
            return messageFormat;
        }
    }

    public static Boolean isEmpty(String str) {
        return str == null || str.equals("");
    }

    public static boolean equal(String s1, String s2) {
        return Utils.equal(s1, s2, false);
    }

    public static boolean equal(String s1, String s2, boolean ignoreCase) {
        if (s1 != null && s2 != null) {
            if (ignoreCase) {
                return s1.equalsIgnoreCase(s2);
            }
            return s1.equals(s2);
        }
        return s1 == null && s2 == null;
    }

    public static String getCurrentThreadName() {
        Thread current;
        Looper looper;
        if (sMainThread == null && (looper = Looper.getMainLooper()) != null) {
            sMainThread = looper.getThread();
        }
        if (sMainThread == (current = Thread.currentThread())) {
            return "main";
        }
        if (current.getName() == null || current.getName().length() == 0) {
            return String.valueOf(current.getId());
        }
        if (current.getId() >= 0L) {
            return current.getName() + "_" + current.getId();
        }
        return current.getName();
    }

    public static boolean ensureFileExist(File file) {
        if (file != null && !file.exists()) {
            new File(file.getParent()).mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static String format(String messageFormat, Object ... args) {
        try {
            if (messageFormat == null) {
                return "";
            }
            return args == null || args.length == 0 ? messageFormat : Utils.formatWitUSLocal(messageFormat, args);
        }
        catch (Exception e) {
            return messageFormat;
        }
    }

    public static String formatWitUSLocal(String format, Object ... args) {
        try {
            return String.format(Locale.US, format, args);
        }
        catch (Exception e) {
            return "";
        }
    }
}

