/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor.single;

import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.DefaultThreadFactory;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYScheduledThreadPoolExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class YYProxySingleScheduledExecutor
extends ScheduledThreadPoolExecutor {
    private static final String TAG = "YYProxySingleScheduled";
    private static final ScheduledThreadPoolExecutor singleThreadScheduledExecutor = new YYScheduledThreadPoolExecutor(1, "YYProxySingleScheduleOne");
    private static boolean sUseProxy = true;
    private ThreadFactory defaultThreadFactory;
    private RejectedExecutionHandler handler;
    private String tag = "";
    private IQueueTaskExecutor queueTaskExecutor;
    private ArrayList<ScheduledFuture<?>> fixedScheduledFutures = new ArrayList(12);
    private ArrayList<WeakReference<ScheduledFuture<?>>> delayScheduledFutures = new ArrayList(12);
    private static RejectedExecutionHandler sHandler = new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        }
    };

    public YYProxySingleScheduledExecutor(String tag) {
        this(null, tag);
    }

    public YYProxySingleScheduledExecutor(ThreadFactory threadFactory, String tag) {
        this(threadFactory, null, tag);
    }

    public YYProxySingleScheduledExecutor(ThreadFactory defaultThreadFactory, RejectedExecutionHandler handler, String tag) {
        super(1, new DefaultThreadFactory("YYProxySingleScheduled-" + (tag == null ? "" : tag)));
        this.defaultThreadFactory = defaultThreadFactory;
        this.handler = handler;
        this.tag = tag == null ? "" : tag;
        this.queueTaskExecutor = YYTaskExecutor.createAQueueExcuter();
    }

    private ScheduledThreadPoolExecutor getRealExecutor() {
        return singleThreadScheduledExecutor;
    }

    private Runnable getProxyCommand(final Runnable command) {
        Runnable realRun = new Runnable(){

            @Override
            public void run() {
                IQueueTaskExecutor executor = YYProxySingleScheduledExecutor.this.queueTaskExecutor;
                if (executor != null) {
                    executor.execute(command, 0L);
                }
            }
        };
        return realRun;
    }

    private Callable getProxyCommand(final Callable command) {
        Callable realRun = new Callable(){

            public Object call() throws Exception {
                IQueueTaskExecutor executor = YYProxySingleScheduledExecutor.this.queueTaskExecutor;
                if (executor != null) {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                command.call();
                            }
                            catch (Exception e) {
                                MLog.error(YYProxySingleScheduledExecutor.TAG, e);
                            }
                        }
                    }, 0L);
                }
                return new Object();
            }
        };
        return realRun;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.getRealExecutor().scheduleAtFixedRate(this.getProxyCommand(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.getRealExecutor().schedule(this.getProxyCommand(command), delay, unit);
    }

    public ScheduledFuture<?> schedule(Callable callable, long delay, TimeUnit unit) {
        return this.getRealExecutor().schedule(this.getProxyCommand(callable), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.getRealExecutor().scheduleWithFixedDelay(this.getProxyCommand(command), initialDelay, delay, unit);
    }

    @Override
    public void allowCoreThreadTimeOut(boolean value) {
    }

    @Override
    public void shutdown() {
        MLog.info(TAG, "tag:%s, shutdown!", this.tag);
        if (this.queueTaskExecutor != null) {
            this.queueTaskExecutor.removeAllTask();
        }
        this.queueTaskExecutor = null;
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        MLog.info(TAG, "tag:%s, shutdown!", this.tag);
        if (this.queueTaskExecutor != null) {
            super.shutdown();
            ArrayList<Runnable> result = this.queueTaskExecutor.removeAllTask();
            this.queueTaskExecutor = null;
            return result;
        }
        return super.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return super.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return super.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        MLog.info(TAG, "tag:%s, awaitTermination!", this.tag);
        return super.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info(TAG, "tag:%s, submit task:%s!", this.tag, task);
        }
        return super.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info(TAG, "tag:%s, submit2 task:%s!", this.tag, task);
        }
        return super.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info(TAG, "tag:%s, submit3 task:%s!", this.tag, task);
        }
        return super.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        MLog.info(TAG, "tag:%s, invokeAll1!", this.tag);
        return super.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        MLog.info(TAG, "tag:%s, invokeAll2!", this.tag);
        return super.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws ExecutionException, InterruptedException {
        MLog.info(TAG, "tag:%s, invokeAny1!", this.tag);
        return super.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        MLog.info(TAG, "tag:%s, invokeAny2!", this.tag);
        return super.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        if (this.queueTaskExecutor != null) {
            this.queueTaskExecutor.execute(command, 0L);
        }
    }
}

