/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import androidx.annotation.NonNull;
import androidx.core.util.Consumer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class CallbackFuture<T>
implements Future<T> {
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private T data;
    private Throwable throwable;

    private CallbackFuture() {
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.countDownLatch.getCount() == 0L;
    }

    private T getData() throws ExecutionException {
        if (this.isDone()) {
            if (this.throwable != null) {
                throw new ExecutionException(this.throwable);
            }
            return this.data;
        }
        return null;
    }

    @Override
    public T get() throws ExecutionException, InterruptedException {
        T res = this.getData();
        if (res != null) {
            return res;
        }
        this.countDownLatch.await();
        return this.getData();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        T res = this.getData();
        if (res != null) {
            return res;
        }
        this.countDownLatch.await(timeout, unit);
        return this.getData();
    }

    private void checkStateValid() {
        if (this.countDownLatch.getCount() == 0L) {
            throw new IllegalStateException("Cannot set value more than one times.");
        }
    }

    private void onDone(@NonNull T data) {
        this.checkStateValid();
        this.data = data;
        this.countDownLatch.countDown();
    }

    private void onException(@NonNull Throwable throwable) {
        this.checkStateValid();
        this.throwable = throwable;
        this.countDownLatch.countDown();
    }

    public static <T> CallbackFuture<T> create(Consumer<Complement<T>> block) {
        final CallbackFuture<T> callbackFuture = new CallbackFuture<T>();
        Complement complement = new Complement<T>(){

            @Override
            public void onDone(@NonNull T data) {
                callbackFuture.onDone(data);
            }

            @Override
            public void onException(@NonNull Throwable throwable) {
                callbackFuture.onException(throwable);
            }
        };
        block.accept((Object)complement);
        return callbackFuture;
    }

    public static interface Complement<T> {
        public void onDone(@NonNull T var1);

        public void onException(@NonNull Throwable var1);
    }
}

