/*
 * Decompiled with CFR 0.152.
 */
package downloader.client;

import android.os.Bundle;
import android.os.Message;
import com.yy.base.utils.StringUtils;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadTask;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.MessageDef;
import com.yy.mobile.backgroundprocess.services.downloadcenter.wrapper.DownloadServiceWrapper;
import com.yy.mobile.backgroundprocess.services.downloadcenter.wrapper.ITaskProgressListener;
import com.yy.mobile.backgroundprocess.services.downloadcenter.wrapper.ITaskStateChangeListener;
import com.yy.mobile.backgroundprocess.services.downloadcenter.wrapper.MessageDispater;
import downloader.client.IBasicParamsProvider;
import downloader.client.IDownloadClientCallBack;
import java.util.ArrayList;

public class RemoteDownloadClient
implements MessageDispater.IMsgsSendErroredListener,
ITaskStateChangeListener,
ITaskProgressListener {
    private static final boolean ENABLE_LOG = false;
    private static final String TAG = "RemoteDownloadClient";
    private IDownloadClientCallBack mCallBack;

    public RemoteDownloadClient(IDownloadClientCallBack callBack) {
        this.mCallBack = callBack;
        DownloadServiceWrapper.instance().setMsgsSendErroredListener(this);
        DownloadServiceWrapper.instance().registerTaskStateChangeListener(this);
        DownloadServiceWrapper.instance().registerTaskProgressListener(this);
        this.updateBaseDataToService();
    }

    @Override
    public void onMsgsSendErrored(ArrayList<Message> messages) {
        if (messages != null && messages.size() > 0) {
            for (Message message : messages) {
                if (message.what != MessageDef.ClientSendMessage.CREATE_TASK || this.mCallBack == null || message.getData() == null) continue;
                this.mCallBack.onSubmitTaskErrored(DownloadTask.newDownloadTask(message.getData()));
            }
        }
    }

    public void setClientCallBack(IDownloadClientCallBack callBack) {
        this.mCallBack = callBack;
    }

    public void deleteTask(DownloadTask task) {
        if (task == null) {
            return;
        }
        DownloadServiceWrapper.instance().deleteTask(task, false);
    }

    public void deleteTask(String url, boolean deleteFile) {
        if (StringUtils.isEmpty((String)url)) {
            return;
        }
        DownloadTask task = DownloadTask.newDownloadTask(new Bundle());
        task.putString("url", url);
        DownloadServiceWrapper.instance().deleteTask(task, deleteFile);
    }

    public void submitTask(DownloadTask task) {
        if (task == null) {
            return;
        }
        DownloadServiceWrapper.instance().createTask(task);
    }

    @Override
    public void onTaskStateChanged(int oldState, DownloadTask task, Object exObj) {
        if (task == null || this.mCallBack == null) {
            return;
        }
        int state = task.getInt("state");
        if (state == 5) {
            this.mCallBack.onComplete(task);
        } else if (state == 4) {
            this.mCallBack.onError(task, 2, task.getString("errorinfo"));
        } else if (state == 3) {
            this.mCallBack.onStart(task);
        }
    }

    @Override
    public void onCreateTaskResult(int resultType, DownloadTask task, Object exObj) {
        if (task == null) {
            return;
        }
        if (this.mCallBack != null) {
            if (0 != resultType && -2 != resultType) {
                if (exObj != null) {
                    this.mCallBack.onError(task, 1, exObj.toString());
                } else {
                    this.mCallBack.onError(task, 1, new String("create task error,error type:" + resultType + " , define in class MessageDef.CreateTaskResult"));
                }
            } else {
                this.mCallBack.onCreate(task);
            }
        }
    }

    @Override
    public void onTaskProcessUpdated(int percent, DownloadTask task) {
        if (task == null) {
            return;
        }
        long curSize = task.getLong("cursize");
        long totalSize = task.getLong("size");
        if (this.mCallBack != null) {
            this.mCallBack.onProgressChange(task, totalSize, curSize);
        }
    }

    public void updateUid(long uid) {
        Bundle data = new Bundle();
        data.putLong("uid", uid);
        DownloadServiceWrapper.instance().sendMessage(0, MessageDef.ClientSendMessage.TRANSMIT_BASE_INFO, data);
    }

    public void updateCollectDataSwitch(boolean switchOn) {
        Bundle data = new Bundle();
        data.putBoolean("cdswitch", switchOn);
        DownloadServiceWrapper.instance().sendMessage(0, MessageDef.ClientSendMessage.TRANSMIT_BASE_INFO, data);
    }

    private void updateBaseDataToService() {
        if (this.mCallBack == null) {
            return;
        }
        IBasicParamsProvider paramsProvider = this.mCallBack.getBasicParamsProvider();
        if (paramsProvider == null) {
            return;
        }
        this.updateBaseDataToService(paramsProvider.getUid(), paramsProvider.isDataCollecterSwitchOn(), paramsProvider.isDevVer());
    }

    private void updateBaseDataToService(long uid, boolean collectDataSwitch, boolean isDevVer) {
        Bundle data = new Bundle();
        data.putLong("uid", uid);
        data.putBoolean("cdswitch", collectDataSwitch);
        data.putBoolean("devver", isDevVer);
        DownloadServiceWrapper.instance().sendMessage(0, MessageDef.ClientSendMessage.TRANSMIT_BASE_INFO, data);
    }
}

