/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services.downloadcenter.service.downloadcenter.model;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.os.Bundle;
import com.yy.base.logger.MLog;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadTask;
import java.util.ArrayList;

class DownloadTaskDataBaseHelper
extends SQLiteOpenHelper {
    private static final String TABLE_COMMON = "downloadtask_list_table";

    DownloadTaskDataBaseHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
    }

    public void onCreate(SQLiteDatabase db) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"DownloadTask SQL onCreate start:", (String)"", (Object[])new Object[0]);
        }
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("CREATE TABLE IF NOT EXISTS downloadtask_list_table");
            builder.append("(");
            builder.append("id INTEGER,");
            builder.append("type INTEGER,");
            builder.append("dgroup INTEGER,");
            builder.append("state INTEGER,");
            builder.append("mrtimes INTEGER,");
            builder.append("crtimes INTEGER,");
            builder.append("ctrans INTEGER,");
            builder.append("unzip INTEGER,");
            builder.append("tgabove INTEGER,");
            builder.append("priority INTEGER,");
            builder.append("size BIGINT,");
            builder.append("cursize BIGINT,");
            builder.append("ctime BIGINT,");
            builder.append("label TEXT,");
            builder.append("filename TEXT,");
            builder.append("path TEXT,");
            builder.append("url TEXT,");
            builder.append("etagkey TEXT,");
            builder.append("errorinfo TEXT,");
            builder.append("extmap TEXT");
            builder.append(")");
            db.execSQL(builder.toString());
        }
        catch (Exception e) {
            MLog.error((Object)"DownloadTask SQL onCreate error:", (Throwable)e);
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    private void putInt(DownloadTask task, Cursor cursor, String key) {
        task.putInt(key, cursor.getInt(cursor.getColumnIndex(key)));
    }

    private void putLong(DownloadTask task, Cursor cursor, String key) {
        task.putLong(key, cursor.getLong(cursor.getColumnIndex(key)));
    }

    private void putString(DownloadTask task, Cursor cursor, String key) {
        task.putString(key, cursor.getString(cursor.getColumnIndex(key)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DownloadTask> load() {
        ArrayList<DownloadTask> tasks = null;
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query(TABLE_COMMON, null, null, null, null, null, null);
            if (cursor == null || cursor.getCount() <= 0) {
                ArrayList<DownloadTask> arrayList = null;
                return arrayList;
            }
            tasks = new ArrayList<DownloadTask>();
            DownloadTask task = null;
            while (cursor.moveToNext()) {
                task = DownloadTask.newDownloadTask(new Bundle());
                this.putInt(task, cursor, "id");
                this.putInt(task, cursor, "type");
                this.putInt(task, cursor, "dgroup");
                this.putInt(task, cursor, "state");
                this.putInt(task, cursor, "mrtimes");
                this.putInt(task, cursor, "crtimes");
                this.putInt(task, cursor, "ctrans");
                this.putInt(task, cursor, "unzip");
                this.putInt(task, cursor, "tgabove");
                this.putInt(task, cursor, "priority");
                this.putLong(task, cursor, "size");
                this.putLong(task, cursor, "cursize");
                this.putLong(task, cursor, "ctime");
                this.putString(task, cursor, "label");
                this.putString(task, cursor, "filename");
                this.putString(task, cursor, "path");
                this.putString(task, cursor, "url");
                this.putString(task, cursor, "etagkey");
                this.putString(task, cursor, "errorinfo");
                String extendMapString = cursor.getString(cursor.getColumnIndex("extmap"));
                task.parseExternalMap(extendMapString);
                tasks.add(task);
            }
        }
        return tasks;
    }

    private void appKeyWithSplitChar(StringBuilder sqlBuilder, String key) {
        sqlBuilder.append(key).append(",");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTask(DownloadTask task) {
        boolean ret = false;
        if (task == null) {
            return ret;
        }
        boolean beginTransation = false;
        SQLiteDatabase database = null;
        try {
            database = this.getWritableDatabase();
            if (database == null) {
                boolean bl = ret;
                return bl;
            }
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("INSERT INTO ").append(TABLE_COMMON).append("(");
            this.appKeyWithSplitChar(sqlBuilder, "id");
            this.appKeyWithSplitChar(sqlBuilder, "type");
            this.appKeyWithSplitChar(sqlBuilder, "dgroup");
            this.appKeyWithSplitChar(sqlBuilder, "state");
            this.appKeyWithSplitChar(sqlBuilder, "mrtimes");
            this.appKeyWithSplitChar(sqlBuilder, "crtimes");
            this.appKeyWithSplitChar(sqlBuilder, "ctrans");
            this.appKeyWithSplitChar(sqlBuilder, "unzip");
            this.appKeyWithSplitChar(sqlBuilder, "tgabove");
            this.appKeyWithSplitChar(sqlBuilder, "priority");
            this.appKeyWithSplitChar(sqlBuilder, "size");
            this.appKeyWithSplitChar(sqlBuilder, "cursize");
            this.appKeyWithSplitChar(sqlBuilder, "ctime");
            this.appKeyWithSplitChar(sqlBuilder, "label");
            this.appKeyWithSplitChar(sqlBuilder, "filename");
            this.appKeyWithSplitChar(sqlBuilder, "path");
            this.appKeyWithSplitChar(sqlBuilder, "url");
            this.appKeyWithSplitChar(sqlBuilder, "etagkey");
            this.appKeyWithSplitChar(sqlBuilder, "errorinfo");
            sqlBuilder.append("extmap");
            sqlBuilder.append(")").append("VALUES ( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            database.beginTransaction();
            beginTransation = true;
            SQLiteStatement statement = database.compileStatement(sqlBuilder.toString());
            statement.bindLong(1, (long)task.getInt("id"));
            statement.bindLong(2, (long)task.getInt("type"));
            statement.bindLong(3, (long)task.getInt("dgroup"));
            statement.bindLong(4, (long)task.getInt("state"));
            statement.bindLong(5, (long)task.getInt("mrtimes"));
            statement.bindLong(6, (long)task.getInt("crtimes"));
            statement.bindLong(7, (long)task.getInt("ctrans"));
            statement.bindLong(8, (long)task.getInt("unzip"));
            statement.bindLong(9, (long)task.getInt("tgabove"));
            statement.bindLong(10, (long)task.getInt("priority"));
            statement.bindLong(11, task.getLong("size"));
            statement.bindLong(12, task.getLong("cursize"));
            statement.bindLong(13, task.getLong("ctime"));
            statement.bindString(14, task.getString("label"));
            statement.bindString(15, task.getString("filename"));
            statement.bindString(16, task.getString("path"));
            statement.bindString(17, task.getString("url"));
            statement.bindString(18, task.getString("etagkey"));
            statement.bindString(19, task.getString("errorinfo"));
            statement.bindString(20, task.getExtendMapString());
            statement.executeInsert();
            database.setTransactionSuccessful();
            ret = true;
        }
        catch (Exception e) {
            MLog.error((Object)"DownloadTask SQL addTask:", (Throwable)e);
        }
        finally {
            if (beginTransation) {
                try {
                    database.endTransaction();
                }
                catch (Exception e) {
                    MLog.error((Object)"end database transaction failed.", (Throwable)e);
                }
            }
        }
        return ret;
    }

    public boolean deleteTask(DownloadTask task) {
        if (task == null) {
            return false;
        }
        boolean ret = false;
        int count = 0;
        try {
            count = this.getWritableDatabase().delete(TABLE_COMMON, "url = ?", new String[]{task.getString("url")});
            ret = count > 0;
        }
        catch (Exception e) {
            MLog.error((Object)"DownloadTask SQL deleteTask:", (Throwable)e);
        }
        return ret;
    }

    public boolean updateState(DownloadTask task) {
        if (task == null) {
            return false;
        }
        boolean ret = false;
        int count = 0;
        ContentValues cv = new ContentValues();
        cv.put("state", Integer.valueOf(task.getInt("state")));
        try {
            count = this.getWritableDatabase().update(TABLE_COMMON, cv, "url = ?", new String[]{task.getString("url")});
            ret = count > 0;
        }
        catch (Exception e) {
            MLog.error((Object)"DownloadTask SQL updateState:", (Throwable)e);
        }
        return ret;
    }

    public boolean updateProgress(DownloadTask task) {
        if (task == null) {
            return false;
        }
        boolean ret = false;
        int count = 0;
        ContentValues cv = new ContentValues();
        cv.put("size", Long.valueOf(task.getLong("size")));
        cv.put("cursize", Long.valueOf(task.getLong("cursize")));
        try {
            count = this.getWritableDatabase().update(TABLE_COMMON, cv, "url = ?", new String[]{task.getString("url")});
            ret = count > 0;
        }
        catch (Exception e) {
            MLog.error((Object)"DownloadTask SQL updateProgress:", (Throwable)e);
        }
        return ret;
    }

    public boolean updateRetryTimes(DownloadTask task) {
        if (task == null) {
            return false;
        }
        boolean ret = false;
        int count = 0;
        ContentValues cv = new ContentValues();
        cv.put("crtimes", Integer.valueOf(task.getInt("crtimes")));
        try {
            count = this.getWritableDatabase().update(TABLE_COMMON, cv, "url = ?", new String[]{task.getString("url")});
            ret = count > 0;
        }
        catch (Exception e) {
            MLog.error((Object)"DownloadTask SQL updateRetryTimes:", (Throwable)e);
        }
        return ret;
    }
}

