/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.backgroundprocess.services;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import com.yy.base.logger.MLog;
import com.yy.mobile.backgroundprocess.RemoteBackgroundProcess;
import java.util.ArrayList;

public class BgProcessBinder {
    private static final String TAG = "bgprocess:BgProcessBinder";
    private ConnectionState mConnectionState = ConnectionState.CONNECTION_IDLE;
    private Context mContext;
    private Messenger mServiceMessenger;
    private ArrayList<IServiceBinderListener> mClients = new ArrayList();
    private int mRetryCount = 0;
    private final ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)BgProcessBinder.TAG, (String)"Remote Process Service connected", (Object[])new Object[0]);
            }
            BgProcessBinder.this.mConnectionState = ConnectionState.CONNECTION_CONNECTED;
            BgProcessBinder.this.mServiceMessenger = new Messenger(service);
            BgProcessBinder.this.mRetryCount = 0;
            BgProcessBinder.this.notifyBindEvent(true);
        }

        public void onServiceDisconnected(ComponentName name) {
            BgProcessBinder.this.mServiceMessenger = null;
            BgProcessBinder.this.mConnectionState = ConnectionState.CONNECTION_IDLE;
            BgProcessBinder.this.handleRetry();
        }
    };

    public void addBinderListener(IServiceBinderListener listener) {
        if (this.mClients.contains(listener)) {
            return;
        }
        this.mClients.add(listener);
    }

    public void removeBinderListener(IServiceBinderListener listener) {
        if (!this.mClients.contains(listener)) {
            return;
        }
        this.mClients.remove(listener);
    }

    private void notifyBindEvent(boolean connected) {
        for (IServiceBinderListener listener : this.mClients) {
            if (listener == null) continue;
            if (connected) {
                listener.onServiceConnectioned();
                continue;
            }
            listener.onServiceDisconnected();
        }
    }

    private void handleRetry() {
        if (this.mClients.size() > 0) {
            if (this.mRetryCount < 1) {
                ++this.mRetryCount;
                this.startRemoteProcessService();
            } else {
                this.notifyBindEvent(false);
            }
        }
    }

    public BgProcessBinder(Context context) {
        this.mContext = context;
    }

    public boolean isConnected() {
        return this.mConnectionState == ConnectionState.CONNECTION_CONNECTED;
    }

    public boolean isConnecting() {
        return this.mConnectionState == ConnectionState.CONNECTION_WAITING;
    }

    public boolean isDisconnected() {
        return this.mConnectionState == ConnectionState.CONNECTION_IDLE;
    }

    public void startRemoteProcessService() {
        if (ConnectionState.CONNECTION_IDLE == this.mConnectionState) {
            this.mConnectionState = ConnectionState.CONNECTION_WAITING;
            this.startService();
            this.bindService();
        }
    }

    private void startService() {
        block2: {
            try {
                Intent intent = new Intent(this.mContext, RemoteBackgroundProcess.class);
                this.mContext.startService(intent);
            }
            catch (SecurityException e) {
                if (MLog.isLogLevelAboveDebug()) break block2;
                MLog.debug((Object)TAG, (String)("catch security exception while starting download service :" + e.toString()), (Object[])new Object[0]);
            }
        }
    }

    private void bindService() {
        block2: {
            try {
                Intent bindIntent = new Intent(this.mContext, RemoteBackgroundProcess.class);
                bindIntent.setAction(RemoteBackgroundProcess.class.getName());
                this.mContext.bindService(bindIntent, this.mConnection, 1);
                this.mConnectionState = ConnectionState.CONNECTION_WAITING;
            }
            catch (Exception e) {
                this.mConnectionState = ConnectionState.CONNECTION_IDLE;
                this.handleRetry();
                if (MLog.isLogLevelAboveDebug()) break block2;
                MLog.debug((Object)TAG, (String)("doBindService()" + e.toString()), (Object[])new Object[0]);
            }
        }
    }

    public boolean sendMessage(Message msg) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("sendMessage:" + msg.toString()), (Object[])new Object[0]);
        }
        if (this.mConnectionState != ConnectionState.CONNECTION_CONNECTED) {
            this.startRemoteProcessService();
            return false;
        }
        try {
            this.mServiceMessenger.send(msg);
            return true;
        }
        catch (RemoteException e) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)("sendMessage:" + e.toString()), (Object[])new Object[0]);
            }
            this.mConnection.onServiceDisconnected(null);
            return false;
        }
    }

    public static interface IServiceBinderListener {
        public void onServiceConnectioned();

        public void onServiceDisconnected();
    }

    static enum ConnectionState {
        CONNECTION_IDLE,
        CONNECTION_CONNECTED,
        CONNECTION_WAITING;

    }
}

