/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.photo;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.OverScroller;
import android.widget.Scroller;
import com.yy.base.imageloader.view.RecycleImageView;

public class ZoomImageView
extends RecycleImageView
implements View.OnTouchListener,
ViewTreeObserver.OnGlobalLayoutListener {
    private static final int EDGE_NONE = -1;
    private static final int EDGE_LEFT = 0;
    private static final int EDGE_RIGHT = 1;
    private static final int EDGE_BOTH = 2;
    public static final float DEFAULT_MAX_SCALE = 3.0f;
    public static final float DEFAULT_MID_SCALE = 1.75f;
    public static final float DEFAULT_MIN_SCALE = 1.0f;
    private float minScale = 1.0f;
    private float midScale = 1.75f;
    private float maxScale = 3.0f;
    private boolean allowParentInterceptOnEdge = true;
    private MultiGestureDetector multiGestureDetector;
    private final Matrix baseMatrix = new Matrix();
    private final Matrix drawMatrix = new Matrix();
    private final Matrix suppMatrix = new Matrix();
    private final RectF displayRect = new RectF();
    private final float[] matrixValues = new float[9];
    private OnPhotoTapListener photoTapListener;
    private OnViewTapListener viewTapListener;
    private View.OnLongClickListener longClickListener;
    private int top;
    private int right;
    private int bottom;
    private int left;
    private FlingRunnable currentFlingRunnable;
    private int scrollEdge = 2;
    private boolean isZoomEnabled;
    private ImageView.ScaleType scaleType = ImageView.ScaleType.FIT_CENTER;
    private Bitmap mBitmap;

    public ZoomImageView(Context context) {
        this(context, null);
    }

    public ZoomImageView(Context context, AttributeSet attr) {
        this(context, attr, 0);
    }

    public ZoomImageView(Context context, AttributeSet attr, int defStyle) {
        super(context, attr, defStyle);
        super.setScaleType(ImageView.ScaleType.MATRIX);
        this.setOnTouchListener(this);
        this.multiGestureDetector = new MultiGestureDetector(context);
        this.setIsZoomEnabled(true);
    }

    public final RectF getDisplayRect() {
        this.checkMatrixBounds();
        return this.getDisplayRect(this.getDisplayMatrix());
    }

    public float getMinScale() {
        return this.minScale;
    }

    public void setMinScale(float minScale) {
        this.checkZoomLevels(minScale, this.midScale, this.maxScale);
        this.minScale = minScale;
    }

    public float getMidScale() {
        return this.midScale;
    }

    public void setMidScale(float midScale) {
        this.checkZoomLevels(this.minScale, midScale, this.maxScale);
        this.midScale = midScale;
    }

    public float getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(float maxScale) {
        this.checkZoomLevels(this.minScale, this.midScale, maxScale);
        this.maxScale = maxScale;
    }

    public final float getScale() {
        this.suppMatrix.getValues(this.matrixValues);
        return this.matrixValues[0];
    }

    public final ImageView.ScaleType getScaleType() {
        return this.scaleType;
    }

    public final void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType == ImageView.ScaleType.MATRIX) {
            throw new IllegalArgumentException(scaleType.name() + " is not supported in ZoomImageView");
        }
        if (scaleType != this.scaleType) {
            this.scaleType = scaleType;
            this.update();
        }
    }

    public final boolean isZoomEnabled() {
        return this.isZoomEnabled;
    }

    public final void setIsZoomEnabled(boolean isZoomEnabled) {
        this.isZoomEnabled = isZoomEnabled;
        this.update();
    }

    public void setAllowParentInterceptOnEdge(boolean allowParentInterceptOnEdge) {
        this.allowParentInterceptOnEdge = allowParentInterceptOnEdge;
    }

    public void setImageBitmap(Bitmap bitmap) {
        super.setImageBitmap(bitmap);
        this.mBitmap = bitmap;
        this.update();
    }

    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        this.update();
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.update();
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.update();
    }

    public void rotateImage(int degrees) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)degrees);
        this.mBitmap = Bitmap.createBitmap((Bitmap)this.mBitmap, (int)0, (int)0, (int)this.mBitmap.getWidth(), (int)this.mBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        this.setImageBitmap(this.mBitmap);
    }

    public final void setOnLongClickListener(View.OnLongClickListener listener) {
        this.longClickListener = listener;
    }

    public final void setOnPhotoTapListener(OnPhotoTapListener listener) {
        this.photoTapListener = listener;
    }

    public final void setOnViewTapListener(OnViewTapListener listener) {
        this.viewTapListener = listener;
    }

    public final void onGlobalLayout() {
        if (this.isZoomEnabled) {
            int top = this.getTop();
            int right = this.getRight();
            int bottom = this.getBottom();
            int left = this.getLeft();
            if (top != this.top || bottom != this.bottom || left != this.left || right != this.right) {
                this.updateBaseMatrix(this.getDrawable());
                this.top = top;
                this.right = right;
                this.bottom = bottom;
                this.left = left;
            }
        }
    }

    public final boolean onTouch(View v, MotionEvent ev) {
        boolean handled = false;
        if (this.isZoomEnabled) {
            switch (ev.getAction()) {
                case 0: {
                    if (v.getParent() != null) {
                        v.getParent().requestDisallowInterceptTouchEvent(true);
                    }
                    if (this.currentFlingRunnable == null) break;
                    this.currentFlingRunnable.cancelFling();
                    this.currentFlingRunnable = null;
                    break;
                }
                case 1: 
                case 3: {
                    RectF rect;
                    if (!(this.getScale() < this.minScale) || null == (rect = this.getDisplayRect())) break;
                    v.post((Runnable)new AnimatedZoomRunnable(this.getScale(), this.minScale, rect.centerX(), rect.centerY()));
                    handled = true;
                    break;
                }
            }
            if (this.multiGestureDetector != null && this.multiGestureDetector.onTouchEvent(ev)) {
                handled = true;
            }
        }
        return handled;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected Matrix getDisplayMatrix() {
        this.drawMatrix.set(this.baseMatrix);
        this.drawMatrix.postConcat(this.suppMatrix);
        return this.drawMatrix;
    }

    private void update() {
        if (this.isZoomEnabled) {
            super.setScaleType(ImageView.ScaleType.MATRIX);
            this.updateBaseMatrix(this.getDrawable());
        } else {
            this.resetMatrix();
        }
    }

    private void checkAndDisplayMatrix() {
        this.checkMatrixBounds();
        this.setImageMatrix(this.getDisplayMatrix());
    }

    private void checkMatrixBounds() {
        RectF rect = this.getDisplayRect(this.getDisplayMatrix());
        if (null == rect) {
            return;
        }
        float height = rect.height();
        float width = rect.width();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        int viewHeight = this.getHeight();
        if (height <= (float)viewHeight) {
            switch (this.scaleType) {
                case FIT_START: {
                    deltaY = -rect.top;
                    break;
                }
                case FIT_END: {
                    deltaY = (float)viewHeight - height - rect.top;
                    break;
                }
                default: {
                    deltaY = ((float)viewHeight - height) / 2.0f - rect.top;
                    break;
                }
            }
        } else if (rect.top > 0.0f) {
            deltaY = -rect.top;
        } else if (rect.bottom < (float)viewHeight) {
            deltaY = (float)viewHeight - rect.bottom;
        }
        int viewWidth = this.getWidth();
        if (width <= (float)viewWidth) {
            switch (this.scaleType) {
                case FIT_START: {
                    deltaX = -rect.left;
                    break;
                }
                case FIT_END: {
                    deltaX = (float)viewWidth - width - rect.left;
                    break;
                }
                default: {
                    deltaX = ((float)viewWidth - width) / 2.0f - rect.left;
                }
            }
            this.scrollEdge = 2;
        } else if (rect.left > 0.0f) {
            this.scrollEdge = 0;
            deltaX = -rect.left;
        } else if (rect.right < (float)viewWidth) {
            deltaX = (float)viewWidth - rect.right;
            this.scrollEdge = 1;
        } else {
            this.scrollEdge = -1;
        }
        this.suppMatrix.postTranslate(deltaX, deltaY);
    }

    private RectF getDisplayRect(Matrix matrix) {
        Drawable d = this.getDrawable();
        if (null != d) {
            this.displayRect.set(0.0f, 0.0f, (float)d.getIntrinsicWidth(), (float)d.getIntrinsicHeight());
            matrix.mapRect(this.displayRect);
            return this.displayRect;
        }
        return null;
    }

    public void resetMatrix() {
        if (this.suppMatrix == null) {
            return;
        }
        this.suppMatrix.reset();
        this.setImageMatrix(this.getDisplayMatrix());
        this.checkMatrixBounds();
    }

    private void updateBaseMatrix(Drawable d) {
        if (null == d) {
            return;
        }
        float viewWidth = this.getWidth();
        float viewHeight = this.getHeight();
        int drawableWidth = d.getIntrinsicWidth();
        int drawableHeight = d.getIntrinsicHeight();
        this.baseMatrix.reset();
        float widthScale = viewWidth / (float)drawableWidth;
        float heightScale = viewHeight / (float)drawableHeight;
        if (this.scaleType == ImageView.ScaleType.CENTER) {
            this.baseMatrix.postTranslate((viewWidth - (float)drawableWidth) / 2.0f, (viewHeight - (float)drawableHeight) / 2.0f);
        } else if (this.scaleType == ImageView.ScaleType.CENTER_CROP) {
            float scale = Math.max(widthScale, heightScale);
            this.baseMatrix.postScale(scale, scale);
            this.baseMatrix.postTranslate((viewWidth - (float)drawableWidth * scale) / 2.0f, (viewHeight - (float)drawableHeight * scale) / 2.0f);
        } else if (this.scaleType == ImageView.ScaleType.CENTER_INSIDE) {
            float scale = Math.min(1.0f, Math.min(widthScale, heightScale));
            this.baseMatrix.postScale(scale, scale);
            this.baseMatrix.postTranslate((viewWidth - (float)drawableWidth * scale) / 2.0f, (viewHeight - (float)drawableHeight * scale) / 2.0f);
        } else {
            RectF mTempSrc = new RectF(0.0f, 0.0f, (float)drawableWidth, (float)drawableHeight);
            RectF mTempDst = new RectF(0.0f, 0.0f, viewWidth, viewHeight);
            switch (this.scaleType) {
                case FIT_CENTER: {
                    this.baseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.CENTER);
                    break;
                }
                case FIT_START: {
                    this.baseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.START);
                    break;
                }
                case FIT_END: {
                    this.baseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.END);
                    break;
                }
                case FIT_XY: {
                    this.baseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.FILL);
                    break;
                }
            }
        }
        this.resetMatrix();
    }

    @TargetApi(value=16)
    private void postOnAnimation(View view, Runnable runnable) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.postOnAnimation(runnable);
        } else {
            view.postDelayed(runnable, 16L);
        }
    }

    private void checkZoomLevels(float minZoom, float midZoom, float maxZoom) {
        if (minZoom >= midZoom) {
            throw new IllegalArgumentException("MinZoom should be less than MidZoom");
        }
        if (midZoom >= maxZoom) {
            throw new IllegalArgumentException("MidZoom should be less than MaxZoom");
        }
    }

    private class FlingRunnable
    implements Runnable {
        private final ScrollerProxy scroller;
        private int currentX;
        private int currentY;

        FlingRunnable(Context context) {
            this.scroller = new ScrollerProxy(context);
        }

        public void cancelFling() {
            this.scroller.forceFinished(true);
        }

        public void fling(int viewWidth, int viewHeight, int velocityX, int velocityY) {
            int maxY;
            int minY;
            int maxX;
            int minX;
            RectF rect = ZoomImageView.this.getDisplayRect();
            if (null == rect) {
                return;
            }
            int startX = Math.round(-rect.left);
            if ((float)viewWidth < rect.width()) {
                minX = 0;
                maxX = Math.round(rect.width() - (float)viewWidth);
            } else {
                minX = maxX = startX;
            }
            int startY = Math.round(-rect.top);
            if ((float)viewHeight < rect.height()) {
                minY = 0;
                maxY = Math.round(rect.height() - (float)viewHeight);
            } else {
                minY = maxY = startY;
            }
            this.currentX = startX;
            this.currentY = startY;
            if (startX != maxX || startY != maxY) {
                this.scroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY, 0, 0);
            }
        }

        @Override
        public void run() {
            if (this.scroller.computeScrollOffset()) {
                int newX = this.scroller.getCurrX();
                int newY = this.scroller.getCurrY();
                ZoomImageView.this.suppMatrix.postTranslate((float)(this.currentX - newX), (float)(this.currentY - newY));
                ZoomImageView.this.setImageMatrix(ZoomImageView.this.getDisplayMatrix());
                this.currentX = newX;
                this.currentY = newY;
                ZoomImageView.this.postOnAnimation((View)ZoomImageView.this, this);
            }
        }
    }

    private class AnimatedZoomRunnable
    implements Runnable {
        static final float ANIMATION_SCALE_PER_ITERATION_IN = 1.07f;
        static final float ANIMATION_SCALE_PER_ITERATION_OUT = 0.93f;
        private final float focalX;
        private final float focalY;
        private final float targetZoom;
        private final float deltaScale;

        AnimatedZoomRunnable(float currentZoom, float targetZoom, float focalX, float focalY) {
            this.targetZoom = targetZoom;
            this.focalX = focalX;
            this.focalY = focalY;
            this.deltaScale = currentZoom < targetZoom ? 1.07f : 0.93f;
        }

        @Override
        public void run() {
            ZoomImageView.this.suppMatrix.postScale(this.deltaScale, this.deltaScale, this.focalX, this.focalY);
            ZoomImageView.this.checkAndDisplayMatrix();
            float currentScale = ZoomImageView.this.getScale();
            if (this.deltaScale > 1.0f && currentScale < this.targetZoom || this.deltaScale < 1.0f && this.targetZoom < currentScale) {
                ZoomImageView.this.postOnAnimation((View)ZoomImageView.this, this);
            } else {
                float delta = this.targetZoom / currentScale;
                ZoomImageView.this.suppMatrix.postScale(delta, delta, this.focalX, this.focalY);
                ZoomImageView.this.checkAndDisplayMatrix();
            }
        }
    }

    @TargetApi(value=9)
    private static class ScrollerProxy {
        private boolean isOld;
        private Object scroller;

        ScrollerProxy(Context context) {
            if (Build.VERSION.SDK_INT < 9) {
                this.isOld = true;
                this.scroller = new Scroller(context);
            } else {
                this.isOld = false;
                this.scroller = new OverScroller(context);
            }
        }

        public boolean computeScrollOffset() {
            return this.isOld ? ((Scroller)this.scroller).computeScrollOffset() : ((OverScroller)this.scroller).computeScrollOffset();
        }

        public void fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY, int overX, int overY) {
            if (this.isOld) {
                ((Scroller)this.scroller).fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
            } else {
                ((OverScroller)this.scroller).fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY, overX, overY);
            }
        }

        public void forceFinished(boolean finished) {
            if (this.isOld) {
                ((Scroller)this.scroller).forceFinished(finished);
            } else {
                ((OverScroller)this.scroller).forceFinished(finished);
            }
        }

        public int getCurrX() {
            return this.isOld ? ((Scroller)this.scroller).getCurrX() : ((OverScroller)this.scroller).getCurrX();
        }

        public int getCurrY() {
            return this.isOld ? ((Scroller)this.scroller).getCurrY() : ((OverScroller)this.scroller).getCurrY();
        }
    }

    private class MultiGestureDetector
    extends GestureDetector.SimpleOnGestureListener
    implements ScaleGestureDetector.OnScaleGestureListener {
        private final ScaleGestureDetector scaleGestureDetector;
        private final GestureDetector gestureDetector;
        private VelocityTracker velocityTracker;
        private boolean isDragging;
        private float lastTouchX;
        private float lastTouchY;
        private float lastPointerCount;
        private final float scaledTouchSlop;
        private final float scaledMinimumFlingVelocity;

        MultiGestureDetector(Context context) {
            this.scaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this);
            this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
            this.gestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)this);
            ViewConfiguration configuration = ViewConfiguration.get((Context)context);
            this.scaledMinimumFlingVelocity = configuration.getScaledMinimumFlingVelocity();
            this.scaledTouchSlop = configuration.getScaledTouchSlop();
        }

        public boolean isScaling() {
            return this.scaleGestureDetector.isInProgress();
        }

        public boolean onTouchEvent(MotionEvent event) {
            if (this.gestureDetector.onTouchEvent(event)) {
                return true;
            }
            this.scaleGestureDetector.onTouchEvent(event);
            float x = 0.0f;
            float y = 0.0f;
            int pointerCount = event.getPointerCount();
            for (int i = 0; i < pointerCount; ++i) {
                x += event.getX(i);
                y += event.getY(i);
            }
            x /= (float)pointerCount;
            y /= (float)pointerCount;
            if ((float)pointerCount != this.lastPointerCount) {
                this.isDragging = false;
                if (this.velocityTracker != null) {
                    this.velocityTracker.clear();
                }
                this.lastTouchX = x;
                this.lastTouchY = y;
            }
            this.lastPointerCount = pointerCount;
            switch (event.getAction()) {
                case 0: {
                    if (this.velocityTracker == null) {
                        this.velocityTracker = VelocityTracker.obtain();
                    } else {
                        this.velocityTracker.clear();
                    }
                    this.velocityTracker.addMovement(event);
                    this.lastTouchX = x;
                    this.lastTouchY = y;
                    this.isDragging = false;
                    break;
                }
                case 2: {
                    float dx = x - this.lastTouchX;
                    float dy = y - this.lastTouchY;
                    if (!this.isDragging) {
                        boolean bl = this.isDragging = Math.sqrt(dx * dx + dy * dy) >= (double)this.scaledTouchSlop;
                    }
                    if (!this.isDragging) break;
                    ZoomImageView.this.suppMatrix.postTranslate(dx, dy);
                    ZoomImageView.this.checkAndDisplayMatrix();
                    if (ZoomImageView.this.allowParentInterceptOnEdge && !ZoomImageView.this.multiGestureDetector.isScaling() && (ZoomImageView.this.scrollEdge == 2 || ZoomImageView.this.scrollEdge == 0 && dx >= 1.0f || ZoomImageView.this.scrollEdge == 1 && dx <= -1.0f) && ZoomImageView.this.getParent() != null) {
                        ZoomImageView.this.getParent().requestDisallowInterceptTouchEvent(false);
                    }
                    this.lastTouchX = x;
                    this.lastTouchY = y;
                    if (this.velocityTracker == null) break;
                    this.velocityTracker.addMovement(event);
                    break;
                }
                case 1: {
                    if (!this.isDragging) break;
                    this.lastTouchX = x;
                    this.lastTouchY = y;
                    if (this.velocityTracker == null) break;
                    this.velocityTracker.addMovement(event);
                    this.velocityTracker.computeCurrentVelocity(1000);
                    float vX = this.velocityTracker.getXVelocity();
                    float vY = this.velocityTracker.getYVelocity();
                    if (!(Math.max(Math.abs(vX), Math.abs(vY)) >= this.scaledMinimumFlingVelocity) || ZoomImageView.this.getDrawable() == null) break;
                    ZoomImageView.this.currentFlingRunnable = new FlingRunnable(ZoomImageView.this.getContext());
                    ZoomImageView.this.currentFlingRunnable.fling(ZoomImageView.this.getWidth(), ZoomImageView.this.getHeight(), (int)(-vX), (int)(-vY));
                    ZoomImageView.this.post(ZoomImageView.this.currentFlingRunnable);
                    break;
                }
                case 3: {
                    this.lastPointerCount = 0.0f;
                    if (this.velocityTracker == null) break;
                    this.velocityTracker.recycle();
                    this.velocityTracker = null;
                    break;
                }
            }
            return true;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            float scale = ZoomImageView.this.getScale();
            float scaleFactor = detector.getScaleFactor();
            if (!(ZoomImageView.this.getDrawable() == null || scale >= ZoomImageView.this.maxScale && scaleFactor > 1.0f || (double)scale <= 0.75 && scaleFactor < 1.0f)) {
                ZoomImageView.this.suppMatrix.postScale(scaleFactor, scaleFactor, detector.getFocusX(), detector.getFocusY());
                ZoomImageView.this.checkAndDisplayMatrix();
            }
            return true;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
        }

        public boolean onDoubleTap(MotionEvent event) {
            try {
                float scale = ZoomImageView.this.getScale();
                float x = event.getX();
                float y = event.getY();
                if (scale < ZoomImageView.this.midScale) {
                    ZoomImageView.this.post(new AnimatedZoomRunnable(scale, ZoomImageView.this.midScale, x, y));
                } else if (scale >= ZoomImageView.this.midScale && scale < ZoomImageView.this.maxScale) {
                    ZoomImageView.this.post(new AnimatedZoomRunnable(scale, ZoomImageView.this.minScale, x, y));
                } else {
                    ZoomImageView.this.post(new AnimatedZoomRunnable(scale, ZoomImageView.this.minScale, x, y));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }

        public boolean onDoubleTapEvent(MotionEvent event) {
            return false;
        }

        public boolean onSingleTapConfirmed(MotionEvent event) {
            RectF displayRect;
            if (ZoomImageView.this.photoTapListener != null && null != (displayRect = ZoomImageView.this.getDisplayRect())) {
                float y;
                float x = event.getX();
                if (displayRect.contains(x, y = event.getY())) {
                    float xResult = (x - displayRect.left) / displayRect.width();
                    float yResult = (y - displayRect.top) / displayRect.height();
                    ZoomImageView.this.photoTapListener.onPhotoTap((View)ZoomImageView.this, xResult, yResult);
                } else {
                    ZoomImageView.this.photoTapListener.onClickOutPhoto((View)ZoomImageView.this);
                }
                return true;
            }
            if (ZoomImageView.this.viewTapListener != null) {
                ZoomImageView.this.viewTapListener.onViewTap((View)ZoomImageView.this, event.getX(), event.getY());
            }
            return false;
        }

        public void onLongPress(MotionEvent e) {
            if (ZoomImageView.this.longClickListener != null) {
                ZoomImageView.this.longClickListener.onLongClick((View)ZoomImageView.this);
            }
        }
    }

    public static interface OnViewTapListener {
        public void onViewTap(View var1, float var2, float var3);
    }

    public static interface OnPhotoTapListener {
        public void onPhotoTap(View var1, float var2, float var3);

        public void onClickOutPhoto(View var1);
    }
}

