/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.camera.utils.cropper.cropwindow.handle;

import android.graphics.Rect;
import com.yy.hiyo.camera.camera.utils.cropper.cropwindow.edge.Edge;
import com.yy.hiyo.camera.camera.utils.cropper.cropwindow.handle.HandleHelper;

class CenterHandleHelper
extends HandleHelper {
    CenterHandleHelper() {
        super(null, null);
    }

    @Override
    void updateCropWindow(float x, float y, Rect imageRect, float snapRadius) {
        float offset;
        float left = Edge.LEFT.getCoordinate();
        float top = Edge.TOP.getCoordinate();
        float right = Edge.RIGHT.getCoordinate();
        float bottom = Edge.BOTTOM.getCoordinate();
        float currentCenterX = (left + right) / 2.0f;
        float currentCenterY = (top + bottom) / 2.0f;
        float offsetX = x - currentCenterX;
        float offsetY = y - currentCenterY;
        Edge.LEFT.offset(offsetX);
        Edge.TOP.offset(offsetY);
        Edge.RIGHT.offset(offsetX);
        Edge.BOTTOM.offset(offsetY);
        if (Edge.LEFT.isOutsideMargin(imageRect, snapRadius)) {
            offset = Edge.LEFT.snapToRect(imageRect);
            Edge.RIGHT.offset(offset);
        } else if (Edge.RIGHT.isOutsideMargin(imageRect, snapRadius)) {
            offset = Edge.RIGHT.snapToRect(imageRect);
            Edge.LEFT.offset(offset);
        }
        if (Edge.TOP.isOutsideMargin(imageRect, snapRadius)) {
            offset = Edge.TOP.snapToRect(imageRect);
            Edge.BOTTOM.offset(offset);
        } else if (Edge.BOTTOM.isOutsideMargin(imageRect, snapRadius)) {
            offset = Edge.BOTTOM.snapToRect(imageRect);
            Edge.TOP.offset(offset);
        }
    }

    @Override
    void updateCropWindow(float x, float y, float targetAspectRatio, Rect imageRect, float snapRadius) {
        this.updateCropWindow(x, y, imageRect, snapRadius);
    }
}

