/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.camera.utils.cropper.cropwindow.edge;

import android.graphics.Rect;
import android.view.View;
import com.yy.hiyo.camera.camera.utils.cropper.util.AspectRatioUtil;

public enum Edge {
    LEFT,
    TOP,
    RIGHT,
    BOTTOM;

    public static final int MIN_CROP_LENGTH_PX = 40;
    private float mCoordinate;

    public void setCoordinate(float coordinate) {
        this.mCoordinate = coordinate;
    }

    public void offset(float distance) {
        this.mCoordinate += distance;
    }

    public float getCoordinate() {
        return this.mCoordinate;
    }

    public void adjustCoordinate(float x, float y, Rect imageRect, float imageSnapRadius, float aspectRatio) {
        switch (this) {
            case LEFT: {
                this.mCoordinate = Edge.adjustLeft(x, imageRect, imageSnapRadius, aspectRatio);
                break;
            }
            case TOP: {
                this.mCoordinate = Edge.adjustTop(y, imageRect, imageSnapRadius, aspectRatio);
                break;
            }
            case RIGHT: {
                this.mCoordinate = Edge.adjustRight(x, imageRect, imageSnapRadius, aspectRatio);
                break;
            }
            case BOTTOM: {
                this.mCoordinate = Edge.adjustBottom(y, imageRect, imageSnapRadius, aspectRatio);
                break;
            }
        }
    }

    public void adjustCoordinate(float aspectRatio) {
        float left = LEFT.getCoordinate();
        float top = TOP.getCoordinate();
        float right = RIGHT.getCoordinate();
        float bottom = BOTTOM.getCoordinate();
        switch (this) {
            case LEFT: {
                this.mCoordinate = AspectRatioUtil.calculateLeft(top, right, bottom, aspectRatio);
                break;
            }
            case TOP: {
                this.mCoordinate = AspectRatioUtil.calculateTop(left, right, bottom, aspectRatio);
                break;
            }
            case RIGHT: {
                this.mCoordinate = AspectRatioUtil.calculateRight(left, top, bottom, aspectRatio);
                break;
            }
            case BOTTOM: {
                this.mCoordinate = AspectRatioUtil.calculateBottom(left, top, right, aspectRatio);
                break;
            }
        }
    }

    public boolean isNewRectangleOutOfBounds(Edge edge, Rect imageRect, float aspectRatio) {
        float offset = edge.snapOffset(imageRect);
        switch (this) {
            case LEFT: {
                if (edge.equals((Object)TOP)) {
                    float top = imageRect.top;
                    float bottom = BOTTOM.getCoordinate() - offset;
                    float right = RIGHT.getCoordinate();
                    float left = AspectRatioUtil.calculateLeft(top, right, bottom, aspectRatio);
                    return this.isOutOfBounds(top, left, bottom, right, imageRect);
                }
                if (!edge.equals((Object)BOTTOM)) break;
                float bottom = imageRect.bottom;
                float top = TOP.getCoordinate() - offset;
                float right = RIGHT.getCoordinate();
                float left = AspectRatioUtil.calculateLeft(top, right, bottom, aspectRatio);
                return this.isOutOfBounds(top, left, bottom, right, imageRect);
            }
            case TOP: {
                if (edge.equals((Object)LEFT)) {
                    float left = imageRect.left;
                    float right = RIGHT.getCoordinate() - offset;
                    float bottom = BOTTOM.getCoordinate();
                    float top = AspectRatioUtil.calculateTop(left, right, bottom, aspectRatio);
                    return this.isOutOfBounds(top, left, bottom, right, imageRect);
                }
                if (!edge.equals((Object)RIGHT)) break;
                float right = imageRect.right;
                float left = LEFT.getCoordinate() - offset;
                float bottom = BOTTOM.getCoordinate();
                float top = AspectRatioUtil.calculateTop(left, right, bottom, aspectRatio);
                return this.isOutOfBounds(top, left, bottom, right, imageRect);
            }
            case RIGHT: {
                if (edge.equals((Object)TOP)) {
                    float top = imageRect.top;
                    float bottom = BOTTOM.getCoordinate() - offset;
                    float left = LEFT.getCoordinate();
                    float right = AspectRatioUtil.calculateRight(left, top, bottom, aspectRatio);
                    return this.isOutOfBounds(top, left, bottom, right, imageRect);
                }
                if (!edge.equals((Object)BOTTOM)) break;
                float bottom = imageRect.bottom;
                float top = TOP.getCoordinate() - offset;
                float left = LEFT.getCoordinate();
                float right = AspectRatioUtil.calculateRight(left, top, bottom, aspectRatio);
                return this.isOutOfBounds(top, left, bottom, right, imageRect);
            }
            case BOTTOM: {
                if (edge.equals((Object)LEFT)) {
                    float left = imageRect.left;
                    float right = RIGHT.getCoordinate() - offset;
                    float top = TOP.getCoordinate();
                    float bottom = AspectRatioUtil.calculateBottom(left, top, right, aspectRatio);
                    return this.isOutOfBounds(top, left, bottom, right, imageRect);
                }
                if (!edge.equals((Object)RIGHT)) break;
                float right = imageRect.right;
                float left = LEFT.getCoordinate() - offset;
                float top = TOP.getCoordinate();
                float bottom = AspectRatioUtil.calculateBottom(left, top, right, aspectRatio);
                return this.isOutOfBounds(top, left, bottom, right, imageRect);
            }
        }
        return true;
    }

    private boolean isOutOfBounds(float top, float left, float bottom, float right, Rect imageRect) {
        return top < (float)imageRect.top || left < (float)imageRect.left || bottom > (float)imageRect.bottom || right > (float)imageRect.right;
    }

    public float snapToRect(Rect imageRect) {
        float oldCoordinate = this.mCoordinate;
        switch (this) {
            case LEFT: {
                this.mCoordinate = imageRect.left;
                break;
            }
            case TOP: {
                this.mCoordinate = imageRect.top;
                break;
            }
            case RIGHT: {
                this.mCoordinate = imageRect.right;
                break;
            }
            case BOTTOM: {
                this.mCoordinate = imageRect.bottom;
                break;
            }
        }
        float offset = this.mCoordinate - oldCoordinate;
        return offset;
    }

    public float snapOffset(Rect imageRect) {
        float oldCoordinate;
        float newCoordinate = oldCoordinate = this.mCoordinate;
        switch (this) {
            case LEFT: {
                newCoordinate = imageRect.left;
                break;
            }
            case TOP: {
                newCoordinate = imageRect.top;
                break;
            }
            case RIGHT: {
                newCoordinate = imageRect.right;
                break;
            }
            case BOTTOM: {
                newCoordinate = imageRect.bottom;
                break;
            }
        }
        float offset = newCoordinate - oldCoordinate;
        return offset;
    }

    public void snapToView(View view) {
        switch (this) {
            case LEFT: {
                this.mCoordinate = 0.0f;
                break;
            }
            case TOP: {
                this.mCoordinate = 0.0f;
                break;
            }
            case RIGHT: {
                this.mCoordinate = view.getWidth();
                break;
            }
            case BOTTOM: {
                this.mCoordinate = view.getHeight();
                break;
            }
        }
    }

    public static float getWidth() {
        return RIGHT.getCoordinate() - LEFT.getCoordinate();
    }

    public static float getHeight() {
        return BOTTOM.getCoordinate() - TOP.getCoordinate();
    }

    public boolean isOutsideMargin(Rect rect, float margin) {
        boolean result = false;
        switch (this) {
            case LEFT: {
                result = this.mCoordinate - (float)rect.left < margin;
                break;
            }
            case TOP: {
                result = this.mCoordinate - (float)rect.top < margin;
                break;
            }
            case RIGHT: {
                result = (float)rect.right - this.mCoordinate < margin;
                break;
            }
            case BOTTOM: {
                result = (float)rect.bottom - this.mCoordinate < margin;
                break;
            }
        }
        return result;
    }

    public boolean isOutsideFrame(Rect rect) {
        double margin = 0.0;
        boolean result = false;
        switch (this) {
            case LEFT: {
                result = (double)(this.mCoordinate - (float)rect.left) < margin;
                break;
            }
            case TOP: {
                result = (double)(this.mCoordinate - (float)rect.top) < margin;
                break;
            }
            case RIGHT: {
                result = (double)((float)rect.right - this.mCoordinate) < margin;
                break;
            }
            case BOTTOM: {
                result = (double)((float)rect.bottom - this.mCoordinate) < margin;
                break;
            }
        }
        return result;
    }

    private static float adjustLeft(float x, Rect imageRect, float imageSnapRadius, float aspectRatio) {
        float resultX = x;
        if (x - (float)imageRect.left < imageSnapRadius) {
            resultX = imageRect.left;
        } else {
            float resultXHoriz = Float.POSITIVE_INFINITY;
            float resultXVert = Float.POSITIVE_INFINITY;
            if (x >= RIGHT.getCoordinate() - 40.0f) {
                resultXHoriz = RIGHT.getCoordinate() - 40.0f;
            }
            if ((RIGHT.getCoordinate() - x) / aspectRatio <= 40.0f) {
                resultXVert = RIGHT.getCoordinate() - 40.0f * aspectRatio;
            }
            resultX = Math.min(resultX, Math.min(resultXHoriz, resultXVert));
        }
        return resultX;
    }

    private static float adjustRight(float x, Rect imageRect, float imageSnapRadius, float aspectRatio) {
        float resultX = x;
        if ((float)imageRect.right - x < imageSnapRadius) {
            resultX = imageRect.right;
        } else {
            float resultXHoriz = Float.NEGATIVE_INFINITY;
            float resultXVert = Float.NEGATIVE_INFINITY;
            if (x <= LEFT.getCoordinate() + 40.0f) {
                resultXHoriz = LEFT.getCoordinate() + 40.0f;
            }
            if ((x - LEFT.getCoordinate()) / aspectRatio <= 40.0f) {
                resultXVert = LEFT.getCoordinate() + 40.0f * aspectRatio;
            }
            resultX = Math.max(resultX, Math.max(resultXHoriz, resultXVert));
        }
        return resultX;
    }

    private static float adjustTop(float y, Rect imageRect, float imageSnapRadius, float aspectRatio) {
        float resultY = y;
        if (y - (float)imageRect.top < imageSnapRadius) {
            resultY = imageRect.top;
        } else {
            float resultYVert = Float.POSITIVE_INFINITY;
            float resultYHoriz = Float.POSITIVE_INFINITY;
            if (y >= BOTTOM.getCoordinate() - 40.0f) {
                resultYHoriz = BOTTOM.getCoordinate() - 40.0f;
            }
            if ((BOTTOM.getCoordinate() - y) * aspectRatio <= 40.0f) {
                resultYVert = BOTTOM.getCoordinate() - 40.0f / aspectRatio;
            }
            resultY = Math.min(resultY, Math.min(resultYHoriz, resultYVert));
        }
        return resultY;
    }

    private static float adjustBottom(float y, Rect imageRect, float imageSnapRadius, float aspectRatio) {
        float resultY = y;
        if ((float)imageRect.bottom - y < imageSnapRadius) {
            resultY = imageRect.bottom;
        } else {
            float resultYVert = Float.NEGATIVE_INFINITY;
            float resultYHoriz = Float.NEGATIVE_INFINITY;
            if (y <= TOP.getCoordinate() + 40.0f) {
                resultYVert = TOP.getCoordinate() + 40.0f;
            }
            if ((y - TOP.getCoordinate()) * aspectRatio <= 40.0f) {
                resultYHoriz = TOP.getCoordinate() + 40.0f / aspectRatio;
            }
            resultY = Math.max(resultY, Math.max(resultYHoriz, resultYVert));
        }
        return resultY;
    }
}

