/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.camera.utils.cropper.cropwindow;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.util.TypedValue;
import android.view.MotionEvent;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.hiyo.camera.camera.utils.cropper.cropwindow.edge.Edge;
import com.yy.hiyo.camera.camera.utils.cropper.cropwindow.handle.Handle;
import com.yy.hiyo.camera.camera.utils.cropper.util.AspectRatioUtil;
import com.yy.hiyo.camera.camera.utils.cropper.util.HandleUtil;
import com.yy.hiyo.camera.camera.utils.cropper.util.PaintUtil;

public class CropOverlayView
extends YYView {
    private static final int SNAP_RADIUS_DP = 6;
    private static final float DEFAULT_SHOW_GUIDELINES_LIMIT = 100.0f;
    private static final float DEFAULT_CORNER_THICKNESS_DP = PaintUtil.getCornerThickness();
    private static final float DEFAULT_LINE_THICKNESS_DP = PaintUtil.getLineThickness();
    private static final float DEFAULT_CORNER_OFFSET_DP = DEFAULT_CORNER_THICKNESS_DP / 2.0f - DEFAULT_LINE_THICKNESS_DP / 2.0f;
    private static final float DEFAULT_CORNER_EXTENSION_DP = DEFAULT_CORNER_THICKNESS_DP / 2.0f + DEFAULT_CORNER_OFFSET_DP;
    private static final float DEFAULT_CORNER_LENGTH_DP = 20.0f;
    private static final int GUIDELINES_OFF = 0;
    private static final int GUIDELINES_ON_TOUCH = 1;
    private static final int GUIDELINES_ON = 2;
    private Paint mBorderPaint;
    private Paint mGuidelinePaint;
    private Paint mCornerPaint;
    private Paint mBackgroundPaint;
    private Rect mBitmapRect;
    private float mHandleRadius;
    private float mSnapRadius;
    private Pair<Float, Float> mTouchOffset;
    private Handle mPressedHandle;
    private boolean mFixAspectRatio = false;
    private int mAspectRatioX = 1;
    private int mAspectRatioY = 1;
    private float mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
    private int mGuidelines;
    private boolean initializedCropWindow = false;
    private float mCornerExtension;
    private float mCornerOffset;
    private float mCornerLength;

    public CropOverlayView(Context context) {
        super(context);
        this.init(context);
    }

    public CropOverlayView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.initCropWindow(this.mBitmapRect);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawBackground(canvas, this.mBitmapRect);
        if (CropOverlayView.showGuidelines()) {
            if (this.mGuidelines == 2) {
                this.drawRuleOfThirdsGuidelines(canvas);
            } else if (this.mGuidelines == 1) {
                if (this.mPressedHandle != null) {
                    this.drawRuleOfThirdsGuidelines(canvas);
                }
            } else if (this.mGuidelines == 0) {
                // empty if block
            }
        }
        canvas.drawRect(Edge.LEFT.getCoordinate(), Edge.TOP.getCoordinate(), Edge.RIGHT.getCoordinate(), Edge.BOTTOM.getCoordinate(), this.mBorderPaint);
        this.drawCorners(canvas);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.onActionDown(event.getX(), event.getY());
                return true;
            }
            case 1: 
            case 3: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                this.onActionUp();
                return true;
            }
            case 2: {
                this.onActionMove(event.getX(), event.getY());
                this.getParent().requestDisallowInterceptTouchEvent(true);
                return true;
            }
        }
        return false;
    }

    public void setBitmapRect(Rect bitmapRect) {
        this.mBitmapRect = bitmapRect;
        this.initCropWindow(this.mBitmapRect);
    }

    public void resetCropOverlayView() {
        if (this.initializedCropWindow) {
            this.initCropWindow(this.mBitmapRect);
            this.invalidate();
        }
    }

    public void setGuidelines(int guidelines) {
        if (guidelines < 0 || guidelines > 2) {
            throw new IllegalArgumentException("Guideline value must be set between 0 and 2. See documentation.");
        }
        this.mGuidelines = guidelines;
        if (this.initializedCropWindow) {
            this.initCropWindow(this.mBitmapRect);
            this.invalidate();
        }
    }

    public void setFixedAspectRatio(boolean fixAspectRatio) {
        this.mFixAspectRatio = fixAspectRatio;
        if (this.initializedCropWindow) {
            this.initCropWindow(this.mBitmapRect);
            this.invalidate();
        }
    }

    public void setAspectRatioX(int aspectRatioX) {
        if (aspectRatioX <= 0) {
            throw new IllegalArgumentException("Cannot set aspect ratio value to a number less than or equal to 0.");
        }
        this.mAspectRatioX = aspectRatioX;
        this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
        if (this.initializedCropWindow) {
            this.initCropWindow(this.mBitmapRect);
            this.invalidate();
        }
    }

    public void setAspectRatioY(int aspectRatioY) {
        if (aspectRatioY <= 0) {
            throw new IllegalArgumentException("Cannot set aspect ratio value to a number less than or equal to 0.");
        }
        this.mAspectRatioY = aspectRatioY;
        this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
        if (this.initializedCropWindow) {
            this.initCropWindow(this.mBitmapRect);
            this.invalidate();
        }
    }

    public void setInitialAttributeValues(int guidelines, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY) {
        if (guidelines < 0 || guidelines > 2) {
            throw new IllegalArgumentException("Guideline value must be set between 0 and 2. See documentation.");
        }
        this.mGuidelines = guidelines;
        this.mFixAspectRatio = fixAspectRatio;
        if (aspectRatioX <= 0) {
            throw new IllegalArgumentException("Cannot set aspect ratio value to a number less than or equal to 0.");
        }
        this.mAspectRatioX = aspectRatioX;
        this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
        if (aspectRatioY <= 0) {
            throw new IllegalArgumentException("Cannot set aspect ratio value to a number less than or equal to 0.");
        }
        this.mAspectRatioY = aspectRatioY;
        this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
    }

    private void init(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mHandleRadius = HandleUtil.getTargetRadius(context);
        this.mSnapRadius = TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)displayMetrics);
        this.mBorderPaint = PaintUtil.newBorderPaint(context);
        this.mGuidelinePaint = PaintUtil.newGuidelinePaint();
        this.mBackgroundPaint = PaintUtil.newBackgroundPaint(context);
        this.mCornerPaint = PaintUtil.newCornerPaint(context);
        this.mCornerOffset = TypedValue.applyDimension((int)1, (float)DEFAULT_CORNER_OFFSET_DP, (DisplayMetrics)displayMetrics);
        this.mCornerExtension = TypedValue.applyDimension((int)1, (float)DEFAULT_CORNER_EXTENSION_DP, (DisplayMetrics)displayMetrics);
        this.mCornerLength = TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)displayMetrics);
        this.mGuidelines = 1;
    }

    private void initCropWindow(Rect bitmapRect) {
        if (!this.initializedCropWindow) {
            this.initializedCropWindow = true;
        }
        if (this.mFixAspectRatio) {
            if (AspectRatioUtil.calculateAspectRatio(bitmapRect) > this.mTargetAspectRatio) {
                Edge.TOP.setCoordinate(bitmapRect.top);
                Edge.BOTTOM.setCoordinate(bitmapRect.bottom);
                float centerX = (float)this.getWidth() / 2.0f;
                float cropWidth = Math.max(40.0f, AspectRatioUtil.calculateWidth(Edge.TOP.getCoordinate(), Edge.BOTTOM.getCoordinate(), this.mTargetAspectRatio));
                if (cropWidth == 40.0f) {
                    this.mTargetAspectRatio = 40.0f / (Edge.BOTTOM.getCoordinate() - Edge.TOP.getCoordinate());
                }
                float halfCropWidth = cropWidth / 2.0f;
                Edge.LEFT.setCoordinate(centerX - halfCropWidth);
                Edge.RIGHT.setCoordinate(centerX + halfCropWidth);
            } else {
                Edge.LEFT.setCoordinate(bitmapRect.left);
                Edge.RIGHT.setCoordinate(bitmapRect.right);
                float centerY = (float)this.getHeight() / 2.0f;
                float cropHeight = Math.max(40.0f, AspectRatioUtil.calculateHeight(Edge.LEFT.getCoordinate(), Edge.RIGHT.getCoordinate(), this.mTargetAspectRatio));
                if (cropHeight == 40.0f) {
                    this.mTargetAspectRatio = (Edge.RIGHT.getCoordinate() - Edge.LEFT.getCoordinate()) / 40.0f;
                }
                float halfCropHeight = cropHeight / 2.0f;
                Edge.TOP.setCoordinate(centerY - halfCropHeight);
                Edge.BOTTOM.setCoordinate(centerY + halfCropHeight);
            }
        } else {
            float horizontalPadding = 0.1f * (float)bitmapRect.width();
            float verticalPadding = 0.1f * (float)bitmapRect.height();
            Edge.LEFT.setCoordinate((float)bitmapRect.left + horizontalPadding);
            Edge.TOP.setCoordinate((float)bitmapRect.top + verticalPadding);
            Edge.RIGHT.setCoordinate((float)bitmapRect.right - horizontalPadding);
            Edge.BOTTOM.setCoordinate((float)bitmapRect.bottom - verticalPadding);
        }
    }

    public static boolean showGuidelines() {
        return !(Math.abs(Edge.LEFT.getCoordinate() - Edge.RIGHT.getCoordinate()) < 100.0f) && !(Math.abs(Edge.TOP.getCoordinate() - Edge.BOTTOM.getCoordinate()) < 100.0f);
    }

    private void drawRuleOfThirdsGuidelines(Canvas canvas) {
        float left = Edge.LEFT.getCoordinate();
        float top = Edge.TOP.getCoordinate();
        float right = Edge.RIGHT.getCoordinate();
        float bottom = Edge.BOTTOM.getCoordinate();
        float oneThirdCropWidth = Edge.getWidth() / 3.0f;
        float x1 = left + oneThirdCropWidth;
        canvas.drawLine(x1, top, x1, bottom, this.mGuidelinePaint);
        float x2 = right - oneThirdCropWidth;
        canvas.drawLine(x2, top, x2, bottom, this.mGuidelinePaint);
        float oneThirdCropHeight = Edge.getHeight() / 3.0f;
        float y1 = top + oneThirdCropHeight;
        canvas.drawLine(left, y1, right, y1, this.mGuidelinePaint);
        float y2 = bottom - oneThirdCropHeight;
        canvas.drawLine(left, y2, right, y2, this.mGuidelinePaint);
    }

    private void drawBackground(Canvas canvas, Rect bitmapRect) {
        float left = Edge.LEFT.getCoordinate();
        float top = Edge.TOP.getCoordinate();
        float right = Edge.RIGHT.getCoordinate();
        float bottom = Edge.BOTTOM.getCoordinate();
        canvas.drawRect((float)bitmapRect.left, (float)bitmapRect.top, (float)bitmapRect.right, top, this.mBackgroundPaint);
        canvas.drawRect((float)bitmapRect.left, bottom, (float)bitmapRect.right, (float)bitmapRect.bottom, this.mBackgroundPaint);
        canvas.drawRect((float)bitmapRect.left, top, left, bottom, this.mBackgroundPaint);
        canvas.drawRect(right, top, (float)bitmapRect.right, bottom, this.mBackgroundPaint);
    }

    private void drawCorners(Canvas canvas) {
        float left = Edge.LEFT.getCoordinate();
        float top = Edge.TOP.getCoordinate();
        float right = Edge.RIGHT.getCoordinate();
        float bottom = Edge.BOTTOM.getCoordinate();
        canvas.drawLine(left - this.mCornerOffset, top - this.mCornerExtension, left - this.mCornerOffset, top + this.mCornerLength, this.mCornerPaint);
        canvas.drawLine(left, top - this.mCornerOffset, left + this.mCornerLength, top - this.mCornerOffset, this.mCornerPaint);
        canvas.drawLine(right + this.mCornerOffset, top - this.mCornerExtension, right + this.mCornerOffset, top + this.mCornerLength, this.mCornerPaint);
        canvas.drawLine(right, top - this.mCornerOffset, right - this.mCornerLength, top - this.mCornerOffset, this.mCornerPaint);
        canvas.drawLine(left - this.mCornerOffset, bottom + this.mCornerExtension, left - this.mCornerOffset, bottom - this.mCornerLength, this.mCornerPaint);
        canvas.drawLine(left, bottom + this.mCornerOffset, left + this.mCornerLength, bottom + this.mCornerOffset, this.mCornerPaint);
        canvas.drawLine(right + this.mCornerOffset, bottom + this.mCornerExtension, right + this.mCornerOffset, bottom - this.mCornerLength, this.mCornerPaint);
        canvas.drawLine(right, bottom + this.mCornerOffset, right - this.mCornerLength, bottom + this.mCornerOffset, this.mCornerPaint);
    }

    private void onActionDown(float x, float y) {
        float left = Edge.LEFT.getCoordinate();
        float top = Edge.TOP.getCoordinate();
        float right = Edge.RIGHT.getCoordinate();
        float bottom = Edge.BOTTOM.getCoordinate();
        this.mPressedHandle = HandleUtil.getPressedHandle(x, y, left, top, right, bottom, this.mHandleRadius);
        if (this.mPressedHandle == null) {
            return;
        }
        this.mTouchOffset = HandleUtil.getOffset(this.mPressedHandle, x, y, left, top, right, bottom);
        this.invalidate();
    }

    private void onActionUp() {
        if (this.mPressedHandle == null) {
            return;
        }
        this.mPressedHandle = null;
        this.invalidate();
    }

    private void onActionMove(float x, float y) {
        if (this.mPressedHandle == null) {
            return;
        }
        x += ((Float)this.mTouchOffset.first).floatValue();
        y += ((Float)this.mTouchOffset.second).floatValue();
        if (this.mFixAspectRatio) {
            this.mPressedHandle.updateCropWindow(x, y, this.mTargetAspectRatio, this.mBitmapRect, this.mSnapRadius);
        } else {
            this.mPressedHandle.updateCropWindow(x, y, this.mBitmapRect, this.mSnapRadius);
        }
        this.invalidate();
    }
}

