/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.camera;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.load.DataSource;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.hiyo.camera.R;
import com.yy.hiyo.camera.camera.AbsCameraPage;
import com.yy.hiyo.camera.camera.CameraPresenter;

public class PhotoUploadPage
extends AbsCameraPage {
    public static final String TAG = "PhotoUploadPage";
    private CameraPresenter mCameraPresenter;
    private RecycleImageView mIvPhoto;

    public PhotoUploadPage(Context context, CameraPresenter presenter) {
        super(context);
        this.mCameraPresenter = presenter;
        this.createView(context);
    }

    private void createView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.window_edit_single_photo, (ViewGroup)this);
        this.mIvPhoto = (RecycleImageView)this.findViewById(R.id.iv_photo);
        this.findViewById(R.id.tv_chose).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PhotoUploadPage.this.mCameraPresenter != null) {
                    PhotoUploadPage.this.mCameraPresenter.onChoose();
                }
            }
        });
        this.findViewById(R.id.tv_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PhotoUploadPage.this.mCameraPresenter != null) {
                    PhotoUploadPage.this.mCameraPresenter.onCancel();
                }
            }
        });
    }

    @Override
    public void showPicture(Bitmap bitmap) {
        this.mIvPhoto.setImageBitmap(bitmap);
    }

    @Override
    public void showMediaFromUrl(String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            ImageLoader.loadImage((ImageView)this.mIvPhoto, (String)url, (int)-1, (int)-1, (ImageLoader.ImageLoadListener)new ImageLoader.ImageLoadListener(){

                public void onLoadFailed(Exception e) {
                    PhotoUploadPage.this.mCameraPresenter.onImageLoadFailed();
                }

                public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                    if (resource == null) {
                        PhotoUploadPage.this.mCameraPresenter.onImageLoadFailed();
                        return;
                    }
                }
            });
        }
    }

    @Override
    public void saveMediaToFile() {
    }
}

