/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.camera;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.camera.camera.ISetCroppedRectListener;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0006\u0010%\u001a\u00020\u0012J\u0006\u0010&\u001a\u00020\u001bJ\b\u0010'\u001a\u00020\"H\u0002J\u0010\u0010(\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J(\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\t2\u0006\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\tH\u0014J\u000e\u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u00020\u0012J\u0010\u00100\u001a\u00020\"2\b\u00101\u001a\u0004\u0018\u00010 R\u000e\u0010\u000b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/yy/hiyo/camera/camera/CropView;", "Lcom/yy/base/memoryrecycle/views/YYFrameLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mBorderColor", "mBorderPaint", "Landroid/graphics/Paint;", "mBorderWidth", "mClipPathExceptionHappened", "", "mCropRatio", "", "mDivisionColor", "mDivisionWidth", "mFocusHeight", "mFocusMidPoint", "Landroid/graphics/PointF;", "mFocusPath", "Landroid/graphics/Path;", "mFocusRect", "Landroid/graphics/RectF;", "mFocusWidth", "mInit", "mMaskColor", "mSetCroppedRectListener", "Lcom/yy/hiyo/camera/camera/ISetCroppedRectListener;", "drawCanvas", "", "canvas", "Landroid/graphics/Canvas;", "getCropRatio", "getCropRect", "initViewContent", "onDraw", "onSizeChanged", "w", "h", "oldw", "oldh", "setCropRatio", "cropRatio", "setSetCroppedRectListener", "listener", "camera_debug"})
public final class CropView
extends YYFrameLayout {
    private final int mMaskColor = -1358954496;
    private final int mBorderColor = -1;
    private final int mBorderWidth = ResolutionUtils.dip2Px((float)2.0f);
    private final int mDivisionColor = ColorUtils.parseColor((String)"#80FFFFFF");
    private final int mDivisionWidth = ResolutionUtils.dip2Px((float)1.0f);
    private int mFocusWidth;
    private int mFocusHeight;
    private float mCropRatio = 1.0f;
    private final Paint mBorderPaint = new Paint();
    private final Path mFocusPath = new Path();
    private final RectF mFocusRect = new RectF();
    private PointF mFocusMidPoint = new PointF();
    private boolean mInit;
    private boolean mClipPathExceptionHappened;
    private ISetCroppedRectListener mSetCroppedRectListener;
    private HashMap _$_findViewCache;

    public final float getCropRatio() {
        return this.mCropRatio;
    }

    public final void setCropRatio(float cropRatio) {
        this.mCropRatio = cropRatio;
        this.initViewContent();
    }

    public final void setSetCroppedRectListener(@Nullable ISetCroppedRectListener listener) {
        this.mSetCroppedRectListener = listener;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mInit = true;
        this.initViewContent();
    }

    @NotNull
    public final RectF getCropRect() {
        return this.mFocusRect;
    }

    private final void initViewContent() {
        if (Build.VERSION.SDK_INT < 19) {
            this.setLayerType(1, null);
        }
        if (!this.mInit) {
            return;
        }
        float midPointX = (float)this.getWidth() / (float)2;
        float midPointY = (float)this.getHeight() / (float)2;
        this.mFocusMidPoint = new PointF(midPointX, midPointY);
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            int cropWidth = 0;
            int cropHeight = 0;
            int interval = ResolutionUtils.dip2Px((float)40.0f);
            if ((float)this.getWidth() < this.mCropRatio * (float)this.getHeight()) {
                cropWidth = this.getWidth() - interval;
                cropHeight = (int)((float)cropWidth * 1.0f / this.mCropRatio);
            } else {
                cropHeight = this.getHeight() - interval;
                cropWidth = (int)((float)cropHeight * this.mCropRatio);
            }
            this.mFocusWidth = cropWidth;
            this.mFocusHeight = cropHeight;
        }
        this.mFocusRect.left = this.mFocusMidPoint.x - (float)(this.mFocusWidth / 2);
        this.mFocusRect.right = this.mFocusMidPoint.x + (float)(this.mFocusWidth / 2);
        this.mFocusRect.top = this.mFocusMidPoint.y - (float)(this.mFocusHeight / 2);
        this.mFocusRect.bottom = this.mFocusMidPoint.y + (float)(this.mFocusHeight / 2);
        ISetCroppedRectListener iSetCroppedRectListener = this.mSetCroppedRectListener;
        if (iSetCroppedRectListener != null) {
            iSetCroppedRectListener.setCroppedRect(this.mFocusRect);
        }
        this.invalidate();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (Build.VERSION.SDK_INT >= 19) {
            this.drawCanvas(canvas);
        } else if (!this.mClipPathExceptionHappened) {
            try {
                this.drawCanvas(canvas);
            }
            catch (UnsupportedOperationException e) {
                MLog.error((Object)"NewCropImageView", (Throwable)e);
                this.mClipPathExceptionHappened = true;
            }
        }
        this.mBorderPaint.setColor(this.mBorderColor);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setStrokeWidth((float)this.mBorderWidth);
        this.mBorderPaint.setAntiAlias(true);
        canvas.drawPath(this.mFocusPath, this.mBorderPaint);
        this.mFocusPath.reset();
        this.mBorderPaint.setColor(this.mDivisionColor);
        this.mBorderPaint.setStrokeWidth((float)this.mDivisionWidth);
        canvas.drawLine((float)(this.mFocusWidth / 3) + this.mFocusRect.left, this.mFocusRect.top, (float)(this.mFocusWidth / 3) + this.mFocusRect.left, this.mFocusRect.bottom, this.mBorderPaint);
        canvas.drawLine((float)(this.mFocusWidth / 3 * 2) + this.mFocusRect.left, this.mFocusRect.top, (float)(this.mFocusWidth / 3 * 2) + this.mFocusRect.left, this.mFocusRect.bottom, this.mBorderPaint);
        canvas.drawLine(this.mFocusRect.left, (float)(this.mFocusHeight / 3) + this.mFocusRect.top, this.mFocusRect.right, (float)(this.mFocusHeight / 3) + this.mFocusRect.top, this.mBorderPaint);
        canvas.drawLine(this.mFocusRect.left, (float)(this.mFocusHeight / 3 * 2) + this.mFocusRect.top, this.mFocusRect.right, (float)(this.mFocusHeight / 3 * 2) + this.mFocusRect.top, this.mBorderPaint);
    }

    private final void drawCanvas(Canvas canvas) {
        this.mFocusPath.addRect(this.mFocusRect, Path.Direction.CCW);
        canvas.save();
        canvas.clipRect(0, 0, this.getWidth(), this.getHeight());
        canvas.clipPath(this.mFocusPath, Region.Op.DIFFERENCE);
        canvas.drawColor(this.mMaskColor);
        canvas.restore();
    }

    public CropView(@Nullable Context context) {
        this(context, null);
    }

    public CropView(@Nullable Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CropView(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setBackgroundColor(0);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

