/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.camera.camera;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.YYFileUtils;
import com.yy.hiyo.camera.camera.BeCroppedView;
import com.yy.hiyo.camera.camera.ISetCroppedRectListener;
import com.yy.hiyo.camera.camera.OnMediaSaveCompleteListener;
import com.yy.hiyo.videoprocess.IVideoProcessFinishCallback;
import com.yy.hiyo.videoprocess.IVideoProcessService;
import java.io.File;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 S2\u00020\u00012\u00020\u0002:\u0001SB\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB#\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020'H\u0002J\u0018\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\nJ\b\u0010-\u001a\u00020\u0012H\u0002J0\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\n2\u0006\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\n2\u0006\u00103\u001a\u00020\u0015H\u0002J\u0006\u00104\u001a\u00020\u0012J\u0016\u00105\u001a\u00020'2\u0006\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\nJ\b\u00108\u001a\u00020'H\u0002J4\u00109\u001a\u0004\u0018\u00010*2\u0006\u0010:\u001a\u00020*2\u0006\u0010;\u001a\u00020\u00122\b\u0010<\u001a\u0004\u0018\u00010\u00122\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\nH\u0002J\b\u0010=\u001a\u00020\rH\u0002J\u0012\u0010>\u001a\u00020'2\b\u0010?\u001a\u0004\u0018\u00010@H\u0014J(\u0010A\u001a\u00020'2\u0006\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020\n2\u0006\u0010E\u001a\u00020\nH\u0014J\u0010\u0010F\u001a\u00020\u00152\u0006\u0010G\u001a\u00020HH\u0016J\u0016\u0010I\u001a\u00020'2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\nJ\u0010\u0010J\u001a\u00020'2\u0006\u0010K\u001a\u00020\u0012H\u0016J\u0010\u0010L\u001a\u00020'2\b\u0010M\u001a\u0004\u0018\u00010\u0017J\u0018\u0010N\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010H\u0002J(\u0010N\u001a\u00020\r2\u0006\u0010O\u001a\u00020\r2\u0006\u0010P\u001a\u00020\r2\u0006\u0010Q\u001a\u00020\r2\u0006\u0010R\u001a\u00020\rH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/yy/hiyo/camera/camera/BeCroppedView;", "Lcom/yy/base/memoryrecycle/views/YYFrameLayout;", "Lcom/yy/hiyo/camera/camera/ISetCroppedRectListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "MAX_SCALE", "", "mFocusHeight", "mFocusMidPoint", "Landroid/graphics/PointF;", "mFocusRect", "Landroid/graphics/RectF;", "mFocusWidth", "mInit", "", "mListener", "Lcom/yy/hiyo/camera/camera/OnMediaSaveCompleteListener;", "mMatrix", "Landroid/graphics/Matrix;", "mMaxScale", "mMode", "mSaving", "mVideoHeight", "mVideoPath", "", "mVideoWidth", "midPoint", "oldDist", "pA", "pB", "savedMatrix", "fixScale", "", "fixTranslation", "getCropBitmap", "Landroid/graphics/Bitmap;", "expectWidth", "exceptHeight", "getImageMatrixRect", "getScale", "bitmapWidth", "bitmapHeight", "minWidth", "minHeight", "isMinScale", "getVideoRealRect", "initVideoParams", "contentWidth", "contentHeight", "initViewContent", "makeCropBitmap", "bitmap", "focusRect", "imageMatrixRect", "maxPostScale", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "saveBitmapToFile", "setCroppedRect", "rectF", "setOnMediaSaveCompleteListener", "listener", "spacing", "x1", "y1", "x2", "y2", "Companion", "camera_debug"})
public final class BeCroppedView
extends YYFrameLayout
implements ISetCroppedRectListener {
    private int mFocusWidth;
    private int mFocusHeight;
    private RectF mFocusRect;
    private final float MAX_SCALE = 4.0f;
    private Matrix mMatrix = new Matrix();
    private final Matrix savedMatrix = new Matrix();
    private final PointF pA = new PointF();
    private final PointF pB = new PointF();
    private final PointF midPoint = new PointF();
    private PointF mFocusMidPoint = new PointF();
    private int mMode;
    private float oldDist = 1.0f;
    private float mMaxScale = this.MAX_SCALE;
    private boolean mInit;
    private boolean mSaving;
    private String mVideoPath = "";
    private int mVideoWidth;
    private int mVideoHeight;
    private OnMediaSaveCompleteListener mListener;
    @NotNull
    public static final String TAG = "BeCroppedView";
    private static final int NONE = 0;
    private static final int DRAG = 1;
    private static final int ZOOM = 2;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final void initVideoParams(int contentWidth, int contentHeight) {
        this.mVideoWidth = contentWidth;
        this.mVideoHeight = contentHeight;
        this.initViewContent();
    }

    @Override
    public void setCroppedRect(@NotNull RectF rectF) {
        Intrinsics.checkParameterIsNotNull((Object)rectF, (String)"rectF");
        this.mFocusRect = rectF;
        this.initViewContent();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mInit = true;
        this.initViewContent();
    }

    private final void initViewContent() {
        if (Build.VERSION.SDK_INT < 19) {
            this.setLayerType(1, null);
        }
        if (!this.mInit || this.mFocusRect == null) {
            return;
        }
        this.mMode = 0;
        float midPointX = (float)this.getWidth() / (float)2;
        float midPointY = (float)this.getHeight() / (float)2;
        this.mFocusMidPoint = new PointF(midPointX, midPointY);
        RectF rectF = this.mFocusRect;
        if (rectF == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFocusRect");
        }
        this.mFocusWidth = (int)rectF.width();
        RectF rectF2 = this.mFocusRect;
        if (rectF2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFocusRect");
        }
        this.mFocusHeight = (int)rectF2.height();
        float fitFocusScale = this.getScale(this.mVideoWidth, this.mVideoHeight, this.mFocusWidth, this.mFocusHeight, true);
        this.mMaxScale = fitFocusScale * this.MAX_SCALE;
        float fitViewScale = this.getScale(this.mVideoWidth, this.mVideoHeight, this.getWidth(), this.getHeight(), false);
        float scale = fitViewScale > fitFocusScale ? fitViewScale : fitFocusScale;
        this.mMatrix.setScale(scale, scale, (float)this.getWidth() / (float)2, (float)this.getHeight() / (float)2);
        float[] mImageMatrixValues = new float[9];
        this.mMatrix.getValues(mImageMatrixValues);
        float transX = this.mFocusMidPoint.x - (mImageMatrixValues[2] + (float)this.getWidth() * mImageMatrixValues[0] / (float)2);
        float transY = this.mFocusMidPoint.y - (mImageMatrixValues[5] + (float)this.getHeight() * mImageMatrixValues[4] / (float)2);
        this.mMatrix.postTranslate(transX, transY);
        StringBuilder stringBuilder = new StringBuilder().append("initViewContent, mFocusRect:");
        RectF rectF3 = this.mFocusRect;
        if (rectF3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFocusRect");
        }
        MLog.info((Object)TAG, (String)stringBuilder.append(rectF3).append(", mMatrix:").append(this.mMatrix).toString(), (Object[])new Object[0]);
        this.invalidate();
    }

    private final float getScale(int bitmapWidth, int bitmapHeight, int minWidth, int minHeight, boolean isMinScale) {
        float scale = 0.0f;
        float scaleX = (float)minWidth / (float)bitmapWidth;
        float scaleY = (float)minHeight / (float)bitmapHeight;
        scale = isMinScale ? (scaleX > scaleY ? scaleX : scaleY) : (scaleX < scaleY ? scaleX : scaleY);
        return scale;
    }

    protected void onDraw(@Nullable Canvas canvas) {
        super.onDraw(canvas);
        this.setLayerType(2, null);
        Canvas canvas2 = canvas;
        if (canvas2 != null) {
            canvas2.concat(this.mMatrix);
        }
        this.setLayerType(0, null);
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (this.mSaving) {
            return super.onTouchEvent(event);
        }
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.savedMatrix.set(this.mMatrix);
                this.pA.set(event.getX(), event.getY());
                this.pB.set(event.getX(), event.getY());
                this.mMode = 1;
                MLog.info((Object)TAG, (String)("onTouchEvent,ACTION_DOWN,event.x=" + event.getX() + ",event.y=" + event.getY()), (Object[])new Object[0]);
                break;
            }
            case 5: {
                if (event.getActionIndex() > 1 || event.getPointerCount() < 2) break;
                this.pA.set(event.getX(0), event.getY(0));
                this.pB.set(event.getX(1), event.getY(1));
                this.midPoint.set((this.pA.x + this.pB.x) / (float)2, (this.pA.y + this.pB.y) / (float)2);
                this.oldDist = this.spacing(this.pA, this.pB);
                this.savedMatrix.set(this.mMatrix);
                if (!(this.oldDist > 10.0f)) break;
                this.mMode = 2;
                break;
            }
            case 2: {
                float newDist;
                if (this.mMode == 1) {
                    MLog.info((Object)TAG, (String)("onTouchEvent,ACTION_MOVE,event.x=" + event.getX() + ",event.y=" + event.getY() + ",pA.x=" + this.pA.x + ",pA.y=" + this.pA.y), (Object[])new Object[0]);
                    this.mMatrix.set(this.savedMatrix);
                    this.mMatrix.postTranslate(event.getX() - this.pA.x, event.getY() - this.pA.y);
                    MLog.info((Object)TAG, (String)("onTouchEvent,ACTION_MOVE,mMatrix=" + this.mMatrix), (Object[])new Object[0]);
                    this.fixTranslation();
                    break;
                }
                if (this.mMode != 2 || event.getPointerCount() < 2 || !((newDist = this.spacing(event.getX(0), event.getY(0), event.getX(1), event.getY(1))) > 10.0f)) break;
                this.mMatrix.set(this.savedMatrix);
                float tScale = Math.min(newDist / this.oldDist, this.maxPostScale());
                RectF imageRect = null;
                if (tScale < 1.0f) {
                    imageRect = new RectF(0.0f, 0.0f, (float)this.mVideoWidth, (float)this.mVideoHeight);
                    this.mMatrix.mapRect(imageRect);
                } else {
                    this.mMatrix.postScale(tScale, tScale, this.midPoint.x, this.midPoint.y);
                    this.fixScale();
                    this.fixTranslation();
                }
                RectF rectF = imageRect;
                if (rectF != null) {
                    RectF rectF2 = rectF;
                    boolean bl = false;
                    boolean bl2 = false;
                    RectF it = rectF2;
                    boolean bl3 = false;
                    float f = it.left;
                    RectF rectF3 = this.mFocusRect;
                    if (rectF3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mFocusRect");
                    }
                    if (!(f < rectF3.left)) {
                        float f2 = it.right;
                        RectF rectF4 = this.mFocusRect;
                        if (rectF4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"mFocusRect");
                        }
                        if (!(f2 > rectF4.right)) break;
                    }
                    float f3 = it.top;
                    RectF rectF5 = this.mFocusRect;
                    if (rectF5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mFocusRect");
                    }
                    if (!(f3 < rectF5.top)) break;
                    float f4 = it.bottom;
                    RectF rectF6 = this.mFocusRect;
                    if (rectF6 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mFocusRect");
                    }
                    if (!(f4 > rectF6.bottom)) break;
                    this.mMatrix.postScale(tScale, tScale, this.midPoint.x, this.midPoint.y);
                    this.fixScale();
                    this.fixTranslation();
                }
                break;
            }
            case 1: 
            case 6: {
                this.mMode = 0;
                break;
            }
        }
        this.postInvalidate();
        return true;
    }

    private final void fixScale() {
        float[] imageMatrixValues = new float[9];
        this.mMatrix.getValues(imageMatrixValues);
        float currentScale = Math.abs(imageMatrixValues[0]) + Math.abs(imageMatrixValues[1]);
        float minScale = this.getScale(this.mVideoWidth, this.mVideoHeight, this.mFocusWidth, this.mFocusHeight, true);
        this.mMaxScale = minScale * this.MAX_SCALE;
        if (currentScale < minScale) {
            float scale = minScale / currentScale;
            this.mMatrix.postScale(scale, scale);
        } else if (currentScale > this.mMaxScale) {
            float scale = this.mMaxScale / currentScale;
            this.mMatrix.postScale(scale, scale);
        }
    }

    private final void fixTranslation() {
        RectF imageRect = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        this.mMatrix.mapRect(imageRect);
        float[] matrixValues = new float[9];
        this.mMatrix.getValues(matrixValues);
        float realLeft = imageRect.left + imageRect.width() / (float)2 - (float)(this.mVideoWidth / 2) * matrixValues[0];
        float realTop = imageRect.top + imageRect.height() / (float)2 - (float)(this.mVideoHeight / 2) * matrixValues[4];
        float realRight = realLeft + (float)this.mVideoWidth * matrixValues[0];
        float realBottom = realTop + (float)this.mVideoHeight * matrixValues[4];
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        RectF rectF = this.mFocusRect;
        if (rectF == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFocusRect");
        }
        if (realLeft > rectF.left) {
            float f = -realLeft;
            RectF rectF2 = this.mFocusRect;
            if (rectF2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFocusRect");
            }
            deltaX = f + rectF2.left;
        } else {
            RectF rectF3 = this.mFocusRect;
            if (rectF3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFocusRect");
            }
            if (realRight < rectF3.right) {
                float f = -realRight;
                RectF rectF4 = this.mFocusRect;
                if (rectF4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mFocusRect");
                }
                deltaX = f + rectF4.right;
            }
        }
        RectF rectF5 = this.mFocusRect;
        if (rectF5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFocusRect");
        }
        if (realTop > rectF5.top) {
            float f = -realTop;
            RectF rectF6 = this.mFocusRect;
            if (rectF6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFocusRect");
            }
            deltaY = f + rectF6.top;
        } else {
            RectF rectF7 = this.mFocusRect;
            if (rectF7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFocusRect");
            }
            if (realBottom < rectF7.bottom) {
                float f = -realBottom;
                RectF rectF8 = this.mFocusRect;
                if (rectF8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mFocusRect");
                }
                deltaY = f + rectF8.bottom;
            }
        }
        this.mMatrix.postTranslate(deltaX, deltaY);
    }

    @NotNull
    public final RectF getVideoRealRect() {
        RectF imageRect = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        this.mMatrix.mapRect(imageRect);
        float[] matrixValues = new float[9];
        this.mMatrix.getValues(matrixValues);
        float realLeft = imageRect.left + imageRect.width() / (float)2 - (float)(this.mVideoWidth / 2) * matrixValues[0];
        float realTop = imageRect.top + imageRect.height() / (float)2 - (float)(this.mVideoHeight / 2) * matrixValues[4];
        float realRight = realLeft + (float)this.mVideoWidth * matrixValues[0];
        float realBottom = realTop + (float)this.mVideoHeight * matrixValues[4];
        return new RectF(realLeft, realTop, realRight, realBottom);
    }

    private final float maxPostScale() {
        float[] imageMatrixValues = new float[9];
        this.mMatrix.getValues(imageMatrixValues);
        float curScale = Math.abs(imageMatrixValues[0]) + Math.abs(imageMatrixValues[1]);
        return this.mMaxScale / curScale;
    }

    private final float spacing(float x1, float y1, float x2, float y2) {
        float x = x1 - x2;
        float y = y1 - y2;
        return (float)Math.sqrt((double)(x * x) + (double)y * (double)y);
    }

    private final float spacing(PointF pA, PointF pB) {
        return this.spacing(pA.x, pA.y, pB.x, pB.y);
    }

    @Nullable
    public final Bitmap getCropBitmap(int expectWidth, int exceptHeight) {
        return null;
    }

    private final RectF getImageMatrixRect() {
        RectF rectF = new RectF();
        rectF.set(0.0f, 0.0f, (float)this.mVideoWidth, (float)this.mVideoHeight);
        this.mMatrix.mapRect(rectF);
        return rectF;
    }

    private final Bitmap makeCropBitmap(Bitmap bitmap, RectF focusRect, RectF imageMatrixRect, int expectWidth, int exceptHeight) {
        Bitmap bitmap2 = bitmap;
        if (imageMatrixRect == null || bitmap2 == null) {
            return null;
        }
        float scale = imageMatrixRect.width() / (float)bitmap2.getWidth();
        int left = (int)((focusRect.left - imageMatrixRect.left) / scale);
        int top = (int)((focusRect.top - imageMatrixRect.top) / scale);
        int width = (int)(focusRect.width() / scale);
        int height = (int)(focusRect.height() / scale);
        if (left < 0) {
            left = 0;
        }
        if (top < 0) {
            top = 0;
        }
        if (left + width > bitmap2.getWidth()) {
            width = bitmap2.getWidth() - left;
        }
        if (top + height > bitmap2.getHeight()) {
            height = bitmap2.getHeight() - top;
        }
        try {
            bitmap2 = Bitmap.createBitmap((Bitmap)bitmap2, (int)left, (int)top, (int)width, (int)height);
            if (expectWidth != width || exceptHeight != height) {
                bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)expectWidth, (int)exceptHeight, (boolean)true);
            }
        }
        catch (OutOfMemoryError e) {
            MLog.error((Object)"NewCropImageView", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            MLog.error((Object)"NewCropImageView", (Throwable)e);
        }
        return bitmap2;
    }

    public final void saveBitmapToFile(int expectWidth, int exceptHeight) {
        if (this.mSaving) {
            return;
        }
        this.mSaving = true;
        RectF rect = this.getImageMatrixRect();
        Bitmap croppedImage = this.getCropBitmap(expectWidth, exceptHeight);
        Bitmap.CompressFormat outputFormat = Bitmap.CompressFormat.JPEG;
        String mExtension = ".jpg";
        String extension = TextUtils.isEmpty((CharSequence)YYFileUtils.getFileExtension((String)this.mVideoPath)) ? ".mp4" : YYFileUtils.getFileExtension((String)this.mVideoPath);
        File saveFile = YYFileUtils.getTempFile((Context)this.getContext(), (String)(String.valueOf(AccountUtil.getUid()) + "_" + System.currentTimeMillis() + extension));
        IVideoProcessService iVideoProcessService = (IVideoProcessService)ServiceManagerProxy.getInstance().getService(IVideoProcessService.class);
        File file = saveFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"saveFile");
        iVideoProcessService.cropVideo(this.mVideoPath, rect, this.mVideoWidth, this.mVideoHeight, file.getAbsolutePath(), new IVideoProcessFinishCallback(this, saveFile){
            final /* synthetic */ BeCroppedView this$0;
            final /* synthetic */ File $saveFile;

            public void onVideoProcessSuccess(@NotNull String path) {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, path){
                    final /* synthetic */ saveBitmapToFile.1 this$0;
                    final /* synthetic */ String $path;

                    public final void run() {
                        block0: {
                            OnMediaSaveCompleteListener onMediaSaveCompleteListener = BeCroppedView.access$getMListener$p(this.this$0.this$0);
                            if (onMediaSaveCompleteListener == null) break block0;
                            onMediaSaveCompleteListener.onMediaSaveSuccess(new File(this.$path));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$path = string2;
                    }
                });
            }

            public void onVideoProcessError() {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                    final /* synthetic */ saveBitmapToFile.1 this$0;

                    public final void run() {
                        block0: {
                            OnMediaSaveCompleteListener onMediaSaveCompleteListener = BeCroppedView.access$getMListener$p(this.this$0.this$0);
                            if (onMediaSaveCompleteListener == null) break block0;
                            onMediaSaveCompleteListener.onMediaSaveError(this.this$0.$saveFile);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = $outer;
                this.$saveFile = $captured_local_variable$1;
            }
        });
    }

    public final void setOnMediaSaveCompleteListener(@Nullable OnMediaSaveCompleteListener listener) {
        this.mListener = listener;
    }

    public BeCroppedView(@Nullable Context context) {
        this(context, null);
    }

    public BeCroppedView(@Nullable Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BeCroppedView(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setBackgroundColor(0);
    }

    public static final /* synthetic */ RectF access$getMFocusRect$p(BeCroppedView $this) {
        RectF rectF = $this.mFocusRect;
        if (rectF == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFocusRect");
        }
        return rectF;
    }

    public static final /* synthetic */ void access$setMFocusRect$p(BeCroppedView $this, RectF rectF) {
        $this.mFocusRect = rectF;
    }

    public static final /* synthetic */ OnMediaSaveCompleteListener access$getMListener$p(BeCroppedView $this) {
        return $this.mListener;
    }

    public static final /* synthetic */ void access$setMListener$p(BeCroppedView $this, OnMediaSaveCompleteListener onMediaSaveCompleteListener) {
        $this.mListener = onMediaSaveCompleteListener;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/yy/hiyo/camera/camera/BeCroppedView$Companion;", "", "()V", "DRAG", "", "NONE", "TAG", "", "ZOOM", "camera_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

