/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.seat;

import android.graphics.Typeface;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.utils.FontUtils;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.component.seat.holder.SeatItemHolder;
import com.yy.hiyo.channel.plugins.bocai.R;
import com.yy.hiyo.channel.plugins.bocai.data.WealthDataService;
import com.yy.hiyo.channel.plugins.bocai.seat.bean.WealthSeatItem;

public class WealthSeatItemHolder
extends SeatItemHolder<WealthSeatItem> {
    private TextView mTvDiamond;
    private RecycleImageView mRvDiamond;
    private RelativeLayout mRlDiamond;
    private LinearLayout mLlDiamondView;
    private TextView mTvDiamondUnknow;

    public WealthSeatItemHolder(View itemView, IChannelPageContext pageContext) {
        super(itemView, pageContext);
        this.initView();
    }

    private void initView() {
        this.mTvDiamond = (TextView)this.itemView.findViewById(R.id.seat_diamond_view);
        FontUtils.setFontType((TextView)this.mTvDiamond, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mRvDiamond = (RecycleImageView)this.itemView.findViewById(R.id.rv_diamond_view);
        this.mRlDiamond = (RelativeLayout)this.itemView.findViewById(R.id.rl_seat_diamond_view);
        this.mLlDiamondView = (LinearLayout)this.itemView.findViewById(R.id.ll_seat_diamond_content);
        this.mTvDiamondUnknow = (TextView)this.itemView.findViewById(R.id.tv_seat_diamond_unknow);
    }

    protected void updateReadyIcon() {
        super.updateReadyIcon();
        WealthSeatItem wealthSeatItem = (WealthSeatItem)((Object)this.getData());
        if (wealthSeatItem != null) {
            if (wealthSeatItem.isReady()) {
                this.mReadyIcon.setVisibility(0);
                this.mReadyIcon.setImageResource(R.drawable.icon_seat_ready);
            } else {
                this.mReadyIcon.setVisibility(8);
            }
        }
    }

    public void setData(WealthSeatItem data) {
        data.mCalculatorData.setNeedLarge(true);
        super.setData((SeatItem)data);
        if (!data.hasUser()) {
            this.mRlDiamond.setVisibility(8);
        } else {
            int status = WealthDataService.INSTANCE.getWealthDataModel().getGameStatus();
            FeatureLog.i((String)"FTWealth", (String)"status:%s", (Object[])new Object[]{status});
            if (status == 2) {
                this.mReadyIcon.setVisibility(8);
                if (data.getDiamond() == 0) {
                    this.mRlDiamond.setVisibility(8);
                } else {
                    this.mRlDiamond.setVisibility(0);
                    if (data.hasShowResult()) {
                        this.mLlDiamondView.setVisibility(0);
                        this.mTvDiamondUnknow.setVisibility(8);
                        this.mTvDiamond.setText((CharSequence)(data.getDiamond() + ""));
                    } else {
                        this.mLlDiamondView.setVisibility(8);
                        this.mTvDiamondUnknow.setVisibility(0);
                    }
                }
            } else {
                this.mRlDiamond.setVisibility(8);
            }
        }
    }

    public long getUid() {
        return ((WealthSeatItem)((Object)this.getData())).uid;
    }
}

