/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.videoeffect.thunderbolt.util;

import com.yy.mediaframework.utils.FileUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import tv.athena.live.component.videoeffect.thunderbolt.util.LogWrapper;

public class BeautyUtil {
    private static final String TAG = "BeautyUtil";

    public static String getFileFromSD(String fileName) {
        String result = "";
        try {
            FileInputStream inputStream = new FileInputStream(fileName);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                result = result + line;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (Exception e) {
            LogWrapper.i(TAG, "[Exception] e: " + e.toString());
        }
        return result;
    }

    public static boolean isFileExist(String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    public static void safeClose(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            LogWrapper.e("IOException", e.fillInStackTrace().toString());
        }
    }

    public static boolean checkEffectResIsExit(String jsonFile) {
        if (jsonFile != null) {
            String stickerJson = BeautyUtil.getFileFromSD(jsonFile);
            String jsonFileDir = jsonFile.substring(0, jsonFile.lastIndexOf("/") + 1);
            try {
                JSONObject jsonObject = new JSONObject(stickerJson);
                JSONArray jsonArray = jsonObject.getJSONArray("filter_list");
                for (int i = 0; i < jsonArray.length(); ++i) {
                    String imageFileName;
                    String pngFullPath;
                    String pngFullPath2;
                    JSONArray pngPathArr;
                    String jsonType = jsonObject.getJSONArray("filter_list").optJSONObject(i).optString("type");
                    if (jsonType.equals("Face2dAnimationFilter")) {
                        JSONArray animationArr = jsonArray.optJSONObject(i).optJSONObject("ext_data").getJSONArray("animationArr");
                        for (int j = 0; j < animationArr.length(); ++j) {
                            JSONArray pngPathArr2 = animationArr.optJSONObject(j).getJSONArray("pngPathArr");
                            for (int k = 0; k < pngPathArr2.length(); ++k) {
                                String pngFullPath3 = jsonFileDir + pngPathArr2.getString(k);
                                if (BeautyUtil.isFileExist(pngFullPath3)) continue;
                                LogWrapper.e(TAG, "[sjc]file loss, pngFileName: " + pngFullPath3);
                                return false;
                            }
                        }
                        continue;
                    }
                    if (jsonType.equals("LookUpTableFilter")) {
                        String lutPath = jsonArray.optJSONObject(i).optJSONObject("ext_data").optString("LUTPath");
                        String pngFullPath4 = new StringBuffer(jsonFileDir).append(lutPath).toString();
                        if (BeautyUtil.isFileExist(pngFullPath4)) continue;
                        LogWrapper.e(TAG, "[sjc]file loss, pngFileName: " + pngFullPath4);
                        return false;
                    }
                    if (jsonType.equals("Face3dPlaneAnimationFilter")) {
                        pngPathArr = jsonArray.optJSONObject(i).optJSONObject("ext_data").getJSONArray("pngPathArr");
                        for (int j = 0; j < pngPathArr.length(); ++j) {
                            pngFullPath2 = jsonFileDir + pngPathArr.getString(j);
                            if (BeautyUtil.isFileExist(pngFullPath2)) continue;
                            LogWrapper.e(TAG, "[sjc]file loss, pngFileName: " + pngFullPath2);
                            return false;
                        }
                        continue;
                    }
                    if (jsonType.equals("BlendAnimationFilter")) {
                        pngPathArr = jsonArray.optJSONObject(i).optJSONObject("ext_data").getJSONArray("pngPathArr");
                        for (int j = 0; j < pngPathArr.length(); ++j) {
                            pngFullPath2 = jsonFileDir + pngPathArr.getString(j);
                            if (BeautyUtil.isFileExist(pngFullPath2)) continue;
                            LogWrapper.e(TAG, "[sjc]file loss, pngFileName: " + pngFullPath2);
                            return false;
                        }
                        continue;
                    }
                    if (!jsonType.equals("BlendFilter") || BeautyUtil.isFileExist(pngFullPath = jsonFileDir + (imageFileName = jsonArray.optJSONObject(i).optJSONObject("ext_data").optString("blendImagePath")))) continue;
                    LogWrapper.e(TAG, "[sjc]file loss, pngFileName: " + pngFullPath);
                    return false;
                }
            }
            catch (JSONException e) {
                LogWrapper.e(TAG, "[Exception] e: " + e.toString() + " , jsonFile: " + jsonFile);
                return false;
            }
        }
        return true;
    }

    public static HashMap<String, String> checkEffectConfig(String dir, String jsonFile) {
        HashMap<String, String> effectMap = new HashMap<String, String>();
        String stickEffect = null;
        String stickLutEffect = null;
        if (jsonFile != null) {
            String effectConfigJson = FileUtil.getFileFromSD((String)jsonFile);
            try {
                JSONObject jsonObject = new JSONObject(effectConfigJson);
                JSONArray effectTypeList = jsonObject.getJSONArray("effectTypeList");
                if (effectTypeList.length() == 1) {
                    String name = jsonObject.getJSONArray("effectList").getString(0);
                    stickEffect = dir + "/" + name;
                } else if (effectTypeList.length() == 2) {
                    String name = jsonObject.getJSONArray("effectList").getString(0);
                    stickLutEffect = dir + "/" + name;
                    name = jsonObject.getJSONArray("effectList").getString(1);
                    stickEffect = dir + "/" + name;
                }
                effectMap.put("sticker", stickEffect);
                effectMap.put("sticker_lut", stickLutEffect);
                LogWrapper.i(TAG, "[sjc] stickEffect: " + stickEffect + " ,stickLutEffect: " + stickLutEffect);
            }
            catch (JSONException e) {
                LogWrapper.e(TAG, "[Exception] e: " + e.toString() + " , jsonFile: " + jsonFile);
            }
        }
        return effectMap;
    }
}

