/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.videoeffect.thunderbolt.face;

import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.Observer;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.orangefilter.OrangeFilter;
import com.orangefilter.OrangeFilterApi;
import com.thunder.livesdk.video.IVideoCaptureObserver;
import com.venus.Venus;
import com.yy.mediaframework.CameraInterface;
import com.yy.mediaframework.CameraUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import tv.athena.live.component.videoeffect.thunderbolt.face.AccDirection;
import tv.athena.live.component.videoeffect.thunderbolt.face.FaceDetectionProducer;
import tv.athena.live.component.videoeffect.thunderbolt.face.FacePointInfo;
import tv.athena.live.component.videoeffect.thunderbolt.util.LogWrapper;
import tv.athena.live.vsprotocol.ATHFaceDetectionResult;
import tv.athena.util.common.FileUtils;

public class VenusMobileFaceDetectionWrapper
implements FaceDetectionProducer,
IVideoCaptureObserver {
    private static final String TAG = "VenusMobileFaceDetectionWrapper";
    private int mImageHeight;
    private int mImageWidth;
    private int mScaleWidth;
    private int mScaleHeight;
    private final int mMaxFace = 5;
    private int scaleFactor = 1;
    private byte[] mImageData;
    private byte[] mTmpBuffer;
    private byte[] mScaleBuffer;
    private boolean mIsCreateFaceDetectionHandleSucceeded = false;
    private boolean mIsPaused = false;
    private boolean mCameraChanging = false;
    private static final int MESSAGE_PROCESS_IMAGE = 100;
    private static final int MESSAGE_RESET_FACE = 104;
    private HandlerThread mProcessImageThread;
    private Handler mProcessImageHandler;
    private final Object mVenusFaceHandleLock = new Object();
    private final Object mLastUpdateLock = new Object();
    private FacePointInfo mLastUpdateFacePointInfo;
    private ConcurrentLinkedQueue<FacePointInfo> mFacePointInfoQueue = null;
    private Context mContext;
    private AtomicBoolean mInited = new AtomicBoolean(false);
    private FacePointInfo mFacePoints = new FacePointInfo();
    private int mFaceID = -1;
    private String resDir = Environment.getExternalStorageDirectory().getPath();
    private String[] mFaceModelPath = new String[]{this.resDir + "/venus_face_data/model0.vnmodel", this.resDir + "/venus_face_data/model1.vnmodel", this.resDir + "/venus_face_data/model2.vnmodel", this.resDir + "/venus_face_data/model3.vnmodel", this.resDir + "/venus_face_data/model4.vnmodel", this.resDir + "/venus_face_data/model5.vnmodel", this.resDir + "/venus_face_data/model6.vnmodel"};
    private Venus.VN_FaceFrameDataArr mFaceDetectionFrameData = new Venus.VN_FaceFrameDataArr();
    protected String[] mFaceModelPathOption = null;
    protected AccDirection mAcc;
    protected AtomicBoolean isNeedFaceDetected = new AtomicBoolean(false);
    private FrameData mCurrentFrameData = null;
    private AtomicInteger faceHandleNums = new AtomicInteger(0);
    private MutableLiveData<ATHFaceDetectionResult> mFaceFrameLiveData = new MutableLiveData();
    private int logTimes = 0;

    public void setFaceModelPathOption(String[] str) {
        LogWrapper.i(TAG, "venus setFaceModelPathOption");
        this.mFaceModelPathOption = str;
    }

    public void enableFaceDetected(boolean bNeedFaceDetected) {
        LogWrapper.i(TAG, "setNeedFaceDetected:" + bNeedFaceDetected);
        this.isNeedFaceDetected.set(bNeedFaceDetected);
    }

    public boolean getNeedFaceDetected() {
        return this.isNeedFaceDetected.get();
    }

    public VenusMobileFaceDetectionWrapper(Context context) {
        this.mContext = context.getApplicationContext();
        this.mFacePointInfoQueue = new ConcurrentLinkedQueue();
        this.mAcc = new AccDirection(context);
        for (int i = 0; i < 5; ++i) {
            FacePointInfo pointInfo = new FacePointInfo();
            pointInfo.mFrameData = new OrangeFilter.OF_FrameData();
            this.mFacePointInfoQueue.add(pointInfo);
        }
        this.mInited.set(false);
        LogWrapper.i(TAG, "VenusMobileFaceDetectionWrapper construct");
    }

    public void init() {
        LogWrapper.i(TAG, "Venus init enter");
        this.initVenus();
        this.mAcc.start();
        LogWrapper.i(TAG, "Venus init exit");
    }

    public void deInit() {
        LogWrapper.i(TAG, "[face] Venus deInit enter");
        this.deInitVenus();
        this.mAcc.stop();
        LogWrapper.i(TAG, "[face] Venus deInit exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initVenus() {
        Object object = this.mVenusFaceHandleLock;
        synchronized (object) {
            if (!this.mInited.get()) {
                LogWrapper.i(TAG, "[face] VenusMobileWrapper initSTMobile begin");
                if (this.mFaceModelPathOption != null) {
                    for (String str : this.mFaceModelPathOption) {
                        File f = new File(str);
                        boolean isExist = FileUtils.isFileExists((File)f);
                        long fileSize = f.length();
                        LogWrapper.i(TAG, "mFaceModelPathOption: " + str + " isExist = " + isExist + " fileSize = " + fileSize);
                    }
                    this.mFaceID = Venus.createFaceCpu((String[])this.mFaceModelPathOption, (int)0);
                } else {
                    for (String str : this.mFaceModelPath) {
                        LogWrapper.i(TAG, "mFaceModelPath: " + str);
                    }
                    this.mFaceID = Venus.createFaceCpu((String[])this.mFaceModelPath, (int)0);
                }
                if (this.mFaceID != -1) {
                    // empty if block
                }
                if (this.mFaceID >= 0) {
                    LogWrapper.i(TAG, "Venus createFaceCpu success, faceId:" + this.mFaceID);
                    this.mIsCreateFaceDetectionHandleSucceeded = true;
                }
                this.mProcessImageThread = new HandlerThread("venus handle thread");
                this.mProcessImageThread.start();
                this.mProcessImageHandler = new Handler(this.mProcessImageThread.getLooper()){

                    public void handleMessage(Message msg) {
                        try {
                            if (!VenusMobileFaceDetectionWrapper.this.mIsPaused && VenusMobileFaceDetectionWrapper.this.mIsCreateFaceDetectionHandleSucceeded) {
                                switch (msg.what) {
                                    case 100: {
                                        boolean bYUVData = (Boolean)msg.obj;
                                        if (!bYUVData) break;
                                        VenusMobileFaceDetectionWrapper.this.processCameraData();
                                        break;
                                    }
                                    case 104: {
                                        VenusMobileFaceDetectionWrapper.this.resetFacePointInfo();
                                        break;
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            LogWrapper.e(VenusMobileFaceDetectionWrapper.TAG, "handleMessage  " + msg.what + " :");
                        }
                    }
                };
            }
            this.mInited.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deInitVenus() {
        Object object = this.mVenusFaceHandleLock;
        synchronized (object) {
            if (this.mInited.get()) {
                LogWrapper.i(TAG, "[face] VenusMobileWrapper deInitVenus begin");
                Venus.destroyFaceCpu((int)this.mFaceID);
                this.mFaceID = -1;
                if (this.mProcessImageHandler != null) {
                    this.mProcessImageHandler.removeCallbacksAndMessages(null);
                    if (Build.VERSION.SDK_INT >= 18) {
                        this.mProcessImageThread.quitSafely();
                    } else {
                        this.mProcessImageThread.quit();
                    }
                    this.mProcessImageHandler = null;
                    this.mProcessImageThread = null;
                }
                LogWrapper.i(TAG, "[face] VenusMobileWrapper deInitVenus end");
            }
            this.mImageData = null;
            this.mTmpBuffer = null;
            this.mScaleBuffer = null;
            this.mImageWidth = 0;
            this.mImageHeight = 0;
            this.mInited.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCaptureVideoFrame(int width, int height, byte[] data, int length, int imageFormat) {
        this.mCurrentFrameData = new FrameData(height, width, data);
        if (data == null) {
            LogWrapper.e(TAG, "onCaptureVideoFrame error, data: " + data);
            return;
        }
        Object object = this.mVenusFaceHandleLock;
        synchronized (object) {
            if (this.mImageWidth == 0 || this.mImageHeight == 0 || this.hasSizeChange(this.mImageWidth, this.mImageHeight, width, height)) {
                this.updatePreviewCallbackBufferInfo(width, height);
                LogWrapper.w(TAG, "onCaptureVideoFrame  should updatePreviewCallbackBufferInfo  !!");
                return;
            }
            try {
                System.arraycopy(data, 0, this.mImageData, 0, data.length);
            }
            catch (Exception e) {
                LogWrapper.e(TAG, "===> onCaptureVideoFrame error " + e.getMessage());
            }
        }
        if (Build.VERSION.SDK_INT < 14) {
            return;
        }
        ++this.logTimes;
        if (this.logTimes > 500) {
            this.logTimes = 0;
            LogWrapper.i(TAG, "===> onCaptureVideoFrame, mInited=" + this.mInited.get());
        }
        object = this.mVenusFaceHandleLock;
        synchronized (object) {
            if (this.mProcessImageHandler != null && this.mInited.get()) {
                this.mProcessImageHandler.removeMessages(100);
                Message msg = Message.obtain();
                msg.what = 100;
                msg.obj = true;
                this.mProcessImageHandler.sendMessage(msg);
            }
        }
    }

    private boolean hasSizeChange(int preWidth, int preHeight, int currentWidth, int currentHeight) {
        return preWidth * preHeight != currentWidth * currentHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCameraData() {
        int dir;
        Object object = this.mVenusFaceHandleLock;
        synchronized (object) {
            if (this.mInited.get()) {
                if (this.mTmpBuffer == null || this.mCameraChanging || this.mTmpBuffer.length != this.mImageHeight * this.mImageWidth * 3 / 2) {
                    this.mTmpBuffer = new byte[this.mImageWidth * this.mImageHeight * 3 / 2];
                }
                if (this.mTmpBuffer == null || this.mImageData == null || this.mTmpBuffer.length != this.mImageData.length) {
                    LogWrapper.w(TAG, "mTmpBuffer or mImageData null");
                    return;
                }
            } else {
                return;
            }
            System.arraycopy(this.mImageData, 0, this.mTmpBuffer, 0, this.mImageData.length);
        }
        boolean frontCamera = CameraInterface.getInstance().getCameraFacing() == CameraUtils.CameraFacing.FacingFront;
        VenusMobileFaceDetectionWrapper venusMobileFaceDetectionWrapper = this;
        int orgDir = dir = venusMobileFaceDetectionWrapper.mAcc.getDirection();
        if (!frontCamera && dir == 0) {
            dir = 2;
        } else if (!frontCamera && dir == 2) {
            dir = 0;
        }
        if (CameraInterface.getInstance().getCameraInfo().orientation == 270 && (dir & 1) == 1 || CameraInterface.getInstance().getCameraInfo().orientation == 90 && (dir & 1) == 0) {
            dir ^= 2;
        }
        boolean portrait = CameraInterface.getInstance().getDisplayRotation() == 0;
        Venus.VN_FaceFrameDataArr faceDetectionFrameData = new Venus.VN_FaceFrameDataArr();
        Object object2 = this.mVenusFaceHandleLock;
        synchronized (object2) {
            if (!this.mIsCreateFaceDetectionHandleSucceeded || !this.mInited.get()) {
                LogWrapper.w(TAG, "processCameraData while mSTMobileHumanActionNative is null, just return");
                return;
            }
            if (this.scaleFactor != 1) {
                OrangeFilterApi.nv12DownSample((byte[])this.mTmpBuffer, (byte[])this.mScaleBuffer, (int)this.mImageHeight, (int)this.mImageWidth, (int)this.mScaleHeight, (int)this.mScaleWidth);
            }
            if (this.scaleFactor != 1) {
                Venus.applyFaceCpu2((int)this.mFaceID, (int)7, (int)dir, (int)this.mImageHeight, (int)this.mImageWidth, (byte[])this.mScaleBuffer, (Venus.VN_FaceFrameDataArr)faceDetectionFrameData);
            } else {
                Venus.applyFaceCpu2((int)this.mFaceID, (int)7, (int)dir, (int)this.mImageHeight, (int)this.mImageWidth, (byte[])this.mTmpBuffer, (Venus.VN_FaceFrameDataArr)faceDetectionFrameData);
            }
            if (portrait) {
                Venus.processFaceResult((Venus.VN_FaceFrameDataArr)faceDetectionFrameData, (boolean)frontCamera, (int)orgDir);
            } else if (orgDir == 3) {
                Venus.processFaceResult((Venus.VN_FaceFrameDataArr)faceDetectionFrameData, (boolean)frontCamera, (int)0);
            } else {
                Venus.processFaceResult((Venus.VN_FaceFrameDataArr)faceDetectionFrameData, (boolean)frontCamera, (int)(orgDir + 1));
            }
        }
        if (this.mCameraChanging || this.mIsPaused) {
            return;
        }
        if (faceDetectionFrameData != null) {
            this.addCurrentFaceDetectionFrameData(faceDetectionFrameData);
            this.mFaceDetectionFrameData = faceDetectionFrameData;
        } else {
            this.mFaceDetectionFrameData = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCurrentFaceDetectionFrameData(Venus.VN_FaceFrameDataArr faceDetectionFrameData) {
        try {
            if (this.mCameraChanging || faceDetectionFrameData == null) {
                return;
            }
            FacePointInfo pointInfo = this.mFacePointInfoQueue.poll();
            if (pointInfo == null) {
                LogWrapper.i(TAG, "[face] not point info in queue!!!");
                return;
            }
            if (faceDetectionFrameData.faceCount > 0) {
                if (faceDetectionFrameData.faceCount != pointInfo.mFaceCount || pointInfo.mFrameData == null) {
                    pointInfo.mFrameData = new OrangeFilter.OF_FrameData();
                }
                if (faceDetectionFrameData.faceCount != pointInfo.mFaceCount || pointInfo.mFacePoints == null) {
                    pointInfo.mFacePoints = new float[faceDetectionFrameData.faceCount][212];
                }
                if (faceDetectionFrameData.faceCount != pointInfo.mFaceCount || pointInfo.mFrameData.faceFrameDataArr == null) {
                    pointInfo.mFrameData.faceFrameDataArr = new OrangeFilter.OF_FaceFrameData[faceDetectionFrameData.faceCount];
                    for (int i = 0; i < faceDetectionFrameData.faceCount; ++i) {
                        pointInfo.mFrameData.faceFrameDataArr[i] = new OrangeFilter.OF_FaceFrameData();
                    }
                }
                pointInfo.mFaceCount = faceDetectionFrameData.faceCount;
                float[][] mTempFacePoints = pointInfo.mFacePoints;
                for (int i = 0; i < faceDetectionFrameData.faceCount; ++i) {
                    int facePoints = faceDetectionFrameData.faceItemArr[i].facePoints.length / 2;
                    float[] points = faceDetectionFrameData.faceItemArr[i].facePoints;
                    for (int j = 0; j < facePoints; ++j) {
                        mTempFacePoints[i][2 * j] = points[2 * j];
                        mTempFacePoints[i][2 * j + 1] = points[2 * j + 1];
                    }
                    pointInfo.mFrameData.faceFrameDataArr[i].facePoints = pointInfo.mFacePoints[i];
                }
            } else {
                pointInfo.mFaceCount = 0;
                if (pointInfo.mFrameData != null) {
                    pointInfo.mFrameData.faceFrameDataArr = null;
                }
            }
            if (this.mFacePoints != null) {
                if (pointInfo.mFaceCount > 0) {
                    float faceScore = 0.0f;
                    if (faceDetectionFrameData.faceItemArr != null && faceDetectionFrameData.faceItemArr[0] != null) {
                        faceScore = faceDetectionFrameData.faceItemArr[0].scores;
                    }
                    this.mFacePoints.updateFacePoints(pointInfo.mFaceCount, faceScore, new float[1][212]);
                    System.arraycopy(pointInfo.mFacePoints[0], 0, this.mFacePoints.mFacePoints[0], 0, 212);
                } else {
                    this.mFacePoints.updateFacePoints(0, 0.0f, null);
                }
            }
            FacePointInfo origPoint = null;
            Object object = this.mLastUpdateLock;
            synchronized (object) {
                origPoint = this.mLastUpdateFacePointInfo;
                this.mLastUpdateFacePointInfo = pointInfo;
            }
            if (origPoint != null) {
                this.mFacePointInfoQueue.add(origPoint);
            }
        }
        catch (Exception e) {
            LogWrapper.e(TAG, "[face] exception:", e);
        }
    }

    private void handleFaceFrameData(Venus.VN_FaceFrameDataArr faceDetectionFrameData) {
        try {
            if (this.mCameraChanging || faceDetectionFrameData == null) {
                return;
            }
            ATHFaceDetectionResult result = new ATHFaceDetectionResult();
            boolean hasIdentify = false;
            if (faceDetectionFrameData.faceCount > 0 && faceDetectionFrameData.faceItemArr != null) {
                ArrayList<ATHFaceDetectionResult.FaceData> faceDatas = new ArrayList<ATHFaceDetectionResult.FaceData>();
                for (Venus.VN_FaceFrameData frameBean : faceDetectionFrameData.faceItemArr) {
                    float[] faceRect = frameBean.faceRect;
                    if (faceRect != null && (faceRect[0] < 0.0f || faceRect[1] < 0.0f || faceRect[2] > 1.0f || faceRect[3] > 1.0f)) continue;
                    ATHFaceDetectionResult.FaceDetection faceDetection = ATHFaceDetectionResult.FaceDetection.NONE;
                    ATHFaceDetectionResult.FaceData faceData = new ATHFaceDetectionResult.FaceData(faceDetection, frameBean.faceRect);
                    faceDatas.add(faceData);
                }
                result.setFaceDatas(faceDatas);
                if (faceDatas.size() == 0) {
                    result.setFaceType(ATHFaceDetectionResult.FaceType.NONE);
                } else if (faceDatas.size() == 1) {
                    result.setFaceType(ATHFaceDetectionResult.FaceType.SINGLE);
                } else {
                    result.setFaceType(ATHFaceDetectionResult.FaceType.MULTI);
                }
            } else {
                result.setFaceType(ATHFaceDetectionResult.FaceType.NONE);
                result.setFaceDatas(null);
            }
            if (this.faceHandleNums.incrementAndGet() == 10 || hasIdentify) {
                this.faceHandleNums.set(0);
                result.setVideoFrameByteArray(this.yuv2ByteArray());
                this.mFaceFrameLiveData.postValue((Object)result);
            }
        }
        catch (Exception e) {
            LogWrapper.e(TAG, "[face] handleFaceFrameData error:", e);
        }
    }

    private byte[] yuv2ByteArray() {
        if (this.mCurrentFrameData == null || this.mCurrentFrameData.data == null || this.mCurrentFrameData.width <= 0 || this.mCurrentFrameData.height <= 0) {
            return null;
        }
        YuvImage image = new YuvImage(this.mCurrentFrameData.data, 17, this.mCurrentFrameData.width, this.mCurrentFrameData.height, null);
        if (image != null) {
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                image.compressToJpeg(new Rect(0, 0, this.mCurrentFrameData.width, this.mCurrentFrameData.height), 80, (OutputStream)stream);
                byte[] bytes = stream.toByteArray();
                Bitmap tempBitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
                Matrix matrix = new Matrix();
                matrix.reset();
                matrix.setRotate(-90.0f);
                Bitmap finalBitmap = Bitmap.createBitmap((Bitmap)tempBitmap, (int)0, (int)0, (int)tempBitmap.getWidth(), (int)tempBitmap.getHeight(), (Matrix)matrix, (boolean)true);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                finalBitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
                stream.close();
                baos.close();
                tempBitmap.recycle();
                finalBitmap.recycle();
                return baos.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFacePointInfo(FacePointInfo facePoint) {
        FacePointInfo tmpPointInfo = null;
        Object object = this.mLastUpdateLock;
        synchronized (object) {
            if (this.mLastUpdateFacePointInfo == null) {
                this.mLastUpdateFacePointInfo = facePoint;
            } else {
                tmpPointInfo = facePoint;
            }
        }
        if (tmpPointInfo != null) {
            this.mFacePointInfoQueue.add(tmpPointInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFacePointInfo() {
        Object object = this.mLastUpdateLock;
        synchronized (object) {
            this.mImageData = null;
            FacePointInfo tmpPointInfo = this.mLastUpdateFacePointInfo = null;
            if (tmpPointInfo != null) {
                this.mFacePointInfoQueue.add(tmpPointInfo);
            }
            this.mProcessImageHandler.removeMessages(100);
            Venus.destroyFaceCpu((int)this.mFaceID);
            this.mFaceID = this.mFaceModelPathOption != null ? Venus.createFaceCpu((String[])this.mFaceModelPathOption, (int)0) : Venus.createFaceCpu((String[])this.mFaceModelPath, (int)0);
            this.mIsCreateFaceDetectionHandleSucceeded = this.mFaceID >= 0;
        }
    }

    public boolean isFaceDetectionInitiated() {
        return this.mInited.get();
    }

    public void observeFaceFrameData(Observer<ATHFaceDetectionResult> observer) {
        this.mFaceFrameLiveData.observeForever(observer);
    }

    public void removeObserveFaceFrameData(Observer<ATHFaceDetectionResult> observer) {
        this.mFaceFrameLiveData.removeObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePreviewCallbackBufferInfo(int previewWidth, int previewHeight) {
        LogWrapper.i(TAG, "updatePreviewCallbackBufferInfo,previewWidth: " + previewWidth + " ,previewHeight: " + previewHeight);
        if (previewWidth < previewHeight) {
            this.mImageWidth = previewWidth;
            this.mImageHeight = previewHeight;
        } else {
            this.mImageWidth = previewHeight;
            this.mImageHeight = previewWidth;
        }
        this.mScaleWidth = this.mImageWidth / this.scaleFactor;
        this.mScaleHeight = this.mImageHeight / this.scaleFactor;
        Object object = this.mVenusFaceHandleLock;
        synchronized (object) {
            this.mImageData = new byte[this.mImageWidth * this.mImageHeight * 3 / 2];
            this.mTmpBuffer = new byte[this.mImageWidth * this.mImageHeight * 3 / 2];
            this.mScaleBuffer = new byte[this.mScaleWidth * this.mScaleHeight * 3 / 2];
        }
    }

    @Override
    @NotNull
    public FacePointInfo getFacePointInfo() {
        FacePointInfo facePointInfo = this.getCurrentFacePointInfo();
        this.releaseFacePointInfo(facePointInfo);
        return facePointInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FacePointInfo getCurrentFacePointInfo() {
        if (!this.mInited.get() && this.mLastUpdateFacePointInfo != null) {
            this.mLastUpdateFacePointInfo.mFaceCount = 0;
            this.mLastUpdateFacePointInfo.mFacePoints = null;
        }
        FacePointInfo pointInfo = null;
        Object object = this.mLastUpdateLock;
        synchronized (object) {
            pointInfo = this.mLastUpdateFacePointInfo;
            this.mLastUpdateFacePointInfo = null;
        }
        return pointInfo;
    }

    class FrameData {
        int width;
        int height;
        byte[] data;

        public FrameData(int width, int height, byte[] data) {
            this.width = width;
            this.height = height;
            this.data = data;
        }
    }
}

