/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.videoeffect.thunderbolt.beauty;

import android.opengl.GLES20;
import android.os.Handler;
import android.os.Looper;
import com.orangefilter.OrangeFilter;
import com.yy.mediaframework.gles.Drawable2d;
import com.yy.mediaframework.gles.GlUtil;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.mediaframework.gpuimage.custom.PhonePerformanceLevel;
import com.yy.mediaframework.gpuimage.util.GLShaderProgram;
import com.yy.mediaframework.gpuimage.util.GLTexture;
import com.yy.mediaframework.utils.FileUtil;
import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import tv.athena.live.component.videoeffect.PerformanceLevel;
import tv.athena.live.component.videoeffect.thunderbolt.beauty.ARGiftRender;
import tv.athena.live.component.videoeffect.thunderbolt.beauty.ARJoyPKRender;
import tv.athena.live.component.videoeffect.thunderbolt.beauty.Beauty6EffectRender;
import tv.athena.live.component.videoeffect.thunderbolt.beauty.IBeautyRenderProcessor;
import tv.athena.live.component.videoeffect.thunderbolt.beauty.IOrangeFilterRenderDelegate;
import tv.athena.live.component.videoeffect.thunderbolt.beauty.IOrangeFilterStatus;
import tv.athena.live.component.videoeffect.thunderbolt.beauty.IPreProcessListener;
import tv.athena.live.component.videoeffect.thunderbolt.face.FaceDetectionProducer;
import tv.athena.live.component.videoeffect.thunderbolt.face.FacePointInfo;
import tv.athena.live.component.videoeffect.thunderbolt.util.LogWrapper;

public class GPUImageBeautyOrangeFilter
implements IBeautyRenderProcessor,
IGPUProcess {
    public static final String TAG = "GPUImageBeautyOrangeFilter";
    public static final String noeffect_vs = "attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTexCoord;\n\nvoid main()\n{\n    gl_Position = aPosition;\n    vTexCoord = aTextureCoord.xy;\n}";
    public static String noeffect_fs = "precision mediump float;\nvarying vec2 vTexCoord;\nuniform sampler2D uTexture0;\n\nvoid main()\n{\n    vec4 color = texture2D(uTexture0, vTexCoord);\n    gl_FragColor = color; //vec4(color.y, color.y, color.y, 1.0);\n}";
    public static final String passthrouth_vs = "attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTexCoord;\n\nvoid main()\n{\n    gl_Position = aPosition;\n    vTexCoord = aTextureCoord.xy;\n}";
    public static final String passthrouth_fs = "precision mediump float;\nvarying vec2 vTexCoord;\nuniform sampler2D uTexture0;\n\nvoid main()\n{\n    vec4 color = texture2D(uTexture0, vTexCoord);\n    gl_FragColor = color; //vec4(color.y, color.y, color.y, 1.0);\n}";
    public static final String mOESFragmentShader = "#extension GL_OES_EGL_image_external : require\n" + noeffect_fs.replace("uniform sampler2D uTexture0;", "uniform samplerExternalOES uTexture0;");
    public static final float[] CUBE = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    private final FloatBuffer mVertexBuffer = ByteBuffer.allocateDirect(CUBE.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private IPreProcessListener mListener = null;
    private boolean mInited = false;
    private int mNoFaceCount;
    private ARGiftRender mARGiftRender;
    private ARJoyPKRender mARJoyPKRender;
    private GLShaderProgram mNoEffectShader = null;
    private GLShaderProgram mPassthroughShader = null;
    private GLTexture mInputTexture = null;
    private GLTexture mOutputTexture = null;
    private IntBuffer mFramebuffer = null;
    private IntBuffer mOldFramebuffer = null;
    private Drawable2d mRectDrawable = new Drawable2d(Drawable2d.Prefab.FULL_RECTANGLE);
    private int mTextureTarget;
    private int mOutputWidth = 0;
    private int mOutputHeight = 0;
    private boolean mHasFace = false;
    private boolean mIsUseThinFace = false;
    private boolean mIsUseBeauty = false;
    private boolean mIsUseNewBeauty5 = false;
    private boolean mIsUseSticker = false;
    private boolean mIsDelegateNeedFace = false;
    private boolean mIsUseFaceLift = false;
    private boolean mIsUseWhiteNess = false;
    private boolean mIsUseLookupTable = false;
    private boolean mIsUseDermabrasion = false;
    private boolean mIsUseFaceLiftOpt = false;
    private String mCurrentWitnessEffectPath = null;
    private String mLookupEffectPath = null;
    private String mWitnessEffectPath = null;
    private String mStickerLutEffect = null;
    private String mStickerEffect = null;
    private PhonePerformanceLevel mCurrentPhoneLevel = PhonePerformanceLevel.Level_0;
    private PhonePerformanceLevel mPhoneLevel = PhonePerformanceLevel.Level_0;
    private int mOfContextId = -1;
    private int mStickerEffectFilter = 0;
    private int mStickerLutEffectFilter = 0;
    private int mWitnessFilter = 0;
    private int mFilterLookUpTable = 0;
    private int mFilterBasicThinFace = 0;
    private int mFilterBeauty5 = 0;
    private int mBeauty5EffectHandle = 0;
    private int mBeauty5EffectId = 0;
    private int mFilterFaceLifting = 0;
    private int mFilterFaceLiftOpt = 0;
    private int mAvatar = 0;
    private String mSickerEffectPathFile = null;
    private String mBeauty5EffectPathFile = null;
    private Map<Integer, Float> mFaceLiftValue = null;
    private Map<Integer, Float> mFaceLiftValueOpt = null;
    private float mBeautyParam = 0.0f;
    private float mThinFaceParam = 0.0f;
    private float mLookupTableParam = 0.0f;
    private OrangeFilter.OF_Paramf mOFParamf = new OrangeFilter.OF_Paramf();
    private OrangeFilter.OF_EffectInfo mEffectInfo = new OrangeFilter.OF_EffectInfo();
    private OrangeFilter.OF_FrameData mNoFaceFrameData = new OrangeFilter.OF_FrameData();
    private ArrayList<IOrangeFilterRenderDelegate> mDelegateList = new ArrayList();
    private Handler mHandler = null;
    private boolean isCropOF = false;
    private FaceDetectionProducer mFaceDetectionProducer;
    private AtomicInteger mRenderLogAtomicInteger = new AtomicInteger();
    private StringBuilder sb = new StringBuilder();
    private Beauty6EffectRender mBeauty6EffectRender = new Beauty6EffectRender();
    private IOrangeFilterStatus mOrangeFilterStatus;
    FloatBuffer mTextureBuffer = ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asFloatBuffer();

    public GPUImageBeautyOrangeFilter() {
        LogWrapper.i(TAG, "GPUImageBeautyOrangeFilter construct");
    }

    @Override
    public void setListener(IPreProcessListener listener) {
        this.mListener = listener;
    }

    public void setOrangeFilterStatus(IOrangeFilterStatus orangeFilterStatus) {
        this.mOrangeFilterStatus = orangeFilterStatus;
    }

    public void setIsCropOF(boolean isCropOF) {
        this.isCropOF = isCropOF;
    }

    public void setPhonePerformanceLevel(PerformanceLevel level) {
        switch (level) {
            case Level_2: {
                this.mPhoneLevel = PhonePerformanceLevel.Level_2;
                break;
            }
            case Level_1: {
                this.mPhoneLevel = PhonePerformanceLevel.Level_1;
                break;
            }
            default: {
                this.mPhoneLevel = PhonePerformanceLevel.Level_0;
            }
        }
    }

    public void setFaceDetectionProducer(FaceDetectionProducer faceDetectionProducer) {
        this.mFaceDetectionProducer = faceDetectionProducer;
    }

    public void onInit(int textureTarget, int outputWidth, int outputHeight) {
        LogWrapper.i(TAG, "onInit OF");
        this.createOF();
        LogWrapper.i(TAG, "mOfContextId=" + this.mOfContextId);
        this.mTextureTarget = textureTarget;
        this.mOutputWidth = outputWidth;
        this.mOutputHeight = outputHeight;
        if (textureTarget == 36197) {
            noeffect_fs = mOESFragmentShader;
        }
        this.mVertexBuffer.put(CUBE).position(0);
        this.mFramebuffer = IntBuffer.allocate(1);
        GLES20.glGenFramebuffers((int)1, (IntBuffer)this.mFramebuffer);
        this.mNoEffectShader = new GLShaderProgram();
        this.mNoEffectShader.setProgram("attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTexCoord;\n\nvoid main()\n{\n    gl_Position = aPosition;\n    vTexCoord = aTextureCoord.xy;\n}", noeffect_fs);
        this.mPassthroughShader = new GLShaderProgram();
        this.mPassthroughShader.setProgram("attribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTexCoord;\n\nvoid main()\n{\n    gl_Position = aPosition;\n    vTexCoord = aTextureCoord.xy;\n}", passthrouth_fs);
        this.mOldFramebuffer = IntBuffer.allocate(1);
        this.mHandler = new Handler(Looper.myLooper());
        this.mInited = true;
        if (this.mLookupEffectPath != null) {
            this.setLookupTableEffect(this.mLookupEffectPath);
        }
        if (this.mBeauty5EffectPathFile != null) {
            this.setBeauty5EffectFile(this.mBeauty5EffectPathFile);
            this.mBeauty5EffectPathFile = null;
        }
        if (this.mSickerEffectPathFile != null) {
            this.setStickerDirPath(this.mSickerEffectPathFile);
            this.mSickerEffectPathFile = null;
        }
        if (this.mFaceLiftValue != null) {
            this.setFaceLiftValueInner(this.mFaceLiftValue);
            this.mFaceLiftValue = null;
        }
        if (this.mFaceLiftValueOpt != null) {
            this.setFaceLiftValueOptInner(this.mFaceLiftValueOpt);
            this.mFaceLiftValueOpt = null;
        }
        this.setBeautyEffectParam(this.mBeautyParam);
        this.setThinFaceParam(this.mThinFaceParam);
        this.setLookupTableParam(this.mLookupTableParam);
        this.updateOrangeFilterByPhoneLevel();
        if (this.mOrangeFilterStatus != null) {
            this.mOrangeFilterStatus.finishInit();
        }
    }

    public void onDestroy() {
        LogWrapper.i(TAG, "onDestroy OF Render");
        this.mInited = false;
        if (this.mOrangeFilterStatus != null) {
            this.mOrangeFilterStatus.destroy();
        }
        if (this.mFramebuffer != null) {
            GLES20.glDeleteFramebuffers((int)1, (IntBuffer)this.mFramebuffer);
        }
        if (this.mInputTexture != null) {
            this.mInputTexture.destory();
            this.mOutputTexture.destory();
        }
        if (this.mNoEffectShader != null) {
            this.mNoEffectShader.destory();
        }
        if (this.mPassthroughShader != null) {
            this.mPassthroughShader.destory();
        }
        this.destroyOF();
    }

    private int createOF() {
        this.mOfContextId = OrangeFilter.createContext();
        OrangeFilter.setConfigBool((int)this.mOfContextId, (int)3, (boolean)false);
        this.mARGiftRender = new ARGiftRender(this.mOfContextId);
        this.mARJoyPKRender = new ARJoyPKRender(this.mOfContextId);
        this.mWitnessFilter = OrangeFilter.createFilter((int)this.mOfContextId, (String)"LookUpTableFilter");
        this.mFilterLookUpTable = OrangeFilter.createFilter((int)this.mOfContextId, (String)"LookUpTableFilter");
        this.mFilterBasicThinFace = OrangeFilter.createFilter((int)this.mOfContextId, (String)"BasicThinFaceFilter");
        this.mFilterBeauty5 = OrangeFilter.createFilter((int)this.mOfContextId, (String)"BeautyFilter5");
        this.mBeauty6EffectRender.setOfContextId(this.mOfContextId);
        LogWrapper.i(TAG, "createOF " + this.isCropOF);
        if (!this.isCropOF) {
            this.mFilterFaceLifting = OrangeFilter.createFilter((int)this.mOfContextId, (String)"FaceLiftingFilter");
            this.mFilterFaceLiftOpt = OrangeFilter.createFilter((int)this.mOfContextId, (String)"FaceLiftingOptFilter");
            this.mAvatar = OrangeFilter.createAvatar((int)this.mOfContextId, (String)"", (int)1);
        }
        return 0;
    }

    private void destroyOF() {
        if (this.mStickerEffectFilter != 0) {
            OrangeFilter.destroyEffect((int)this.mOfContextId, (int)this.mStickerEffectFilter);
            this.mStickerEffectFilter = 0;
        }
        if (this.mStickerLutEffectFilter != 0) {
            OrangeFilter.destroyEffect((int)this.mOfContextId, (int)this.mStickerLutEffectFilter);
            this.mStickerLutEffectFilter = 0;
        }
        if (this.mFilterLookUpTable != 0) {
            OrangeFilter.destroyFilter((int)this.mOfContextId, (int)this.mFilterLookUpTable);
            this.mFilterLookUpTable = 0;
        }
        if (this.mWitnessFilter != 0) {
            OrangeFilter.destroyFilter((int)this.mOfContextId, (int)this.mWitnessFilter);
            this.mWitnessFilter = 0;
        }
        if (this.mFilterBasicThinFace != 0) {
            OrangeFilter.destroyFilter((int)this.mOfContextId, (int)this.mFilterBasicThinFace);
            this.mFilterBasicThinFace = 0;
        }
        if (this.mFilterBeauty5 != 0) {
            OrangeFilter.destroyFilter((int)this.mOfContextId, (int)this.mFilterBeauty5);
            this.mFilterBeauty5 = 0;
        }
        if (this.mBeauty5EffectHandle != 0) {
            OrangeFilter.destroyEffect((int)this.mOfContextId, (int)this.mBeauty5EffectHandle);
            this.mBeauty5EffectHandle = 0;
            this.mBeauty5EffectId = 0;
        }
        if (this.mFilterFaceLifting != 0) {
            OrangeFilter.destroyFilter((int)this.mOfContextId, (int)this.mFilterFaceLifting);
            this.mFilterFaceLifting = 0;
        }
        if (this.mFilterFaceLiftOpt != 0) {
            OrangeFilter.destroyFilter((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt);
            this.mFilterFaceLiftOpt = 0;
        }
        if (this.mAvatar != 0) {
            OrangeFilter.destroyAvatar((int)this.mOfContextId, (int)this.mAvatar);
            this.mAvatar = 0;
        }
        if (this.mARGiftRender != null) {
            this.mARGiftRender.destroy();
        }
        if (this.mARJoyPKRender != null) {
            this.mARJoyPKRender.destroy();
        }
        if (this.mBeauty6EffectRender != null) {
            this.mBeauty6EffectRender.destroy();
        }
        if (this.mDelegateList.size() > 0) {
            LogWrapper.i(TAG, "[Beauty  ]onDestroy mDelegateList.size(): " + this.mDelegateList.size());
            Iterator<IOrangeFilterRenderDelegate> iterator = this.mDelegateList.iterator();
            while (iterator.hasNext()) {
                IOrangeFilterRenderDelegate delegate = iterator.next();
                delegate.tearDown();
                iterator.remove();
            }
        }
        if (this.mOfContextId != -1) {
            OrangeFilter.destroyContext((int)this.mOfContextId);
        }
    }

    private void xyTransform(float[] dstXY, int dstOffset, float[] srcXY, int srcOffset, float[] tr) {
        dstXY[dstOffset] = tr[0] * srcXY[srcOffset] + tr[4] * srcXY[srcOffset + 1] + tr[12];
        dstXY[dstOffset + 1] = tr[1] * srcXY[srcOffset] + tr[5] * srcXY[srcOffset + 1] + tr[13];
    }

    private FloatBuffer positionTransform(FloatBuffer src, float[] transform) {
        int len = 8;
        float[] res = new float[len];
        float[] tmp = new float[len];
        src.get(tmp);
        src.position(0);
        for (int i = 0; i < res.length; i += 2) {
            this.xyTransform(res, i, tmp, i, transform);
        }
        this.mTextureBuffer.put(res).position(0);
        return this.mTextureBuffer;
    }

    private void drawQuad(GLShaderProgram shader, FloatBuffer cubeBuffer, FloatBuffer textureBuffer) {
        cubeBuffer.position(0);
        shader.setVertexAttribPointer("aPosition", 2, 5126, false, 0, (Buffer)cubeBuffer);
        textureBuffer.position(0);
        shader.setVertexAttribPointer("aTextureCoord", 2, 5126, false, 0, (Buffer)textureBuffer);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        shader.disableVertexAttribPointer("aPosition");
        shader.disableVertexAttribPointer("aTextureCoord");
    }

    public void onDraw(int textureId, FloatBuffer textureBuffer) {
        this.onDraw(textureId, this.mVertexBuffer, textureBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDraw(int textureId, FloatBuffer cubeBuffer, FloatBuffer textureBuffer) {
        if (!this.mInited) {
            LogWrapper.e(TAG, "onDraw not ready");
            return;
        }
        if (this.mInputTexture == null || this.mOutputTexture == null) {
            this.mInputTexture = new GLTexture(3553);
            this.mOutputTexture = new GLTexture(3553);
        }
        if (this.mInputTexture.getWidth() != this.mOutputWidth || this.mInputTexture.getHeight() != this.mOutputHeight) {
            this.mInputTexture.create(this.mOutputWidth, this.mOutputHeight, 6408);
            this.mOutputTexture.create(this.mOutputWidth, this.mOutputHeight, 6408);
            LogWrapper.i(TAG, "[Beauty  ][sjc] mOutputWidth: " + this.mOutputWidth + " ,mOutputHeight: " + this.mOutputHeight);
        }
        if (this.mCurrentPhoneLevel != this.mPhoneLevel) {
            this.mCurrentPhoneLevel = this.mPhoneLevel;
            this.updateOrangeFilterByPhoneLevel();
        }
        boolean printDrawingInfo = false;
        if (this.mRenderLogAtomicInteger.incrementAndGet() > 300) {
            this.mRenderLogAtomicInteger.set(0);
            printDrawingInfo = true;
        }
        if (!this.isNeedOrangeFilter()) {
            if (this.mTextureTarget == 36197) {
                this.mNoEffectShader.useProgram();
                this.mNoEffectShader.setUniformTexture("uTexture0", 0, textureId, this.mTextureTarget);
                this.drawQuad(this.mNoEffectShader, cubeBuffer, textureBuffer);
                GLES20.glBindTexture((int)this.mTextureTarget, (int)0);
            }
            if (printDrawingInfo) {
                LogWrapper.i(TAG, "Current not need OrangeFilter");
            }
            return;
        }
        if (printDrawingInfo) {
            this.sb.delete(0, this.sb.length());
            this.sb.append("\n**********************\n").append("hasFaceProducer=").append(this.mFaceDetectionProducer != null).append("\n").append("hasFace=").append(this.mHasFace).append("\n").append("mIsUseSticker=" + this.mIsUseSticker + " path=" + this.mStickerEffect).append("\n").append("mIsUseLookupTable=" + this.mIsUseLookupTable + " path=" + this.mLookupEffectPath).append("\n").append("mIsUseBeauty=" + this.mIsUseBeauty).append("\n").append("mIsUseThinFace=" + this.mIsUseThinFace).append("\n").append("mIsUseFaceLift=" + this.mIsUseFaceLift).append("\n").append("mIsUseFaceLiftOpt=" + this.mIsUseFaceLiftOpt);
            LogWrapper.i(TAG, this.sb.toString());
        }
        GLES20.glGetIntegerv((int)36006, (IntBuffer)this.mOldFramebuffer);
        this.mInputTexture.bindFBO(this.mFramebuffer.get(0));
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16384);
        this.mNoEffectShader.useProgram();
        this.mNoEffectShader.setUniformTexture("uTexture0", 0, textureId, this.mTextureTarget);
        this.drawQuad(this.mNoEffectShader, cubeBuffer, textureBuffer);
        FacePointInfo facePointInfo = null;
        OrangeFilter.OF_FrameData ofFrameData = null;
        GPUImageBeautyOrangeFilter gPUImageBeautyOrangeFilter = this;
        synchronized (gPUImageBeautyOrangeFilter) {
            if (this.mFaceDetectionProducer != null) {
                facePointInfo = this.mFaceDetectionProducer.getFacePointInfo();
            }
            if (facePointInfo != null && facePointInfo.mFaceCount > 0) {
                this.mHasFace = true;
                ofFrameData = facePointInfo.mFrameData;
                OrangeFilter.prepareFrameData((int)this.mOfContextId, (int)this.mOutputWidth, (int)this.mOutputHeight, (OrangeFilter.OF_FrameData)ofFrameData);
            } else {
                this.mHasFace = false;
                OrangeFilter.prepareFrameData((int)this.mOfContextId, (int)this.mOutputWidth, (int)this.mOutputHeight, (OrangeFilter.OF_FrameData)this.mNoFaceFrameData);
            }
        }
        if (this.mIsUseSticker && facePointInfo != null) {
            this.drawSticker(ofFrameData);
        }
        if (!this.mIsUseFaceLiftOpt && this.mIsUseFaceLift && facePointInfo != null && this.mPhoneLevel == PhonePerformanceLevel.Level_0) {
            this.assembleMultiFilter();
            this.drawFaceLift(ofFrameData);
        } else if (!this.mIsUseFaceLiftOpt && this.mIsUseThinFace && facePointInfo != null && this.mPhoneLevel != PhonePerformanceLevel.Level_2) {
            if (this.mIsUseBeauty || this.mIsUseLookupTable) {
                this.assembleMultiFilter();
            }
            this.drawThinFace(ofFrameData);
        } else if (this.mIsUseFaceLiftOpt) {
            if (facePointInfo != null && this.mPhoneLevel != PhonePerformanceLevel.Level_2) {
                this.drawFaceLiftOpt(ofFrameData);
            }
            this.assembleMultiFilter();
        } else if (this.mIsUseBeauty) {
            this.assembleMultiFilter();
        } else if (this.mIsUseLookupTable) {
            this.assembleMultiFilter();
        }
        if (facePointInfo != null) {
            this.mARJoyPKRender.applyEffect(this.mInputTexture, this.mOutputTexture, this.mOutputWidth, this.mOutputHeight, facePointInfo.mFrameData, this.mHasFace);
            GlUtil.checkGlError((String)"[sjc]delegate draw start.....");
            for (IOrangeFilterRenderDelegate delegate : this.mDelegateList) {
                if (delegate == null) continue;
                delegate.prepareInOpenglThread(this.mOfContextId);
                delegate.applyBuffer(this.mInputTexture, this.mOutputTexture, this.mOutputWidth, this.mOutputHeight, facePointInfo.mFrameData, this.mHasFace);
            }
            GlUtil.checkGlError((String)"[sjc]delegate draw end.....");
            this.mARGiftRender.applyEffect(this.mInputTexture, this.mOutputTexture, this.mOutputWidth, this.mOutputHeight, ofFrameData, this.mHasFace);
            this.mBeauty6EffectRender.applyFrame(this.mInputTexture, this.mOutputTexture, this.mOutputWidth, this.mOutputHeight, ofFrameData, this.mHasFace);
        }
        this.faceStatusCallback();
        GLES20.glBindFramebuffer((int)36160, (int)this.mOldFramebuffer.get(0));
        this.mPassthroughShader.useProgram();
        this.mPassthroughShader.setUniformTexture("uTexture0", 0, this.mInputTexture.getTextureId(), this.mInputTexture.getTarget());
        this.drawQuad(this.mPassthroughShader, this.mRectDrawable.getVertexArray(), this.mRectDrawable.getTexCoordArray());
        GLES20.glBindTexture((int)this.mTextureTarget, (int)0);
    }

    public void onOutputSizeChanged(int width, int height) {
        LogWrapper.i(TAG, "[Beauty  ]onOutputSizeChanged OF width: " + width + " ,height: " + height);
        this.mOutputWidth = width;
        this.mOutputHeight = height;
    }

    private void updateOrangeFilterByPhoneLevel() {
        this.initOFDeviceLevel(this.mCurrentPhoneLevel);
        if (this.mFilterBasicThinFace != 0) {
            OrangeFilter.destroyFilter((int)this.mOfContextId, (int)this.mFilterBasicThinFace);
            this.mFilterBasicThinFace = OrangeFilter.createFilter((int)this.mOfContextId, (String)"BasicThinFaceFilter");
        }
        if (this.mFilterBeauty5 != 0) {
            OrangeFilter.destroyFilter((int)this.mOfContextId, (int)this.mFilterBeauty5);
            this.mFilterBeauty5 = OrangeFilter.createFilter((int)this.mOfContextId, (String)"BeautyFilter5");
        }
        if (this.mFilterFaceLifting != 0) {
            OrangeFilter.destroyFilter((int)this.mOfContextId, (int)this.mFilterFaceLifting);
            this.mFilterFaceLifting = OrangeFilter.createFilter((int)this.mOfContextId, (String)"FaceLiftingOptFilter");
        }
        if (this.mFilterFaceLiftOpt != 0) {
            OrangeFilter.destroyFilter((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt);
            this.mFilterFaceLiftOpt = OrangeFilter.createFilter((int)this.mOfContextId, (String)"FaceLiftingOptFilter");
        }
    }

    private void drawSticker(OrangeFilter.OF_FrameData ofFrameData) {
        if (!this.mHasFace) {
            OrangeFilterWrapper.checkTextureId((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
            OrangeFilter.applyEffect((int)this.mOfContextId, (int)this.mStickerEffectFilter, (int)this.mInputTexture.getTextureId(), (int)3553, (int)this.mOutputTexture.getTextureId(), (int)3553, (int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight, null);
            OrangeFilterWrapper.swap((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
            if (this.mStickerLutEffectFilter != 0) {
                OrangeFilterWrapper.checkTextureId((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
                OrangeFilter.applyEffect((int)this.mOfContextId, (int)this.mStickerLutEffectFilter, (int)this.mInputTexture.getTextureId(), (int)3553, (int)this.mOutputTexture.getTextureId(), (int)3553, (int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight, null);
                OrangeFilterWrapper.swap((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
            }
        } else {
            if (this.mStickerLutEffectFilter != 0) {
                OrangeFilterWrapper.checkTextureId((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
                OrangeFilter.applyEffect((int)this.mOfContextId, (int)this.mStickerLutEffectFilter, (int)this.mInputTexture.getTextureId(), (int)3553, (int)this.mOutputTexture.getTextureId(), (int)3553, (int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight, (OrangeFilter.OF_FrameData)ofFrameData);
                OrangeFilterWrapper.swap((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
            }
            OrangeFilterWrapper.checkTextureId((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
            int[] stickerEffectFilter = new int[]{this.mStickerEffectFilter};
            int bNeedAvatar = OrangeFilter.getRequiredFrameData((int)this.mOfContextId, (int[])stickerEffectFilter) & 0x100;
            if (bNeedAvatar != 0) {
                OrangeFilter.applyAvatar((int)this.mOfContextId, (int)this.mAvatar, (OrangeFilter.OF_FrameData)ofFrameData);
            }
            OrangeFilter.applyEffect((int)this.mOfContextId, (int)this.mStickerEffectFilter, (int)this.mInputTexture.getTextureId(), (int)3553, (int)this.mOutputTexture.getTextureId(), (int)3553, (int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight, (OrangeFilter.OF_FrameData)ofFrameData);
            OrangeFilterWrapper.swap((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
        }
    }

    private void drawFaceLiftOpt(OrangeFilter.OF_FrameData ofFrameData) {
        if (this.mHasFace) {
            OrangeFilterWrapper.checkTextureId((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
            OrangeFilter.applyFilter((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)this.mInputTexture.getTextureId(), (int)3553, (int)this.mOutputTexture.getTextureId(), (int)3553, (int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight, (OrangeFilter.OF_FrameData)ofFrameData);
            OrangeFilterWrapper.swap((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
        }
    }

    private void drawFaceLift(OrangeFilter.OF_FrameData ofFrameData) {
        if (this.mHasFace) {
            OrangeFilterWrapper.checkTextureId((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
            if (this.mFilterFaceLifting != 0) {
                OrangeFilter.applyFilter((int)this.mOfContextId, (int)this.mFilterFaceLifting, (int)this.mInputTexture.getTextureId(), (int)3553, (int)this.mOutputTexture.getTextureId(), (int)3553, (int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight, (OrangeFilter.OF_FrameData)ofFrameData);
                OrangeFilterWrapper.swap((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
            }
        }
    }

    private void drawThinFace(OrangeFilter.OF_FrameData ofFrameData) {
        if (this.mHasFace) {
            OrangeFilterWrapper.checkTextureId((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
            if (this.mFilterBasicThinFace != 0) {
                OrangeFilter.applyFilter((int)this.mOfContextId, (int)this.mFilterBasicThinFace, (int)this.mInputTexture.getTextureId(), (int)3553, (int)this.mOutputTexture.getTextureId(), (int)3553, (int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight, (OrangeFilter.OF_FrameData)ofFrameData);
                OrangeFilterWrapper.swap((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
            }
        }
    }

    private void faceStatusCallback() {
        if (this.mListener != null) {
            if (this.mIsUseSticker && this.mHasFace) {
                this.mListener.onPreProcessStatus(1);
            } else if (this.mIsUseSticker && !this.mHasFace) {
                ++this.mNoFaceCount;
                if (this.mNoFaceCount > 10) {
                    this.mListener.onPreProcessStatus(2);
                }
            } else {
                this.mListener.onPreProcessStatus(0);
                this.mNoFaceCount = 0;
            }
        } else {
            this.mNoFaceCount = 0;
        }
    }

    @Override
    public void setLookupTable(String effectPath) {
        this.mLookupEffectPath = effectPath;
        if (this.mHandler != null && this.mHandler.getLooper().getThread().isAlive()) {
            LogWrapper.i(TAG, "[Beauty  ]mHandler != null && mHandler.getLooper().getThread().isAlive()");
            this.mHandler.post(() -> this.setLookupTableEffect(effectPath));
        } else {
            LogWrapper.w(TAG, "GL thread handler is null or died, ignore setLookupTable");
        }
    }

    private void setLookupTableEffect(String effectPath) {
        LogWrapper.i(TAG, "[Beauty  ]setLookupTable effectPath: " + effectPath);
        if (effectPath != null && !effectPath.isEmpty()) {
            LogWrapper.i(TAG, "[Beauty  ]effectPath != null && !effectPath.isEmpty()");
            File effectFile = new File(effectPath);
            if (effectFile != null && effectFile.exists()) {
                LogWrapper.i(TAG, "[Beauty  ]effectFile != null && effectFile.exists()");
                this.mIsUseLookupTable = true;
                LogWrapper.i(TAG, "Perform the lookUpTable: " + effectPath);
                OrangeFilter.setLookupTable((int)this.mOfContextId, (int)this.mFilterLookUpTable, (String)effectPath);
                this.mLookupEffectPath = effectPath;
            }
        } else {
            LogWrapper.i(TAG, "[Beauty  ]mIsUseLookupTable = false");
            this.mIsUseLookupTable = false;
        }
    }

    @Override
    public void setLookupTableParam(float level) {
        if (this.mHandler != null && this.mHandler.getLooper().getThread().isAlive()) {
            this.mHandler.post(() -> {
                LogWrapper.i(TAG, "[Beauty  ]setLookupTableParam: " + level);
                this.mIsUseLookupTable = level > 1.0E-5f;
                if (this.mFilterLookUpTable != 0) {
                    OrangeFilter.getFilterParamfData((int)this.mOfContextId, (int)this.mFilterLookUpTable, (int)0, (OrangeFilter.OF_Paramf)this.mOFParamf);
                    float min = this.mOFParamf.minVal;
                    float max = this.mOFParamf.maxVal;
                    float value = min + (max - min) * level;
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterLookUpTable, (int)0, (float)value);
                } else {
                    LogWrapper.w(TAG, "setLookupTableParam, mFilterLookUpTable is invalid");
                }
            });
        } else {
            this.mLookupTableParam = level;
            LogWrapper.w(TAG, "GL thread handler is null or died, ignore setLookupParam");
        }
    }

    @Override
    public void setBeauty5Effect(String effectFile) {
        if (this.mHandler != null && this.mHandler.getLooper().getThread().isAlive()) {
            this.mHandler.post(() -> this.setBeauty5EffectFile(effectFile));
        } else {
            this.mBeauty5EffectPathFile = effectFile;
            LogWrapper.w(TAG, "GL thread handler is null or died, ignore setBeauty5Effect");
        }
    }

    private void setBeauty5EffectFile(String effectFile) {
        if (effectFile != null) {
            LogWrapper.i(TAG, "[Beauty  ]setBeauty5Effect is true!");
            this.mIsUseNewBeauty5 = true;
            String resDir = effectFile.substring(0, effectFile.lastIndexOf("/"));
            if (this.mBeauty5EffectHandle == 0) {
                this.mBeauty5EffectHandle = OrangeFilter.createEffectFromFile((int)this.mOfContextId, (String)effectFile, (String)resDir);
            } else {
                OrangeFilter.updateEffectFromFile((int)this.mOfContextId, (int)this.mBeauty5EffectHandle, (String)effectFile, (String)resDir);
            }
            int result = OrangeFilter.getEffectInfo((int)this.mOfContextId, (int)this.mBeauty5EffectHandle, (OrangeFilter.OF_EffectInfo)this.mEffectInfo);
            if (result == 0) {
                this.mBeauty5EffectId = this.mEffectInfo.filterList[0];
                LogWrapper.i(TAG, "get mBeauty5EffectId:" + this.mBeauty5EffectId + " mBeauty5EffectHandle:" + this.mBeauty5EffectHandle);
            }
        } else {
            LogWrapper.i(TAG, "[Beauty  ]setBeauty5Effect is false!");
            this.mIsUseNewBeauty5 = false;
            if (this.mBeauty5EffectHandle != 0) {
                OrangeFilter.destroyEffect((int)this.mOfContextId, (int)this.mBeauty5EffectHandle);
                this.mBeauty5EffectHandle = 0;
            }
            if (this.mEffectInfo != null) {
                this.mEffectInfo.filterList[0] = 0;
                this.mEffectInfo.paramfCount = 0;
                this.mBeauty5EffectId = 0;
            }
        }
    }

    @Override
    public void setBeautyParam(float val) {
        if (this.mHandler != null && this.mHandler.getLooper().getThread().isAlive()) {
            this.mHandler.post(() -> this.setBeautyEffectParam(val));
        } else {
            this.mBeautyParam = val;
            LogWrapper.w(TAG, "GL thread handler is null or died, ignore setBeautyParam");
        }
    }

    private void setBeautyEffectParam(float val) {
        float value;
        float max;
        float min;
        LogWrapper.i(TAG, "[Beauty  ]setBeautyParam: " + val);
        this.mIsUseBeauty = val > 1.0E-5f;
        if (this.mWitnessFilter != 0) {
            OrangeFilter.getFilterParamfData((int)this.mOfContextId, (int)this.mWitnessFilter, (int)0, (OrangeFilter.OF_Paramf)this.mOFParamf);
            min = this.mOFParamf.minVal;
            max = this.mOFParamf.maxVal;
            value = min + (max - min) * val;
            OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mWitnessFilter, (int)0, (float)value);
        }
        if (this.mBeauty5EffectHandle != 0) {
            OrangeFilter.getFilterParamfData((int)this.mOfContextId, (int)this.mBeauty5EffectId, (int)0, (OrangeFilter.OF_Paramf)this.mOFParamf);
            min = this.mOFParamf.minVal;
            max = this.mOFParamf.maxVal;
            value = min + (max - min) * val;
            OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mBeauty5EffectId, (int)0, (float)value);
        } else {
            OrangeFilter.getFilterParamfData((int)this.mOfContextId, (int)this.mFilterBeauty5, (int)0, (OrangeFilter.OF_Paramf)this.mOFParamf);
            min = this.mOFParamf.minVal;
            max = this.mOFParamf.maxVal;
            value = min + (max - min) * val;
            OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterBeauty5, (int)0, (float)value);
        }
    }

    @Override
    public void setThinFaceParam(float val) {
        if (this.mHandler != null && this.mHandler.getLooper().getThread().isAlive()) {
            this.mHandler.post(() -> this.setThinFace(val));
        } else {
            this.mThinFaceParam = val;
            LogWrapper.w(TAG, "GL thread handler is null or died, ignore setThinFaceParam");
        }
    }

    private void setThinFace(float val) {
        LogWrapper.i(TAG, "[Beauty  ]setThinFaceParam: " + val);
        this.mIsUseThinFace = val > 1.0E-5f;
        if (this.mFilterBasicThinFace != 0) {
            OrangeFilter.getFilterParamfData((int)this.mOfContextId, (int)this.mFilterBasicThinFace, (int)0, (OrangeFilter.OF_Paramf)this.mOFParamf);
            float min = this.mOFParamf.minVal;
            float max = this.mOFParamf.maxVal;
            float value = min + (max - min) * val;
            OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterBasicThinFace, (int)0, (float)value);
        } else {
            LogWrapper.w(TAG, "setThinFace mFilterBasicThinFace == invalid");
        }
    }

    private boolean isNeedOrangeFilter() {
        boolean useGift = this.mARGiftRender.isUseArGift();
        boolean useArJoyPK = this.mARJoyPKRender.isUseArJoyPK();
        boolean useBeauty6Filter = this.mBeauty6EffectRender.isUseBeauty6EffectRender();
        boolean ret = this.mIsUseBeauty || this.mIsUseThinFace || this.mIsUseSticker || useGift || useArJoyPK || this.mIsDelegateNeedFace || this.mIsUseFaceLift || this.mIsUseFaceLiftOpt || this.mIsUseLookupTable || useBeauty6Filter;
        return ret;
    }

    @Override
    public void setOrangeFilterRenderDelegateList(ArrayList<IOrangeFilterRenderDelegate> delegateList) {
        LogWrapper.i(TAG, "[Beauty  ]delegateList: " + delegateList.size());
        this.mDelegateList = delegateList;
        for (IOrangeFilterRenderDelegate delegate : this.mDelegateList) {
            if (delegate.needFace()) {
                this.mIsDelegateNeedFace = true;
                break;
            }
            this.mIsDelegateNeedFace = false;
        }
        if (this.mDelegateList.isEmpty()) {
            this.mIsDelegateNeedFace = false;
        }
    }

    @Override
    public void setFaceLiftValue(Map<Integer, Float> faceLiftValue) {
        if (this.mHandler != null && this.mHandler.getLooper().getThread().isAlive()) {
            this.mHandler.post(() -> this.setFaceLiftValueInner(faceLiftValue));
        } else {
            LogWrapper.w(TAG, "GL thread handler is null, ignore setFaceLiftValue");
            this.mFaceLiftValue = faceLiftValue;
        }
    }

    private void setFaceLiftValueInner(Map<Integer, Float> faceLiftValue) {
        if (faceLiftValue == null || faceLiftValue.isEmpty()) {
            LogWrapper.i(TAG, "[sjc]..not use FaceLift....");
            if (this.mIsUseFaceLift) {
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mWitnessFilter, (int)0, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterBeauty5, (int)0, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterLookUpTable, (int)0, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLifting, (int)8, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLifting, (int)0, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLifting, (int)5, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLifting, (int)24, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLifting, (int)18, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLifting, (int)12, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLifting, (int)15, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLifting, (int)21, (float)0.0f);
            }
            this.mIsUseFaceLift = false;
            this.mIsUseWhiteNess = true;
            this.mIsUseDermabrasion = true;
            return;
        }
        this.mIsUseFaceLift = true;
        for (Integer key : faceLiftValue.keySet()) {
            switch (key) {
                case 1: {
                    float value = faceLiftValue.get(key).floatValue();
                    this.mIsUseWhiteNess = value > 1.0E-5f;
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterLookUpTable, (int)0, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.WHITENESS: " + value + " , mIsUseWhiteNess: " + this.mIsUseWhiteNess);
                    break;
                }
                case 2: {
                    float value = faceLiftValue.get(key).floatValue();
                    this.mIsUseDermabrasion = value > 1.0E-5f;
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterBeauty5, (int)0, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.DERMABARSION: " + value + " mIsUseDermabrasion: " + this.mIsUseDermabrasion);
                    break;
                }
                case 3: {
                    float value = faceLiftValue.get(key).floatValue();
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLifting, (int)8, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.BIG_EYES: " + value);
                    break;
                }
                case 4: {
                    float value = faceLiftValue.get(key).floatValue();
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLifting, (int)0, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.THIN_FACE: " + value);
                    break;
                }
                case 5: {
                    float value = faceLiftValue.get(key).floatValue();
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLifting, (int)5, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.SMALL_FACE: " + value);
                    break;
                }
                case 6: {
                    float value = faceLiftValue.get(key).floatValue();
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLifting, (int)24, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.FOREHEAD: " + value);
                    break;
                }
                case 7: {
                    float value = faceLiftValue.get(key).floatValue();
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLifting, (int)18, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.CHEEKBONES: " + value);
                    break;
                }
                case 8: {
                    float value = faceLiftValue.get(key).floatValue();
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLifting, (int)12, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.NOSE: " + value);
                    break;
                }
                case 9: {
                    float value = faceLiftValue.get(key).floatValue();
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLifting, (int)15, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.MOUTH: " + value);
                    break;
                }
                case 10: {
                    float value = faceLiftValue.get(key).floatValue();
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLifting, (int)21, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.CHIN: " + value);
                    break;
                }
            }
        }
    }

    @Override
    public void setFaceLiftValueOpt(@NotNull Map<Integer, Float> faceLiftValueOpt) {
        if (this.mHandler != null && this.mHandler.getLooper().getThread().isAlive()) {
            this.mHandler.post(() -> this.setFaceLiftValueOptInner(faceLiftValueOpt));
        } else {
            this.mFaceLiftValueOpt = faceLiftValueOpt;
            LogWrapper.w(TAG, "GL thread handler is null, ignore setFaceLiftValueOpt");
        }
    }

    private void setFaceLiftValueOptInner(Map<Integer, Float> faceLiftValue) {
        if (faceLiftValue == null || faceLiftValue.isEmpty()) {
            LogWrapper.i(TAG, "[sjc]..not use FaceLiftOpt....");
            if (this.mIsUseFaceLiftOpt) {
                this.setBeauty5Param(0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterLookUpTable, (int)0, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mWitnessFilter, (int)0, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)18, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)1, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)6, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)12, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)9, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)26, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)32, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)23, (float)0.0f);
                OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)37, (float)0.0f);
            }
            this.mIsUseFaceLiftOpt = false;
            this.mIsUseWhiteNess = true;
            this.mIsUseDermabrasion = true;
            return;
        }
        this.mIsUseFaceLiftOpt = true;
        for (Integer key : faceLiftValue.keySet()) {
            switch (key) {
                case 101: {
                    float value = faceLiftValue.get(key).floatValue();
                    this.mIsUseLookupTable = value > 1.0E-5f;
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterLookUpTable, (int)0, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.WHITENESS: " + value + " , mIsUseLookupTable: " + this.mIsUseLookupTable);
                    break;
                }
                case 102: {
                    float value = faceLiftValue.get(key).floatValue();
                    this.mIsUseDermabrasion = value > 1.0E-5f;
                    this.setBeauty5Param(value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.DERMABARSION: " + value + " mIsUseDermabrasion: " + this.mIsUseDermabrasion);
                    break;
                }
                case 18: {
                    float value = faceLiftValue.get(key).floatValue();
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)18, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.BIG_EYES: " + value);
                    break;
                }
                case 1: {
                    float value = faceLiftValue.get(key).floatValue();
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)1, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.THIN_FACE: " + value);
                    break;
                }
                case 6: {
                    float value = faceLiftValue.get(key).floatValue();
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)6, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.SMALL_FACE: " + value);
                    break;
                }
                case 12: {
                    float value = faceLiftValue.get(key).floatValue();
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)12, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.FOREHEAD: " + value);
                    break;
                }
                case 9: {
                    float value = faceLiftValue.get(key).floatValue();
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)9, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.CHEEKBONES: " + value);
                    break;
                }
                case 26: {
                    float value = faceLiftValue.get(key).floatValue();
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)26, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.NOSE: " + value);
                    break;
                }
                case 23: {
                    float value = faceLiftValue.get(key).floatValue();
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)23, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.NOSE: " + value);
                    break;
                }
                case 32: {
                    float value = faceLiftValue.get(key).floatValue();
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)32, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.MOUTH: " + value);
                    break;
                }
                case 37: {
                    float value = faceLiftValue.get(key).floatValue();
                    OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterFaceLiftOpt, (int)37, (float)value);
                    LogWrapper.i(TAG, "[sjc]..FaceLift.CHIN: " + value);
                    break;
                }
            }
        }
    }

    @Override
    public void setWitnessEffect(String effectPath) {
        if (this.mHandler != null && this.mHandler.getLooper().getThread().isAlive()) {
            this.mHandler.post(() -> this.setCurrentWitnessEffectPath(effectPath));
        } else {
            this.mWitnessEffectPath = effectPath;
            LogWrapper.w(TAG, "GL thread handler is null or died, ignore setWitnessEffect");
        }
    }

    private void setCurrentWitnessEffectPath(String effectPath) {
        LogWrapper.i(TAG, "[Beauty  ]setWitnessEffect effectPath: " + effectPath);
        if (effectPath != null) {
            this.mIsUseWhiteNess = true;
            if (effectPath.equals(this.mCurrentWitnessEffectPath)) {
                LogWrapper.i(TAG, "[Beauty  ]the effectPath is the same...");
            } else {
                OrangeFilter.setLookupTable((int)this.mOfContextId, (int)this.mWitnessFilter, (String)effectPath);
                this.mCurrentWitnessEffectPath = effectPath;
            }
        } else {
            this.mIsUseWhiteNess = false;
        }
    }

    private void setBeauty5Param(float value) {
        if (this.mBeauty5EffectHandle != 0) {
            OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mBeauty5EffectId, (int)0, (float)value);
        } else {
            OrangeFilter.setFilterParamf((int)this.mOfContextId, (int)this.mFilterBeauty5, (int)0, (float)value);
        }
    }

    private void drawBeauty5() {
        if (this.mBeauty5EffectHandle != 0) {
            OrangeFilterWrapper.checkTextureId((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
            OrangeFilter.OF_Texture[] inputTexture = new OrangeFilter.OF_Texture[]{new OrangeFilter.OF_Texture()};
            inputTexture[0].textureID = this.mInputTexture.getTextureId();
            inputTexture[0].format = 6408;
            inputTexture[0].width = this.mOutputWidth;
            inputTexture[0].height = this.mOutputHeight;
            inputTexture[0].target = 3553;
            OrangeFilter.OF_Texture[] outputTexture = new OrangeFilter.OF_Texture[]{new OrangeFilter.OF_Texture()};
            outputTexture[0].textureID = this.mOutputTexture.getTextureId();
            outputTexture[0].format = 6408;
            outputTexture[0].width = this.mOutputWidth;
            outputTexture[0].height = this.mOutputHeight;
            outputTexture[0].target = 3553;
            OrangeFilter.applyFrame((int)this.mOfContextId, (int)this.mBeauty5EffectId, (OrangeFilter.OF_Texture[])inputTexture, (OrangeFilter.OF_Texture[])outputTexture);
            OrangeFilterWrapper.swap((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
        } else {
            OrangeFilterWrapper.checkTextureId((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
            OrangeFilter.applyFilter((int)this.mOfContextId, (int)this.mFilterBeauty5, (int)this.mInputTexture.getTextureId(), (int)3553, (int)this.mOutputTexture.getTextureId(), (int)3553, (int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight, null);
            OrangeFilterWrapper.swap((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
        }
    }

    private void assembleMultiFilter() {
        if (this.mIsUseWhiteNess && this.mPhoneLevel != PhonePerformanceLevel.Level_2) {
            OrangeFilterWrapper.checkTextureId((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
            OrangeFilter.applyFilter((int)this.mOfContextId, (int)this.mWitnessFilter, (int)this.mInputTexture.getTextureId(), (int)3553, (int)this.mOutputTexture.getTextureId(), (int)3553, (int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight, null);
            OrangeFilterWrapper.swap((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
        }
        if ((this.mIsUseBeauty || this.mIsUseDermabrasion) && this.mPhoneLevel != PhonePerformanceLevel.Level_2) {
            this.drawBeauty5();
        }
        if (this.mIsUseLookupTable) {
            OrangeFilterWrapper.checkTextureId((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
            OrangeFilter.applyFilter((int)this.mOfContextId, (int)this.mFilterLookUpTable, (int)this.mInputTexture.getTextureId(), (int)3553, (int)this.mOutputTexture.getTextureId(), (int)3553, (int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight, null);
            OrangeFilterWrapper.swap((GLTexture)this.mInputTexture, (GLTexture)this.mOutputTexture);
        }
    }

    @Override
    public void setStickerDirPath(String dir) {
        if (this.mHandler != null && this.mHandler.getLooper().getThread().isAlive()) {
            this.mHandler.post(() -> this.setStickerDirPathInner(dir));
        } else {
            LogWrapper.w(TAG, "GL thread handler is null or died, ignore setStickerDirPath");
            this.mSickerEffectPathFile = dir;
        }
    }

    private boolean setStickerDirPathInner(String dir) {
        LogWrapper.i(TAG, "[sjc] setStickerDirPath: " + dir);
        if (dir != null) {
            String effectConfigPath = dir + "/" + "effectconfig.conf";
            HashMap effectMap = FileUtil.checkEffectConfig((String)dir, (String)effectConfigPath);
            this.mStickerEffect = (String)effectMap.get("sticker");
            this.mStickerLutEffect = (String)effectMap.get("sticker_lut");
        } else {
            this.mStickerEffect = null;
            this.mStickerLutEffect = null;
        }
        if (this.mStickerEffect != null) {
            if (this.mOfContextId == 0) {
                LogWrapper.i(TAG, "[sjc] setStickerDirPath: mOfContextId == 0 \u4e0d\u80fd\u4f7f\u7528");
                return false;
            }
            int supportValue = OrangeFilter.isSupportEffect((int)this.mOfContextId, (String)this.mStickerEffect);
            LogWrapper.i(TAG, "[sjc] setStickerDirPath mStickerEffect supportValue = " + supportValue + " mStickerEffect " + this.mStickerEffect);
            if (supportValue != 0) {
                LogWrapper.i(TAG, "[sjc] setStickerDirPath mStickerEffect isSupportEffect == false");
                return false;
            }
        }
        if (this.mStickerLutEffect != null) {
            if (this.mOfContextId == 0) {
                LogWrapper.i(TAG, "[sjc] setStickerDirPath: mOfContextId == 0 \u4e0d\u80fd\u4f7f\u7528");
                return false;
            }
            int supportValue = OrangeFilter.isSupportEffect((int)this.mOfContextId, (String)this.mStickerLutEffect);
            LogWrapper.i(TAG, "[sjc] setStickerDirPath mStickerLutEffect supportValue = " + supportValue + " mStickerEffect " + this.mStickerEffect);
            if (supportValue != 0) {
                LogWrapper.i(TAG, "[sjc] setStickerDirPath mStickerLutEffect isSupportEffect == false");
                return false;
            }
        }
        this.setNewStickerEffect(this.mStickerEffect, this.mStickerLutEffect);
        return true;
    }

    private void setNewStickerEffect(String stickerEffect, String stickerLutEffect) {
        LogWrapper.i(TAG, "[Beauty  ] stickerEffect: " + stickerEffect + " ,stickerLutEffect:" + stickerLutEffect);
        if (stickerEffect != null) {
            int result;
            LogWrapper.i(TAG, "[Beauty  ]useSticker is true!");
            this.mIsUseSticker = true;
            String resDir = stickerEffect.substring(0, stickerEffect.lastIndexOf("/"));
            if (this.mStickerEffectFilter == 0) {
                this.mStickerEffectFilter = OrangeFilter.createEffectFromFile((int)this.mOfContextId, (String)stickerEffect, (String)resDir);
            } else {
                OrangeFilter.updateEffectFromFile((int)this.mOfContextId, (int)this.mStickerEffectFilter, (String)stickerEffect, (String)resDir);
            }
            if (stickerLutEffect != null) {
                if (this.mStickerLutEffectFilter == 0) {
                    this.mStickerLutEffectFilter = OrangeFilter.createEffectFromFile((int)this.mOfContextId, (String)stickerLutEffect, (String)resDir);
                } else {
                    OrangeFilter.updateEffectFromFile((int)this.mOfContextId, (int)this.mStickerLutEffectFilter, (String)stickerLutEffect, (String)resDir);
                }
            }
            if ((result = OrangeFilter.getEffectInfo((int)this.mOfContextId, (int)this.mStickerEffectFilter, (OrangeFilter.OF_EffectInfo)this.mEffectInfo)) == 0 && this.mEffectInfo.version < 4) {
                OrangeFilter.setEffectMirrorMode((int)this.mOfContextId, (int)this.mStickerEffectFilter, (int)1);
            }
        } else {
            LogWrapper.i(TAG, "[Beauty  ]useSticker is false!");
            this.mIsUseSticker = false;
            if (this.mStickerEffectFilter != 0) {
                OrangeFilter.destroyEffect((int)this.mOfContextId, (int)this.mStickerEffectFilter);
                this.mStickerEffectFilter = 0;
            }
            if (this.mStickerLutEffectFilter != 0) {
                OrangeFilter.destroyEffect((int)this.mOfContextId, (int)this.mStickerLutEffectFilter);
                this.mStickerLutEffectFilter = 0;
            }
            if (this.mEffectInfo != null) {
                this.mEffectInfo.paramfCount = 0;
            }
        }
        if (this.mListener != null) {
            this.mListener.onPreProcessStatus(6);
        }
    }

    private void initOFDeviceLevel(PhonePerformanceLevel level) {
        LogWrapper.i(TAG, "[Beauty  ][sjc] ,mCurrentPhoneLevel:" + level);
        if (level == PhonePerformanceLevel.Level_0) {
            OrangeFilter.setConfigInt((int)this.mOfContextId, (int)9, (int)0);
        } else if (level == PhonePerformanceLevel.Level_1) {
            OrangeFilter.setConfigInt((int)this.mOfContextId, (int)9, (int)1);
        } else if (level == PhonePerformanceLevel.Level_2) {
            OrangeFilter.setConfigInt((int)this.mOfContextId, (int)9, (int)2);
        }
    }

    public void setFilterBeauty6Param(float param) {
        LogWrapper.i(TAG, "setFilterBeauty6Param " + param);
        this.mBeauty6EffectRender.setFilterBeauty6Param(param);
    }

    public ARGiftRender getARGiftRender() {
        return this.mARGiftRender;
    }
}

