/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.videoeffect.thunderbolt.beauty;

import android.util.JsonReader;
import android.util.JsonWriter;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import tv.athena.live.component.videoeffect.thunderbolt.util.LogWrapper;

public class FileSnapshotHelper {
    private static String LABEL_INTEGRAL = ".snapshot";
    private static String TAG = "FileSnapshotHelper";

    public static DirSnapshot createFileSnapshot(String targetDir) {
        File file = new File(targetDir);
        if (file.exists()) {
            File integralFile = new File(targetDir + "/" + LABEL_INTEGRAL);
            File[] targetDirFiles = file.listFiles((dir, name) -> !LABEL_INTEGRAL.equals(name));
            if (targetDirFiles != null && targetDirFiles.length > 0) {
                DirSnapshot integral = new DirSnapshot();
                integral.dir = targetDir;
                integral.fileCount = targetDirFiles.length;
                integral.fileSnapshots = new ArrayList<FileSnapshot>();
                for (File targetDirFile : targetDirFiles) {
                    FileSnapshot fileInfo = new FileSnapshot();
                    fileInfo.name = targetDirFile.getName();
                    fileInfo.lastModified = targetDirFile.lastModified();
                    integral.fileSnapshots.add(fileInfo);
                }
                FileSnapshotHelper.save2Json(integralFile, integral);
                return integral;
            }
        }
        return null;
    }

    public static boolean checkSnapshot(String targetDir) {
        File targetDirFile;
        File[] targetDirChilds;
        DirSnapshot dirSnapshot;
        File integralFile = new File(targetDir + "/" + LABEL_INTEGRAL);
        DirSnapshot dirSnapshot2 = dirSnapshot = integralFile.exists() ? FileSnapshotHelper.jsonFromFile(integralFile.getAbsolutePath()) : null;
        if (dirSnapshot != null && (targetDirChilds = (targetDirFile = new File(targetDir)).listFiles((dir, name) -> !LABEL_INTEGRAL.equals(name))) != null && targetDirChilds.length == dirSnapshot.fileCount) {
            for (File targetDirChild : targetDirChilds) {
                if (dirSnapshot.isInSnapshot(targetDirChild, true)) continue;
                LogWrapper.i(TAG, "Check snapshot false: " + targetDirChild.getName());
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save2Json(File target, DirSnapshot integral) {
        JsonWriter writer = null;
        try {
            writer = new JsonWriter((Writer)new OutputStreamWriter(new FileOutputStream(target)));
            writer.beginObject();
            writer.name("fileCount").value((long)integral.fileCount);
            writer.name("fileSnapshots");
            writer.beginArray();
            for (FileSnapshot fileInfo : integral.fileSnapshots) {
                writer.beginObject();
                writer.name("fileName").value(fileInfo.name);
                writer.name("fileLastModified").value(fileInfo.lastModified);
                writer.endObject();
            }
            writer.endArray();
            writer.endObject();
            writer.flush();
        }
        catch (Exception e) {
            LogWrapper.i(TAG, Log.getStackTraceString((Throwable)e));
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LogWrapper.w(TAG, Log.getStackTraceString((Throwable)e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DirSnapshot jsonFromFile(String filePath) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(filePath);
            JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
            jsonReader.beginObject();
            DirSnapshot dirSnapshot = new DirSnapshot();
            while (jsonReader.hasNext()) {
                String nextName = jsonReader.nextName();
                if ("fileCount".equals(nextName)) {
                    dirSnapshot.fileCount = jsonReader.nextInt();
                    continue;
                }
                if (!"fileSnapshots".equals(nextName)) continue;
                dirSnapshot.fileSnapshots = new ArrayList<FileSnapshot>(dirSnapshot.fileCount);
                jsonReader.beginArray();
                while (jsonReader.hasNext()) {
                    jsonReader.beginObject();
                    FileSnapshot fileSnapshot = new FileSnapshot();
                    while (jsonReader.hasNext()) {
                        String tag = jsonReader.nextName();
                        if ("fileName".equals(tag)) {
                            fileSnapshot.name = jsonReader.nextString();
                            continue;
                        }
                        if ("fileLastModified".equals(tag)) {
                            fileSnapshot.lastModified = jsonReader.nextLong();
                            continue;
                        }
                        jsonReader.skipValue();
                    }
                    jsonReader.endObject();
                    dirSnapshot.fileSnapshots.add(fileSnapshot);
                }
                jsonReader.endArray();
            }
            jsonReader.endObject();
            jsonReader.close();
            DirSnapshot dirSnapshot2 = dirSnapshot;
            return dirSnapshot2;
        }
        catch (Throwable e) {
            LogWrapper.w(TAG, Log.getStackTraceString((Throwable)e));
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception e) {
                LogWrapper.w(TAG, Log.getStackTraceString((Throwable)e));
            }
        }
        return null;
    }

    private static class FileSnapshot {
        String name;
        long lastModified;

        private FileSnapshot() {
        }

        public String toString() {
            return "\n  FileSnapshot{name='" + this.name + '\'' + ", lastModified=" + this.lastModified + '}';
        }
    }

    public static class DirSnapshot {
        String dir;
        int fileCount;
        List<FileSnapshot> fileSnapshots;

        public boolean isInSnapshot(File child, boolean shrinkList) {
            if (this.fileSnapshots != null) {
                for (FileSnapshot fileInfo : this.fileSnapshots) {
                    if (!fileInfo.name.equals(child.getName()) || fileInfo.lastModified != child.lastModified()) continue;
                    if (shrinkList) {
                        this.fileSnapshots.remove(fileInfo);
                    }
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "DirSnapshot{\ndir=" + this.dir + "\nfileCount=" + this.fileCount + "\nfileSnapshots=" + this.fileSnapshots + '}';
        }
    }
}

