/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.videoeffect.thunderbolt.beauty;

import android.content.Context;
import android.content.res.AssetManager;
import android.text.TextUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public class AssetsFileHelper {
    private static final String SEPARATOR = File.separator;

    public static void copyFilesFromAssets(Context context, String assetsPath, String storagePath) throws Exception {
        String[] fileNames;
        if (TextUtils.isEmpty((CharSequence)storagePath) || TextUtils.isEmpty((CharSequence)assetsPath)) {
            return;
        }
        AssetManager assetManager = context.getAssets();
        File file = new File(storagePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        if ((fileNames = assetManager.list(assetsPath)).length > 0) {
            String temp = "";
            for (String fileName : fileNames) {
                if (!TextUtils.isEmpty((CharSequence)assetsPath)) {
                    temp = assetsPath + SEPARATOR + fileName;
                }
                String[] childFileNames = assetManager.list(temp);
                if (!TextUtils.isEmpty((CharSequence)temp) && childFileNames.length > 0) {
                    AssetsFileHelper.copyFilesFromAssets(context, temp, storagePath + SEPARATOR + fileName);
                    continue;
                }
                InputStream inputStream = assetManager.open(temp);
                AssetsFileHelper.readInputStream(storagePath + SEPARATOR + fileName, inputStream);
            }
        } else {
            InputStream inputStream = assetManager.open(assetsPath);
            if (assetsPath.contains(SEPARATOR)) {
                assetsPath = assetsPath.substring(assetsPath.lastIndexOf(SEPARATOR));
            }
            AssetsFileHelper.readInputStream(storagePath + SEPARATOR + assetsPath, inputStream);
        }
    }

    public static void readInputStream(String storagePath, InputStream inputStream) throws Exception {
        File file = new File(storagePath);
        if (!file.exists()) {
            int len;
            FileOutputStream fos = new FileOutputStream(file);
            byte[] buffer = new byte[inputStream.available()];
            while ((len = inputStream.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
            fos.flush();
            fos.close();
            inputStream.close();
        }
    }
}

