/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.videoeffect.thunderbolt.beauty;

import com.orangefilter.OrangeFilter;
import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.mediaframework.gpuimage.util.GLTexture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import tv.athena.live.component.videoeffect.thunderbolt.beauty.IPreProcessListener;
import tv.athena.live.component.videoeffect.thunderbolt.util.LogWrapper;

public class ARJoyPKRender {
    private static final String TAG = "ARGiftRender";
    private final float[] defaultFacePointsPortrait = new float[]{0.3783299f, 0.4481389f, 0.38033468f, 0.45937306f, 0.38267797f, 0.470578f, 0.3859322f, 0.481699f, 0.39000008f, 0.49273866f, 0.39490762f, 0.5036578f, 0.40121874f, 0.5143665f, 0.40965194f, 0.52454317f, 0.4207021f, 0.53395236f, 0.43449098f, 0.542074f, 0.4503974f, 0.54902625f, 0.4676779f, 0.55492926f, 0.4861763f, 0.5598208f, 0.5053232f, 0.56358594f, 0.52528226f, 0.56601846f, 0.545682f, 0.5667489f, 0.5658899f, 0.56594265f, 0.5822209f, 0.56355965f, 0.597283f, 0.5595044f, 0.6104485f, 0.5538593f, 0.6218553f, 0.5470726f, 0.6319448f, 0.53963065f, 0.64075977f, 0.5317266f, 0.64796764f, 0.52323496f, 0.6533689f, 0.51421964f, 0.6572754f, 0.5049623f, 0.66004705f, 0.4955756f, 0.6621234f, 0.48608607f, 0.6635395f, 0.47658834f, 0.66388017f, 0.4670044f, 0.6627766f, 0.45745412f, 0.66033417f, 0.4479703f, 0.6573656f, 0.43860206f, 0.4255925f, 0.4177904f, 0.44659987f, 0.4071285f, 0.47141385f, 0.40389094f, 0.4965995f, 0.40464383f, 0.52039593f, 0.40790367f, 0.5784631f, 0.40902424f, 0.5970696f, 0.40621614f, 0.6158809f, 0.40554324f, 0.63358444f, 0.40779448f, 0.6482744f, 0.41704732f, 0.55546045f, 0.43318456f, 0.55897355f, 0.44342202f, 0.5625317f, 0.4535717f, 0.56604314f, 0.463868f, 0.52624273f, 0.48365802f, 0.5448737f, 0.48333746f, 0.5635529f, 0.48317283f, 0.5783836f, 0.48313016f, 0.5926233f, 0.48203105f, 0.4501503f, 0.43715483f, 0.4641527f, 0.43192863f, 0.49736494f, 0.43175727f, 0.5101833f, 0.4378658f, 0.49537727f, 0.44065294f, 0.46434712f, 0.44087178f, 0.58574194f, 0.43802938f, 0.5954714f, 0.43234557f, 0.6233322f, 0.4320166f, 0.6345672f, 0.437189f, 0.6233942f, 0.44056216f, 0.59775484f, 0.44066486f, 0.44784683f, 0.4148158f, 0.47222486f, 0.41280168f, 0.49695846f, 0.41349596f, 0.5203246f, 0.41548023f, 0.5798219f, 0.4162325f, 0.59829944f, 0.41461188f, 0.6166906f, 0.41398495f, 0.633972f, 0.4151658f, 0.48071802f, 0.42994732f, 0.47995207f, 0.44190836f, 0.48019087f, 0.43654212f, 0.60930055f, 0.43043923f, 0.61065805f, 0.4416253f, 0.61003983f, 0.43661585f, 0.53292966f, 0.4355444f, 0.57065785f, 0.43559495f, 0.5258201f, 0.4637436f, 0.5877376f, 0.46265563f, 0.5147546f, 0.47579306f, 0.59957737f, 0.47469988f, 0.5084598f, 0.5143722f, 0.53054714f, 0.5042134f, 0.55536836f, 0.49820766f, 0.56714356f, 0.49773997f, 0.5781024f, 0.49696016f, 0.59634215f, 0.5031259f, 0.6085195f, 0.5131235f, 0.59832156f, 0.5179404f, 0.5821847f, 0.5224041f, 0.5666857f, 0.52387893f, 0.5459474f, 0.5231123f, 0.52071977f, 0.51798135f, 0.5161898f, 0.51382416f, 0.5410154f, 0.51040107f, 0.5668808f, 0.5093938f, 0.5848938f, 0.5096954f, 0.6018912f, 0.51254606f, 0.5844668f, 0.5101353f, 0.5665585f, 0.51005983f, 0.5410537f, 0.5108182f, 0.48019266f, 0.43653432f, 0.6100543f, 0.43662137f};
    private final float[] defaultFacePointsHorizontal = new float[]{0.42341393f, 0.5680002f, 0.42361322f, 0.5901095f, 0.4242014f, 0.61214364f, 0.42541498f, 0.6341136f, 0.4274524f, 0.655838f, 0.43011492f, 0.6773742f, 0.43355155f, 0.6986362f, 0.43788806f, 0.7190461f, 0.44341105f, 0.73835075f, 0.45058164f, 0.7559601f, 0.45913863f, 0.77133995f, 0.46870756f, 0.7845768f, 0.4791685f, 0.7953766f, 0.4904832f, 0.80367786f, 0.502333f, 0.80906576f, 0.51458883f, 0.811862f, 0.52692664f, 0.8124578f, 0.53984255f, 0.81098974f, 0.5526365f, 0.8079938f, 0.5652235f, 0.8028797f, 0.57751715f, 0.7952598f, 0.5890927f, 0.7851101f, 0.59974444f, 0.7726198f, 0.6093129f, 0.7577069f, 0.61746585f, 0.74018455f, 0.62388355f, 0.7204266f, 0.6286227f, 0.6992454f, 0.6319609f, 0.6770249f, 0.63438976f, 0.65451545f, 0.63617355f, 0.6314777f, 0.63745326f, 0.6083173f, 0.6381731f, 0.5850853f, 0.63863975f, 0.561874f, 0.44138584f, 0.46196693f, 0.4539996f, 0.43124393f, 0.4692901f, 0.42309433f, 0.4854185f, 0.42392045f, 0.5014552f, 0.42981312f, 0.5429698f, 0.42768258f, 0.5598265f, 0.41961938f, 0.57713807f, 0.41693228f, 0.593944f, 0.42358106f, 0.6089988f, 0.45294142f, 0.52198666f, 0.4913025f, 0.5218257f, 0.51016414f, 0.5216605f, 0.52914107f, 0.5215608f, 0.54849803f, 0.49832925f, 0.6044002f, 0.5104865f, 0.60062295f, 0.5228676f, 0.59903944f, 0.5360551f, 0.59880406f, 0.5491659f, 0.60124975f, 0.45507878f, 0.50444597f, 0.46435356f, 0.49072298f, 0.48758492f, 0.48939717f, 0.49614754f, 0.5033348f, 0.48614246f, 0.5105117f, 0.46480632f, 0.5118202f, 0.5513384f, 0.4998008f, 0.56011254f, 0.48483488f, 0.58415264f, 0.48365802f, 0.59434515f, 0.4958268f, 0.5843731f, 0.5044753f, 0.5620785f, 0.50561523f, 0.45449096f, 0.45142224f, 0.46962124f, 0.4461252f, 0.4856102f, 0.44650286f, 0.501532f, 0.44982722f, 0.5434259f, 0.44792992f, 0.56015396f, 0.4423199f, 0.5773735f, 0.43998608f, 0.59394443f, 0.44393066f, 0.47601786f, 0.4855317f, 0.47549215f, 0.51372534f, 0.47575313f, 0.5012264f, 0.57209724f, 0.47966182f, 0.57328993f, 0.50772417f, 0.5727299f, 0.49531147f, 0.5091172f, 0.49719647f, 0.5366929f, 0.49542907f, 0.49917108f, 0.5556314f, 0.5469803f, 0.5524634f, 0.4917315f, 0.58624154f, 0.5558664f, 0.5817471f, 0.48595315f, 0.6832505f, 0.49765855f, 0.65235025f, 0.5145699f, 0.63439685f, 0.5233784f, 0.6353452f, 0.53209114f, 0.6339821f, 0.55121726f, 0.6487946f, 0.5663563f, 0.6776139f, 0.553946f, 0.68969536f, 0.54000443f, 0.6981479f, 0.5250128f, 0.70151395f, 0.51110566f, 0.70017546f, 0.49794555f, 0.6938824f, 0.48978394f, 0.6813012f, 0.50638235f, 0.6691768f, 0.5240678f, 0.66559094f, 0.5435566f, 0.6664959f, 0.5622264f, 0.67623615f, 0.543584f, 0.66713417f, 0.52423465f, 0.666444f, 0.5065262f, 0.66974807f, 0.47571316f, 0.50124806f, 0.57273895f, 0.49527583f};
    private OrangeFilter.OF_FrameData mDefaultFrameData = new OrangeFilter.OF_FrameData();
    private IPreProcessListener mListener;
    private int mOfContextId;
    private boolean mIsUseArPK = false;
    private ArrayList<EffectFilterObj> mEffectFilterList;
    private OrangeFilter.OF_EffectInfo mEffectInfo = null;

    public ARJoyPKRender(int ofContextId) {
        this.mOfContextId = ofContextId;
        this.mEffectFilterList = new ArrayList();
        this.mEffectInfo = new OrangeFilter.OF_EffectInfo();
        this.mDefaultFrameData.faceFrameDataArr = new OrangeFilter.OF_FaceFrameData[1];
        this.mDefaultFrameData.faceFrameDataArr[0] = new OrangeFilter.OF_FaceFrameData();
    }

    public void destroy() {
        for (EffectFilterObj obj : this.mEffectFilterList) {
            if (obj.effectFilterId == 0) continue;
            OrangeFilter.destroyEffect((int)this.mOfContextId, (int)obj.effectFilterId);
        }
        this.mEffectFilterList.clear();
    }

    public void setListener(IPreProcessListener listener) {
        this.mListener = listener;
    }

    public void setJoyPkEffect(String filePath, int index, String tag) {
        LogWrapper.i(TAG, "[Beauty  ] index: " + index + " ,tag: " + tag + " ,filePath: " + filePath);
        if (filePath != null) {
            this.mIsUseArPK = true;
            EffectFilterObj effectFilterObj = null;
            for (EffectFilterObj obj : this.mEffectFilterList) {
                if (!obj.tag.equals(tag)) continue;
                effectFilterObj = obj;
                break;
            }
            if (effectFilterObj == null) {
                effectFilterObj = new EffectFilterObj();
                effectFilterObj.effectFilterId = 0;
                effectFilterObj.state = FilterState.CREATE_STATE;
                this.mEffectFilterList.add(effectFilterObj);
            } else {
                effectFilterObj.state = FilterState.RESET_STATE;
            }
            effectFilterObj.tag = tag;
            effectFilterObj.index = index;
            effectFilterObj.result = 2;
            effectFilterObj.filePath = filePath;
            LogWrapper.i(TAG, "[Beauty  ] filePath: " + filePath + " ,state: " + (Object)((Object)effectFilterObj.state));
        }
    }

    public void removeJoyPkEffectWithTag(String tag) {
        LogWrapper.i(TAG, "[Beauty  ]removeJoyPkEffectWithTag,tag: " + tag);
        for (EffectFilterObj obj : this.mEffectFilterList) {
            if (!obj.tag.equals(tag)) continue;
            obj.state = FilterState.DELETE_STATE;
            break;
        }
    }

    public boolean isAnimationTagExist(String tag) {
        LogWrapper.i(TAG, "[Beauty  ]isAnimationTagExist,tag: " + tag);
        for (EffectFilterObj obj : this.mEffectFilterList) {
            if (!obj.tag.equals(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean isUseArJoyPK() {
        return this.mIsUseArPK;
    }

    public void applyEffect(GLTexture inputTexture, GLTexture outputTexture, int width, int height, OrangeFilter.OF_FrameData ofFrameData, boolean hasFace) {
        this.prepareEffect();
        if (this.mEffectFilterList.size() > 0) {
            if (height > width) {
                this.mDefaultFrameData.faceFrameDataArr[0].facePoints = this.defaultFacePointsPortrait;
                this.mDefaultFrameData.faceFrameDataArr[0].openMouthIntensity = 0.0f;
            } else {
                this.mDefaultFrameData.faceFrameDataArr[0].facePoints = this.defaultFacePointsHorizontal;
                this.mDefaultFrameData.faceFrameDataArr[0].openMouthIntensity = 0.0f;
            }
            for (EffectFilterObj obj : this.mEffectFilterList) {
                int result;
                if (obj.effectFilterId == 0) continue;
                if (!hasFace) {
                    OrangeFilterWrapper.checkTextureId((GLTexture)inputTexture, (GLTexture)outputTexture);
                    OrangeFilter.prepareFrameData((int)this.mOfContextId, (int)width, (int)height, (OrangeFilter.OF_FrameData)this.mDefaultFrameData);
                    result = OrangeFilter.applyEffect((int)this.mOfContextId, (int)obj.effectFilterId, (int)inputTexture.getTextureId(), (int)3553, (int)outputTexture.getTextureId(), (int)3553, (int)0, (int)0, (int)width, (int)height, (OrangeFilter.OF_FrameData)this.mDefaultFrameData);
                    OrangeFilterWrapper.swap((GLTexture)inputTexture, (GLTexture)outputTexture);
                } else {
                    OrangeFilterWrapper.checkTextureId((GLTexture)inputTexture, (GLTexture)outputTexture);
                    result = OrangeFilter.applyEffect((int)this.mOfContextId, (int)obj.effectFilterId, (int)inputTexture.getTextureId(), (int)3553, (int)outputTexture.getTextureId(), (int)3553, (int)0, (int)0, (int)width, (int)height, (OrangeFilter.OF_FrameData)ofFrameData);
                    OrangeFilterWrapper.swap((GLTexture)inputTexture, (GLTexture)outputTexture);
                }
                if (obj.result == 2 || result != 0) {
                    LogWrapper.i(TAG, "[Beauty  ] ArJoyPkRender animation tag: " + obj.tag + " , index: " + obj.index + " ,state: " + result);
                    if (this.mListener != null) {
                        this.mListener.animationCallbackBlock(obj.tag, obj.index, result);
                    }
                }
                obj.result = result;
                if (result != 7) continue;
                obj.state = FilterState.DELETE_STATE;
            }
        } else {
            this.mIsUseArPK = false;
        }
    }

    private void prepareEffect() {
        int result;
        String resDir;
        for (EffectFilterObj obj : this.mEffectFilterList) {
            if (obj.state != FilterState.CREATE_STATE) continue;
            resDir = obj.filePath.substring(0, obj.filePath.lastIndexOf("/"));
            if (obj.effectFilterId != 0) continue;
            obj.state = FilterState.NORMAL_STATE;
            obj.effectFilterId = OrangeFilter.createEffectFromFile((int)this.mOfContextId, (String)obj.filePath, (String)resDir);
            obj.result = 2;
            result = OrangeFilter.getEffectInfo((int)this.mOfContextId, (int)obj.effectFilterId, (OrangeFilter.OF_EffectInfo)this.mEffectInfo);
            if (result != 0 || this.mEffectInfo.version >= 4) continue;
            OrangeFilter.setEffectMirrorMode((int)this.mOfContextId, (int)obj.effectFilterId, (int)2);
        }
        for (EffectFilterObj obj : this.mEffectFilterList) {
            if (obj.state != FilterState.RESET_STATE) continue;
            resDir = obj.filePath.substring(0, obj.filePath.lastIndexOf("/"));
            if (obj.effectFilterId == 0) continue;
            result = OrangeFilter.updateEffectFromFile((int)this.mOfContextId, (int)obj.effectFilterId, (String)obj.filePath, (String)resDir);
            if (result != 0) {
                obj.state = FilterState.DELETE_STATE;
                LogWrapper.i(TAG, "[Beauty  ] reset effect failed, result = " + result + " ,index:" + obj.index + " ,tag:" + obj.tag);
            } else {
                obj.state = FilterState.NORMAL_STATE;
            }
            obj.result = 2;
        }
        for (int i = this.mEffectFilterList.size() - 1; i >= 0; --i) {
            EffectFilterObj obj;
            obj = this.mEffectFilterList.get(i);
            if (obj.state != FilterState.DELETE_STATE) continue;
            OrangeFilter.destroyEffect((int)this.mOfContextId, (int)obj.effectFilterId);
            obj.effectFilterId = 0;
            this.mEffectFilterList.remove(i);
        }
        Collections.sort(this.mEffectFilterList, new Comparator<EffectFilterObj>(){

            @Override
            public int compare(EffectFilterObj obj1, EffectFilterObj obj2) {
                if (obj1.index > obj2.index) {
                    return 1;
                }
                return -1;
            }
        });
    }

    private static enum FilterState {
        DELETE_STATE,
        NORMAL_STATE,
        CREATE_STATE,
        RESET_STATE;

    }

    private class EffectFilterObj {
        private int index;
        private int effectFilterId;
        private String tag;
        private String filePath;
        private int result;
        private FilterState state;

        private EffectFilterObj() {
        }
    }
}

