/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.videoeffect.thunderbolt.beauty;

import android.text.TextUtils;
import com.orangefilter.OrangeFilter;
import com.yy.mediaframework.gpuimage.custom.OrangeFilterWrapper;
import com.yy.mediaframework.gpuimage.util.GLTexture;
import java.io.File;
import java.util.ArrayList;
import tv.athena.live.component.videoeffect.PlayARGiftEffectListener;
import tv.athena.live.component.videoeffect.thunderbolt.beauty.IPreProcessListener;
import tv.athena.live.component.videoeffect.thunderbolt.util.LogWrapper;
import tv.athena.util.common.FileUtils;

public class ARGiftRender {
    private static final String TAG = "ARGiftRender";
    private float[] defaultFacePointsPortrait = new float[]{0.3783299f, 0.4481389f, 0.38033468f, 0.45937306f, 0.38267797f, 0.470578f, 0.3859322f, 0.481699f, 0.39000008f, 0.49273866f, 0.39490762f, 0.5036578f, 0.40121874f, 0.5143665f, 0.40965194f, 0.52454317f, 0.4207021f, 0.53395236f, 0.43449098f, 0.542074f, 0.4503974f, 0.54902625f, 0.4676779f, 0.55492926f, 0.4861763f, 0.5598208f, 0.5053232f, 0.56358594f, 0.52528226f, 0.56601846f, 0.545682f, 0.5667489f, 0.5658899f, 0.56594265f, 0.5822209f, 0.56355965f, 0.597283f, 0.5595044f, 0.6104485f, 0.5538593f, 0.6218553f, 0.5470726f, 0.6319448f, 0.53963065f, 0.64075977f, 0.5317266f, 0.64796764f, 0.52323496f, 0.6533689f, 0.51421964f, 0.6572754f, 0.5049623f, 0.66004705f, 0.4955756f, 0.6621234f, 0.48608607f, 0.6635395f, 0.47658834f, 0.66388017f, 0.4670044f, 0.6627766f, 0.45745412f, 0.66033417f, 0.4479703f, 0.6573656f, 0.43860206f, 0.4255925f, 0.4177904f, 0.44659987f, 0.4071285f, 0.47141385f, 0.40389094f, 0.4965995f, 0.40464383f, 0.52039593f, 0.40790367f, 0.5784631f, 0.40902424f, 0.5970696f, 0.40621614f, 0.6158809f, 0.40554324f, 0.63358444f, 0.40779448f, 0.6482744f, 0.41704732f, 0.55546045f, 0.43318456f, 0.55897355f, 0.44342202f, 0.5625317f, 0.4535717f, 0.56604314f, 0.463868f, 0.52624273f, 0.48365802f, 0.5448737f, 0.48333746f, 0.5635529f, 0.48317283f, 0.5783836f, 0.48313016f, 0.5926233f, 0.48203105f, 0.4501503f, 0.43715483f, 0.4641527f, 0.43192863f, 0.49736494f, 0.43175727f, 0.5101833f, 0.4378658f, 0.49537727f, 0.44065294f, 0.46434712f, 0.44087178f, 0.58574194f, 0.43802938f, 0.5954714f, 0.43234557f, 0.6233322f, 0.4320166f, 0.6345672f, 0.437189f, 0.6233942f, 0.44056216f, 0.59775484f, 0.44066486f, 0.44784683f, 0.4148158f, 0.47222486f, 0.41280168f, 0.49695846f, 0.41349596f, 0.5203246f, 0.41548023f, 0.5798219f, 0.4162325f, 0.59829944f, 0.41461188f, 0.6166906f, 0.41398495f, 0.633972f, 0.4151658f, 0.48071802f, 0.42994732f, 0.47995207f, 0.44190836f, 0.48019087f, 0.43654212f, 0.60930055f, 0.43043923f, 0.61065805f, 0.4416253f, 0.61003983f, 0.43661585f, 0.53292966f, 0.4355444f, 0.57065785f, 0.43559495f, 0.5258201f, 0.4637436f, 0.5877376f, 0.46265563f, 0.5147546f, 0.47579306f, 0.59957737f, 0.47469988f, 0.5084598f, 0.5143722f, 0.53054714f, 0.5042134f, 0.55536836f, 0.49820766f, 0.56714356f, 0.49773997f, 0.5781024f, 0.49696016f, 0.59634215f, 0.5031259f, 0.6085195f, 0.5131235f, 0.59832156f, 0.5179404f, 0.5821847f, 0.5224041f, 0.5666857f, 0.52387893f, 0.5459474f, 0.5231123f, 0.52071977f, 0.51798135f, 0.5161898f, 0.51382416f, 0.5410154f, 0.51040107f, 0.5668808f, 0.5093938f, 0.5848938f, 0.5096954f, 0.6018912f, 0.51254606f, 0.5844668f, 0.5101353f, 0.5665585f, 0.51005983f, 0.5410537f, 0.5108182f, 0.48019266f, 0.43653432f, 0.6100543f, 0.43662137f};
    private float[] defaultFacePointsHorizontal = new float[]{0.58022785f, 0.43531638f, 0.5811865f, 0.45375162f, 0.58173144f, 0.47236535f, 0.5814883f, 0.49095917f, 0.5805661f, 0.5095363f, 0.5791651f, 0.5279598f, 0.57740015f, 0.54636407f, 0.5751008f, 0.5644423f, 0.57187825f, 0.5819927f, 0.56742847f, 0.59860754f, 0.5617038f, 0.6136977f, 0.55493146f, 0.6271988f, 0.54736805f, 0.63937414f, 0.5390636f, 0.6498949f, 0.52983797f, 0.6578046f, 0.51985615f, 0.66269714f, 0.5095286f, 0.66484916f, 0.49822456f, 0.66409475f, 0.48696154f, 0.6609318f, 0.4760748f, 0.65474164f, 0.46574485f, 0.6462851f, 0.4558652f, 0.63598394f, 0.44683617f, 0.6239166f, 0.438738f, 0.6099816f, 0.43199933f, 0.5941386f, 0.42693365f, 0.57627666f, 0.4233111f, 0.55741173f, 0.42073047f, 0.537894f, 0.4187637f, 0.5181796f, 0.41716194f, 0.49833632f, 0.4160341f, 0.47839397f, 0.41553068f, 0.4583413f, 0.41530186f, 0.43825924f, 0.5711998f, 0.3887648f, 0.5619238f, 0.3698877f, 0.55002296f, 0.36361763f, 0.53750956f, 0.36413744f, 0.52544606f, 0.36953914f, 0.4905256f, 0.36733508f, 0.47717512f, 0.36069557f, 0.4630015f, 0.35896826f, 0.4489692f, 0.3649236f, 0.43750787f, 0.38347676f, 0.5095703f, 0.41362298f, 0.5104743f, 0.4335662f, 0.51136297f, 0.45343137f, 0.51220524f, 0.473573f, 0.5297057f, 0.5092771f, 0.52042216f, 0.5095716f, 0.510991f, 0.5098291f, 0.5004577f, 0.50850177f, 0.48992336f, 0.5082992f, 0.56057346f, 0.42406335f, 0.5535067f, 0.4130839f, 0.5358702f, 0.41342708f, 0.5297325f, 0.42502716f, 0.5373257f, 0.43023002f, 0.5534495f, 0.43042803f, 0.48464215f, 0.4229409f, 0.4778754f, 0.41038552f, 0.45868057f, 0.4087208f, 0.45047617f, 0.4191745f, 0.45826846f, 0.42668423f, 0.4759947f, 0.42762282f, 0.5616728f, 0.38337716f, 0.5500939f, 0.3795482f, 0.5379192f, 0.37993693f, 0.5260321f, 0.38262525f, 0.48992878f, 0.38066092f, 0.4768436f, 0.37657768f, 0.46306527f, 0.37503383f, 0.4494298f, 0.37852877f, 0.5446352f, 0.40948403f, 0.5454372f, 0.43234852f, 0.54506224f, 0.42226923f, 0.46841425f, 0.40557963f, 0.4671111f, 0.42929807f, 0.4676435f, 0.4188623f, 0.51965725f, 0.41931054f, 0.49715716f, 0.41831347f, 0.5280537f, 0.4723065f, 0.4910316f, 0.47148615f, 0.5350639f, 0.49564454f, 0.48367804f, 0.49371678f, 0.5400845f, 0.5674862f, 0.53049004f, 0.549325f, 0.51845765f, 0.5374708f, 0.51136506f, 0.5395354f, 0.5039257f, 0.5387813f, 0.48945427f, 0.54745126f, 0.47639263f, 0.5638314f, 0.4840721f, 0.5728426f, 0.49822158f, 0.5838225f, 0.51065403f, 0.58671093f, 0.5213822f, 0.585124f, 0.533576f, 0.5756223f, 0.53531694f, 0.56660897f, 0.52351016f, 0.56030756f, 0.51099646f, 0.5591687f, 0.4959575f, 0.558986f, 0.48148048f, 0.5635361f, 0.49605393f, 0.5614205f, 0.51096195f, 0.56216043f, 0.52335036f, 0.5628027f, 0.54506886f, 0.42228097f, 0.46764523f, 0.418848f};
    private OrangeFilter.OF_FrameData mDefaultFrameData = new OrangeFilter.OF_FrameData();
    private boolean mIsUseGift = false;
    private String mCurrentGiftEffectFilePath;
    private IPreProcessListener mListener;
    private int mEffectFilterArGift = 0;
    private OrangeFilter.OF_EffectInfo mEffectInfo = null;
    private boolean mNeedDefaultFace = true;
    private int mOfContextId;
    private PlayARGiftEffectListener mPlayARGiftEffectListener = null;

    public ARGiftRender(int ofContex) {
        this.mOfContextId = ofContex;
        this.mDefaultFrameData.faceFrameDataArr = new OrangeFilter.OF_FaceFrameData[1];
        this.mDefaultFrameData.faceFrameDataArr[0] = new OrangeFilter.OF_FaceFrameData();
        this.mEffectInfo = new OrangeFilter.OF_EffectInfo();
    }

    public void destroy() {
        if (this.mEffectFilterArGift != 0) {
            OrangeFilter.destroyEffect((int)this.mOfContextId, (int)this.mEffectFilterArGift);
            this.mEffectFilterArGift = 0;
            this.mCurrentGiftEffectFilePath = null;
        }
    }

    public void applyEffect(GLTexture inputTexture, GLTexture outputTexture, int width, int height, OrangeFilter.OF_FrameData ofFrameData, boolean hasFace) {
        if (this.mIsUseGift) {
            if (height > width) {
                this.mDefaultFrameData.faceFrameDataArr[0].facePoints = this.defaultFacePointsPortrait;
                this.mDefaultFrameData.faceFrameDataArr[0].openMouthIntensity = 0.0f;
            } else {
                this.mDefaultFrameData.faceFrameDataArr[0].facePoints = this.defaultFacePointsHorizontal;
                this.mDefaultFrameData.faceFrameDataArr[0].openMouthIntensity = 0.0f;
            }
            int result = 0;
            if (!hasFace) {
                OrangeFilterWrapper.checkTextureId((GLTexture)inputTexture, (GLTexture)outputTexture);
                OrangeFilter.prepareFrameData((int)this.mOfContextId, (int)width, (int)height, (OrangeFilter.OF_FrameData)(this.mNeedDefaultFace ? this.mDefaultFrameData : null));
                result = OrangeFilter.applyEffect((int)this.mOfContextId, (int)this.mEffectFilterArGift, (int)inputTexture.getTextureId(), (int)3553, (int)outputTexture.getTextureId(), (int)3553, (int)0, (int)0, (int)width, (int)height, (OrangeFilter.OF_FrameData)(this.mNeedDefaultFace ? this.mDefaultFrameData : null));
                OrangeFilterWrapper.swap((GLTexture)inputTexture, (GLTexture)outputTexture);
            } else {
                OrangeFilterWrapper.checkTextureId((GLTexture)inputTexture, (GLTexture)outputTexture);
                result = OrangeFilter.applyEffect((int)this.mOfContextId, (int)this.mEffectFilterArGift, (int)inputTexture.getTextureId(), (int)3553, (int)outputTexture.getTextureId(), (int)3553, (int)0, (int)0, (int)width, (int)height, (OrangeFilter.OF_FrameData)ofFrameData);
                OrangeFilterWrapper.swap((GLTexture)inputTexture, (GLTexture)outputTexture);
            }
            if (result != 0) {
                LogWrapper.i(TAG, "[Beauty  ]ar gift stop : " + result);
                this.mIsUseGift = false;
                if (this.mListener != null) {
                    this.mListener.onPreProcessStatus(5);
                }
                if (this.mPlayARGiftEffectListener != null) {
                    String callBackPath = this.mCurrentGiftEffectFilePath;
                    this.destroy();
                    this.mPlayARGiftEffectListener.onComplete(callBackPath);
                }
            }
        }
    }

    public void setNeedDefaultFace(boolean need) {
        LogWrapper.i(TAG, "[Beauty  ]setNeedDefaultFace: " + need);
        this.mNeedDefaultFace = need;
    }

    public void setGiftEffect(String effectFile) {
        LogWrapper.i(TAG, "[Beauty  ]setGiftEffect: " + effectFile);
        if (effectFile != null && !this.mIsUseGift) {
            if (effectFile.equals(this.mCurrentGiftEffectFilePath)) {
                LogWrapper.i(TAG, "[Beauty  ]restart ar gift.....");
                OrangeFilter.restartEffectAnimation((int)this.mOfContextId, (int)this.mEffectFilterArGift);
            } else {
                LogWrapper.i(TAG, "[Beauty  ]update ar gift effect.....");
                String resDir = effectFile.substring(0, effectFile.lastIndexOf("/"));
                if (this.mEffectFilterArGift == 0) {
                    this.mEffectFilterArGift = OrangeFilter.createEffectFromFile((int)this.mOfContextId, (String)effectFile, (String)resDir);
                } else {
                    OrangeFilter.updateEffectFromFile((int)this.mOfContextId, (int)this.mEffectFilterArGift, (String)effectFile, (String)resDir);
                }
                int result = OrangeFilter.getEffectInfo((int)this.mOfContextId, (int)this.mEffectFilterArGift, (OrangeFilter.OF_EffectInfo)this.mEffectInfo);
                LogWrapper.i(TAG, "[Beauty  ]result =" + result + ",mEffectFilterArGift =" + this.mEffectFilterArGift + ",mOfContextId =" + this.mOfContextId);
                if (this.mEffectFilterArGift == 0) {
                    LogWrapper.i(TAG, "[Beauty  ]result != OrangeFilter.OF_Result_Success");
                    this.mPlayARGiftEffectListener = null;
                    return;
                }
                if (result == 0 && this.mEffectInfo.version < 4) {
                    OrangeFilter.setEffectMirrorMode((int)this.mOfContextId, (int)this.mEffectFilterArGift, (int)1);
                }
                this.mIsUseGift = true;
                this.mCurrentGiftEffectFilePath = effectFile;
            }
        }
    }

    public boolean isUseArGift() {
        return this.mIsUseGift;
    }

    public void setListener(IPreProcessListener listener) {
        this.mListener = listener;
    }

    public void playARGiftEffect(String effectResDir, PlayARGiftEffectListener listener) {
        if (TextUtils.isEmpty((CharSequence)effectResDir)) {
            LogWrapper.i(TAG, "playARGiftEffect effectResDir is empty");
            return;
        }
        if (!FileUtils.isFileExists((String)effectResDir)) {
            LogWrapper.i(TAG, "playARGiftEffect effectResDir is not exists");
            return;
        }
        String effectFile = this.findEffectPath(effectResDir);
        if (TextUtils.isEmpty((CharSequence)effectFile)) {
            LogWrapper.i(TAG, "playARGiftEffect effectFile is empty");
            return;
        }
        if (!FileUtils.isFileExists((String)effectFile)) {
            LogWrapper.i(TAG, "playARGiftEffect effectFile is not exists");
            return;
        }
        this.mPlayARGiftEffectListener = listener;
        this.setGiftEffect(effectFile);
    }

    private String findEffectPath(String effectResDir) {
        try {
            if (TextUtils.isEmpty((CharSequence)effectResDir)) {
                LogWrapper.i(TAG, "findEffectPath effectResDir is empty");
                return null;
            }
            ArrayList<File> files = this.getListFiles(effectResDir);
            if (files == null || files.isEmpty()) {
                LogWrapper.i(TAG, "findEffectPath effectResDir files == null || files.isEmpty()");
            }
            for (File file : files) {
                String absolutePath = file.getAbsolutePath();
                if (!absolutePath.endsWith(".ofeffect")) continue;
                LogWrapper.i(TAG, "findEffectPath effectResDir ofeffect path =" + absolutePath);
                return absolutePath;
            }
        }
        catch (Exception e) {
            LogWrapper.e(TAG, "findEffectPath", e);
        }
        return null;
    }

    private ArrayList<File> getListFiles(Object obj) {
        File directory = null;
        directory = obj instanceof File ? (File)obj : new File(obj.toString());
        ArrayList<File> files = new ArrayList<File>();
        if (directory.isFile()) {
            files.add(directory);
            return files;
        }
        if (directory.isDirectory()) {
            File[] fileArr = directory.listFiles();
            for (int i = 0; i < fileArr.length; ++i) {
                File fileOne = fileArr[i];
                files.addAll(this.getListFiles(fileOne));
            }
        }
        return files;
    }

    public void setFacePoints(float[] facePointsPortrait, float[] facePointsHorizontal) {
        this.defaultFacePointsPortrait = facePointsPortrait;
        this.defaultFacePointsHorizontal = facePointsHorizontal;
    }
}

