/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.videoeffect.thunderbolt;

import android.arch.lifecycle.Observer;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.thunder.livesdk.video.IVideoCaptureObserver;
import java.io.File;
import java.io.FilenameFilter;
import tv.athena.live.basesdk.thunderblotwrapper.ThunderHandleManager;
import tv.athena.live.component.videoeffect.render.VideoEffectConfig;
import tv.athena.live.component.videoeffect.thunderbolt.beauty.AssetsFileHelper;
import tv.athena.live.component.videoeffect.thunderbolt.beauty.FileSnapshotHelper;
import tv.athena.live.component.videoeffect.thunderbolt.face.FaceDetectionProducer;
import tv.athena.live.component.videoeffect.thunderbolt.face.VenusMobileFaceDetectionWrapper;
import tv.athena.live.component.videoeffect.thunderbolt.util.LogWrapper;
import tv.athena.live.utils.UnzipFileUtil;
import tv.athena.live.vsprotocol.ATHFaceDetectionResult;
import tv.athena.util.RuntimeInfo;
import tv.athena.util.taskexecutor.CoroutinesTask;

public class FaceDetectionConsumer {
    protected static final String TAG = "FaceDetectionConsumer";
    private Context mContext;
    private VideoEffectConfig mVideoEffectConfig;
    private VenusMobileFaceDetectionWrapper mFaceDetection;

    public FaceDetectionConsumer(Context context, VideoEffectConfig config) {
        this.mContext = context.getApplicationContext();
        this.mVideoEffectConfig = config;
        this.mFaceDetection = new VenusMobileFaceDetectionWrapper(this.mContext);
        if (config.getFaceModeArray() != null) {
            this.initFaceModelFromGiving(config.getFaceModeArray());
        } else if (!TextUtils.isEmpty((CharSequence)this.mVideoEffectConfig.getFaceModelInitFromAssetsPath())) {
            this.initFaceModelFromAssetsIfNeed();
        }
    }

    private void initFaceModelFromGiving(String[] faceModePathArray) {
        for (String str : faceModePathArray) {
            LogWrapper.i(TAG, "->" + str);
        }
        this.mFaceDetection.setFaceModelPathOption(faceModePathArray);
        LogWrapper.i(TAG, "setFaceModelSize: " + faceModePathArray.length + ", FaceDetection.init()");
        this.mFaceDetection.init();
    }

    private void initFaceModelFromAssetsIfNeed() {
        String faceModeDataPath = RuntimeInfo.sAppContext.getCacheDir().getPath() + "/venusFaceData_" + this.mVideoEffectConfig.getFaceModelInitVersion();
        new CoroutinesTask(coroutineScope -> {
            if (FileSnapshotHelper.checkSnapshot(faceModeDataPath)) {
                LogWrapper.i(TAG, "faceModeData {" + faceModeDataPath + "} is exist, ignore copy");
            } else {
                try {
                    FaceDetectionConsumer.deleteAllFiles(new File(faceModeDataPath));
                    String zipFrom = this.mVideoEffectConfig.getFaceModelInitFromAssetsPath();
                    AssetsFileHelper.copyFilesFromAssets(this.mContext, zipFrom, faceModeDataPath);
                    String targetZipName = zipFrom.substring(zipFrom.lastIndexOf("/") + 1);
                    String targetZipPath = faceModeDataPath + "/" + targetZipName;
                    if (!new File(targetZipPath).exists()) {
                        LogWrapper.e(TAG, "FaceMode zip not exist: " + targetZipPath);
                        return null;
                    }
                    boolean zipResult = UnzipFileUtil.unZip((String)targetZipPath, (String)faceModeDataPath);
                    if (!zipResult) {
                        LogWrapper.e(TAG, "FaceMode unzip failed: " + targetZipPath);
                        return null;
                    }
                    FileSnapshotHelper.DirSnapshot dirSnapshot = FileSnapshotHelper.createFileSnapshot(faceModeDataPath);
                    LogWrapper.i(TAG, "faceModeData copy end\n" + dirSnapshot);
                }
                catch (Exception e) {
                    LogWrapper.i(TAG, "faceModeData copy error\n" + Log.getStackTraceString((Throwable)e));
                    return null;
                }
            }
            File file = new File(faceModeDataPath);
            FilenameFilter filenameFilter = (dir, fileName) -> fileName != null && fileName.endsWith(".vnmodel");
            return file.listFiles(filenameFilter);
        }).runOn(CoroutinesTask.BG).responseOn(CoroutinesTask.UI).onResponse(faceModelFiles -> {
            if (this.mFaceDetection != null && faceModelFiles != null && ((File[])faceModelFiles).length > 0) {
                if (((File[])faceModelFiles).length == 7) {
                    String[] faceModePathArray;
                    for (String str : faceModePathArray = new String[]{faceModeDataPath + "/model0.vnmodel", faceModeDataPath + "/model1.vnmodel", faceModeDataPath + "/model2.vnmodel", faceModeDataPath + "/model3.vnmodel", faceModeDataPath + "/model4.vnmodel", faceModeDataPath + "/model5.vnmodel", faceModeDataPath + "/model6.vnmodel"}) {
                        LogWrapper.i(TAG, "->" + str);
                    }
                    this.mFaceDetection.setFaceModelPathOption(faceModePathArray);
                    LogWrapper.i(TAG, "setFaceModelSize: " + faceModePathArray.length + ", FaceDetection.init()");
                    this.mFaceDetection.init();
                } else {
                    LogWrapper.i(TAG, "Face model count < 7, Ignore initVenus");
                }
            } else {
                LogWrapper.i(TAG, "Face model copy failed, Ignore initVenus");
            }
            return null;
        }).runDelay(1000L);
    }

    private static int extractNumber(String name) {
        int i;
        try {
            String number = name.replaceAll("[^\\d]", "");
            i = Integer.parseInt(number);
        }
        catch (Exception e) {
            i = 0;
        }
        return i;
    }

    private static void deleteAllFiles(File root) {
        if (root == null || !root.exists()) {
            return;
        }
        File[] files = root.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    FaceDetectionConsumer.deleteAllFiles(file);
                    continue;
                }
                if (!file.exists()) continue;
                file.delete();
            }
        }
        root.delete();
    }

    public void start() {
        if (this.mFaceDetection != null) {
            ThunderHandleManager.INSTANCE.getMYYLiveRtcEngine().registerVideoCaptureFrameObserver((IVideoCaptureObserver)this.mFaceDetection);
            LogWrapper.i(TAG, "*** FaceDetection.start() ***");
        } else {
            LogWrapper.w(TAG, "Ignore start, mFaceDetection is released");
        }
    }

    public void stop() {
        if (this.mFaceDetection != null) {
            ThunderHandleManager.INSTANCE.getMYYLiveRtcEngine().registerVideoCaptureFrameObserver(null);
            LogWrapper.i(TAG, "*** FaceDetection.stop() ***");
        }
    }

    public void destroy() {
        if (this.mFaceDetection != null) {
            LogWrapper.i(TAG, "FaceDetection release");
            this.stop();
            this.mFaceDetection.deInit();
            this.mFaceDetection = null;
        }
    }

    public FaceDetectionProducer getFaceDetectionProducer() {
        return this.mFaceDetection;
    }

    public void observeFaceFrameData(Observer<ATHFaceDetectionResult> observer) {
        if (this.mFaceDetection != null) {
            this.mFaceDetection.observeFaceFrameData(observer);
        }
    }

    public void removeObserveFaceFrameData(Observer<ATHFaceDetectionResult> observer) {
        if (this.mFaceDetection != null) {
            this.mFaceDetection.removeObserveFaceFrameData(observer);
        }
    }
}

