/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.videoeffect.thunderbolt;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.yy.mediaframework.gpuimage.custom.IGPUProcess;
import tv.athena.live.basesdk.thunderblotwrapper.ThunderHandleManager;
import tv.athena.live.component.videoeffect.PlayARGiftEffectListener;
import tv.athena.live.component.videoeffect.render.EffectRender;
import tv.athena.live.component.videoeffect.render.VideoEffectConfig;
import tv.athena.live.component.videoeffect.thunderbolt.beauty.ARGiftRender;
import tv.athena.live.component.videoeffect.thunderbolt.beauty.GPUImageBeautyOrangeFilter;
import tv.athena.live.component.videoeffect.thunderbolt.beauty.IOrangeFilterStatus;
import tv.athena.live.component.videoeffect.thunderbolt.beauty.IPreProcessListener;
import tv.athena.live.component.videoeffect.thunderbolt.face.FaceDetectionProducer;
import tv.athena.live.component.videoeffect.thunderbolt.util.LogWrapper;

public class FaceBeautyConsumer {
    protected static final String TAG = "FaceBeautyConsumer";
    private GPUImageBeautyOrangeFilter mGpuBeauty;
    private EffectRender mCacheThunderRender;
    private float mBeautyFilter6Param = 0.0f;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private VideoEffectConfig mVideoEffectConfig;
    private FaceDetectionProducer mFaceDetectionProducer;

    public FaceBeautyConsumer(@NonNull VideoEffectConfig config) {
        this.mVideoEffectConfig = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LogWrapper.i(TAG, "*** FaceBeautyConsumer.start() ***");
        this.mGpuBeauty = new GPUImageBeautyOrangeFilter();
        FaceBeautyConsumer faceBeautyConsumer = this;
        synchronized (faceBeautyConsumer) {
            if (this.mGpuBeauty == null) {
                LogWrapper.i(TAG, "start()--------mGpuBeauty == null");
                return;
            }
            this.mGpuBeauty.setIsCropOF(this.mVideoEffectConfig.getIsCropOFVersion());
            this.mGpuBeauty.setPhonePerformanceLevel(this.mVideoEffectConfig.getPerformanceLevel());
            this.mGpuBeauty.setFaceDetectionProducer(this.mFaceDetectionProducer);
            ThunderHandleManager.INSTANCE.getMYYLiveRtcEngine().registerVideoCaptureTextureObserver((IGPUProcess)this.mGpuBeauty);
            this.mGpuBeauty.setOrangeFilterStatus(new IOrangeFilterStatus(){

                @Override
                public void finishInit() {
                    LogWrapper.i(FaceBeautyConsumer.TAG, " === mGpuBeauty finishInit() === ");
                    if (FaceBeautyConsumer.this.mCacheThunderRender != null && FaceBeautyConsumer.this.mGpuBeauty != null) {
                        FaceBeautyConsumer.this.consume(FaceBeautyConsumer.this.mCacheThunderRender);
                        FaceBeautyConsumer.this.setFilterBeauty6Param(FaceBeautyConsumer.this.mBeautyFilter6Param);
                    }
                }

                @Override
                public void destroy() {
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LogWrapper.i(TAG, "*** FaceBeautyConsumer.stop() ***");
        ThunderHandleManager.INSTANCE.getMYYLiveRtcEngine().registerVideoCaptureTextureObserver(null);
        FaceBeautyConsumer faceBeautyConsumer = this;
        synchronized (faceBeautyConsumer) {
            this.mGpuBeauty = null;
        }
        this.mCacheThunderRender = null;
    }

    public void destroy() {
        this.stop();
        LogWrapper.i(TAG, "*** FaceBeautyConsumer.destroy() ***");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVideoEffectListener(IPreProcessListener listener) {
        FaceBeautyConsumer faceBeautyConsumer = this;
        synchronized (faceBeautyConsumer) {
            if (this.mGpuBeauty != null) {
                this.mGpuBeauty.setListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFaceDetectionProducer(FaceDetectionProducer faceDetectionProducer) {
        this.mFaceDetectionProducer = faceDetectionProducer;
        FaceBeautyConsumer faceBeautyConsumer = this;
        synchronized (faceBeautyConsumer) {
            if (this.mGpuBeauty != null) {
                this.mGpuBeauty.setFaceDetectionProducer(faceDetectionProducer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(EffectRender thunderRender) {
        FaceBeautyConsumer faceBeautyConsumer = this;
        synchronized (faceBeautyConsumer) {
            if (this.mGpuBeauty == null) {
                LogWrapper.i(TAG, "GpuBeauty null");
                this.mCacheThunderRender = thunderRender;
                return;
            }
            if (thunderRender == null) {
                this.mGpuBeauty.setStickerDirPath(null);
                this.mGpuBeauty.setLookupTable("");
                this.mGpuBeauty.setBeautyParam(0.0f);
                this.mGpuBeauty.setFaceLiftValue(null);
                this.mGpuBeauty.setFaceLiftValueOpt(null);
                LogWrapper.i(TAG, "consume null param");
                return;
            }
            this.mCacheThunderRender = null;
            LogWrapper.i(TAG, "consume->" + thunderRender);
            if (!"invalid".equals(thunderRender.stickerDirPath)) {
                this.mGpuBeauty.setStickerDirPath(thunderRender.stickerDirPath);
            }
            if (!"invalid".equals(thunderRender.beauty5EffectPath)) {
                // empty if block
            }
            if (!"invalid".equals(thunderRender.lookupTablePath)) {
                this.mGpuBeauty.setLookupTable(thunderRender.lookupTablePath);
            }
            if (thunderRender.thinFaceParam != -1.0f) {
                this.mGpuBeauty.setThinFaceParam(thunderRender.thinFaceParam);
            }
            if (thunderRender.lookupTableParam != -1.0f) {
                this.mGpuBeauty.setLookupTableParam(thunderRender.lookupTableParam);
            }
            if (thunderRender.beautyParam != -1.0f) {
                this.mGpuBeauty.setBeautyParam(thunderRender.beautyParam);
            }
            if (thunderRender.thinFaceParam != -1.0f) {
                this.mGpuBeauty.setThinFaceParam(thunderRender.thinFaceParam);
            }
            if (thunderRender.faceLiftValueOpt != null) {
                this.mGpuBeauty.setFaceLiftValueOpt(thunderRender.faceLiftValueOpt);
            } else if (thunderRender.faceLiftValue != null) {
                this.mGpuBeauty.setFaceLiftValue(thunderRender.faceLiftValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilterBeauty6Param(float param) {
        FaceBeautyConsumer faceBeautyConsumer = this;
        synchronized (faceBeautyConsumer) {
            if (this.mGpuBeauty == null) {
                LogWrapper.i(TAG, "setFilterBeauty6Param gpuBeauty mGpuBeauty = null");
                this.mBeautyFilter6Param = param;
                return;
            }
            this.mGpuBeauty.setFilterBeauty6Param(param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playARGiftEffect(String effectResDir, PlayARGiftEffectListener listener) {
        FaceBeautyConsumer faceBeautyConsumer = this;
        synchronized (faceBeautyConsumer) {
            if (this.mGpuBeauty == null) {
                LogWrapper.i(TAG, "playARGiftEffect gpuBeauty mGpuBeauty = null");
                return;
            }
            ARGiftRender arGiftRender = this.mGpuBeauty.getARGiftRender();
            if (arGiftRender == null) {
                LogWrapper.i(TAG, "playARGiftEffect arGiftRender = null");
                return;
            }
            arGiftRender.playARGiftEffect(effectResDir, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNeedDefaultFace(boolean need) {
        FaceBeautyConsumer faceBeautyConsumer = this;
        synchronized (faceBeautyConsumer) {
            if (this.mGpuBeauty == null) {
                LogWrapper.i(TAG, "setNeedDefaultFace gpuBeauty mGpuBeauty = null");
                return;
            }
            ARGiftRender arGiftRender = this.mGpuBeauty.getARGiftRender();
            if (arGiftRender == null) {
                LogWrapper.i(TAG, "setNeedDefaultFace arGiftRender = null");
                return;
            }
            arGiftRender.setNeedDefaultFace(need);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacePoints(float[] facePointsPortrait, float[] facePointsHorizontal) {
        FaceBeautyConsumer faceBeautyConsumer = this;
        synchronized (faceBeautyConsumer) {
            if (this.mGpuBeauty == null) {
                LogWrapper.i(TAG, "setFacePoints gpuBeauty mGpuBeauty = null");
                return;
            }
            ARGiftRender arGiftRender = this.mGpuBeauty.getARGiftRender();
            if (arGiftRender == null) {
                LogWrapper.i(TAG, "setFacePoints arGiftRender = null");
                return;
            }
            arGiftRender.setFacePoints(facePointsPortrait, facePointsHorizontal);
        }
    }
}

