/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.videoeffect;

import android.arch.lifecycle.Observer;
import android.text.TextUtils;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.annotation.ServiceRegister;
import tv.athena.live.basesdk.config.BaseDataConfig;
import tv.athena.live.component.videoeffect.IVideoEffectService;
import tv.athena.live.component.videoeffect.PerformanceLevel;
import tv.athena.live.component.videoeffect.PlayARGiftEffectListener;
import tv.athena.live.component.videoeffect.VideoEffectManager;
import tv.athena.live.component.videoeffect.render.EffectRender;
import tv.athena.live.component.videoeffect.render.VideoEffectConfig;
import tv.athena.live.component.videoeffect.thunderbolt.util.LogWrapper;
import tv.athena.live.utils.ALog;
import tv.athena.live.vsprotocol.ATHFaceDetectionResult;
import tv.athena.live.vsprotocol.IATHCustomVideoEffectHandler;
import tv.athena.live.vsprotocol.IATHPlayARGiftEffectListener;
import tv.athena.util.RuntimeInfo;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0002J\b\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u001a\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0006H\u0002J\u0016\u0010\u001c\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0012\u0010\u001d\u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004H\u0016J\u0018\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\rH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Ltv/athena/live/component/videoeffect/VideoEffectServiceImpl;", "Ltv/athena/live/component/videoeffect/IVideoEffectService;", "()V", "mCustomVideoEffectHandler", "Ltv/athena/live/vsprotocol/IATHCustomVideoEffectHandler;", "consumeEffect", "", "effectRender", "Ltv/athena/live/component/videoeffect/render/EffectRender;", "createDynamicBeauty", "deInit", "enableDynamicBeauty", "enable", "", "handleConsumeEffect", "init", "config", "Ltv/athena/live/component/videoeffect/render/VideoEffectConfig;", "observeFaceFrameData", "observer", "Landroid/arch/lifecycle/Observer;", "Ltv/athena/live/vsprotocol/ATHFaceDetectionResult;", "playARGiftEffect", "effectResDir", "", "listener", "Ltv/athena/live/component/videoeffect/PlayARGiftEffectListener;", "removeDynamicBeauty", "removeObserveFaceFrameData", "setCustomVideoEffectHandler", "customVideoEffectHandler", "setFacePoints", "facePointsPortrait", "", "facePointsHorizontal", "setFilterBeauty6Param", "param", "", "setNeedDefaultFace", "need", "Companion", "videoeffect_release"})
@ServiceRegister(serviceInterface=IVideoEffectService.class)
public final class VideoEffectServiceImpl
implements IVideoEffectService {
    private IATHCustomVideoEffectHandler mCustomVideoEffectHandler;
    @NotNull
    public static final String TAG = "VideoEffectServiceImpl";
    @Nullable
    private static VideoEffectManager sVideoEffectManager;
    private static boolean sEnableDynamicBeauty;
    private static int sDynamicBeautyEffectId;
    public static final Companion Companion;

    public void init() {
        this.init(Companion.createDefaultConfig());
    }

    public void init(@NotNull VideoEffectConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.deInit();
        LogWrapper.i(TAG, "init: " + config);
        sVideoEffectManager = new VideoEffectManager(RuntimeInfo.getSAppContext(), config);
    }

    public void deInit() {
        LogWrapper.i(TAG, "deInit");
        if (sVideoEffectManager != null) {
            VideoEffectManager videoEffectManager = sVideoEffectManager;
            if (videoEffectManager == null) {
                Intrinsics.throwNpe();
            }
            videoEffectManager.destroy();
        }
    }

    public void consumeEffect(@NotNull EffectRender effectRender) {
        block1: {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)effectRender, (String)"effectRender");
                LogWrapper.i(TAG, "consumeEffect");
                if (this.mCustomVideoEffectHandler == null) break block0;
                this.handleConsumeEffect(effectRender);
                break block1;
            }
            VideoEffectManager videoEffectManager = sVideoEffectManager;
            if (videoEffectManager == null) break block1;
            videoEffectManager.consumeFaceEffect(effectRender);
        }
    }

    private final void handleConsumeEffect(EffectRender effectRender) {
        block9: {
            IATHCustomVideoEffectHandler iATHCustomVideoEffectHandler = this.mCustomVideoEffectHandler;
            if (iATHCustomVideoEffectHandler == null) break block9;
            IATHCustomVideoEffectHandler iATHCustomVideoEffectHandler2 = iATHCustomVideoEffectHandler;
            boolean bl = false;
            boolean bl2 = false;
            IATHCustomVideoEffectHandler it = iATHCustomVideoEffectHandler2;
            boolean bl3 = false;
            if (effectRender.faceLiftValueOpt != null) {
                LogWrapper.i(TAG, "handleConsumeEffect effectRender.faceLiftValueOpt =" + effectRender.faceLiftValueOpt);
                it.setFaceLiftValueOpt(effectRender.faceLiftValueOpt);
            } else if (effectRender.faceLiftValue != null) {
                LogWrapper.i(TAG, "handleConsumeEffect effectRender.faceLiftValue =" + effectRender.faceLiftValue);
                it.setFaceLiftValue(effectRender.faceLiftValue);
            }
            if (Intrinsics.areEqual((Object)"invalid", (Object)effectRender.lookupTablePath) ^ true) {
                LogWrapper.i(TAG, "handleConsumeEffect lookupTablePath =" + effectRender.lookupTablePath);
                String string = effectRender.lookupTablePath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"effectRender.lookupTablePath");
                it.setLookupTablePath(string);
            }
            if (effectRender.lookupTableParam != -1.0f) {
                LogWrapper.i(TAG, "handleConsumeEffect lookupTableParam =" + effectRender.lookupTableParam);
                it.setLookupTableParam(effectRender.lookupTableParam);
            }
            if (Intrinsics.areEqual((Object)"invalid", (Object)effectRender.stickerDirPath) ^ true) {
                LogWrapper.i(TAG, "handleConsumeEffect stickerDirPath =" + effectRender.stickerDirPath);
                String string = effectRender.stickerDirPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"effectRender.stickerDirPath");
                it.setStickerDirPath(string);
            }
            if (effectRender.thinFaceParam != -1.0f) {
                LogWrapper.i(TAG, "handleConsumeEffect thinFaceParam =" + effectRender.thinFaceParam);
                if (sEnableDynamicBeauty && sDynamicBeautyEffectId != -1) {
                    boolean bl4 = false;
                    Map paramMap = new LinkedHashMap();
                    paramMap.put("1:Intensity", Float.valueOf(effectRender.thinFaceParam));
                    it.updateEffect(sDynamicBeautyEffectId, paramMap);
                } else {
                    it.setThinFaceParam(effectRender.thinFaceParam);
                }
            }
        }
    }

    public void observeFaceFrameData(@NotNull Observer<ATHFaceDetectionResult> observer) {
        block1: {
            block0: {
                Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
                LogWrapper.i(TAG, "observeFaceFrameData");
                IATHCustomVideoEffectHandler iATHCustomVideoEffectHandler = this.mCustomVideoEffectHandler;
                if (iATHCustomVideoEffectHandler == null) break block0;
                IATHCustomVideoEffectHandler iATHCustomVideoEffectHandler2 = iATHCustomVideoEffectHandler;
                boolean bl = false;
                boolean bl2 = false;
                IATHCustomVideoEffectHandler it = iATHCustomVideoEffectHandler2;
                boolean bl3 = false;
                it.observeFaceFrameData(observer);
                break block1;
            }
            VideoEffectServiceImpl videoEffectServiceImpl = this;
            boolean bl = false;
            boolean bl4 = false;
            VideoEffectServiceImpl it = videoEffectServiceImpl;
            boolean bl5 = false;
            VideoEffectManager videoEffectManager = sVideoEffectManager;
            if (videoEffectManager == null) break block1;
            videoEffectManager.observeFaceFrameData(observer);
        }
    }

    public void removeObserveFaceFrameData(@NotNull Observer<ATHFaceDetectionResult> observer) {
        block1: {
            block0: {
                Intrinsics.checkParameterIsNotNull(observer, (String)"observer");
                LogWrapper.i(TAG, "removeObserveFaceFrameData");
                IATHCustomVideoEffectHandler iATHCustomVideoEffectHandler = this.mCustomVideoEffectHandler;
                if (iATHCustomVideoEffectHandler == null) break block0;
                IATHCustomVideoEffectHandler iATHCustomVideoEffectHandler2 = iATHCustomVideoEffectHandler;
                boolean bl = false;
                boolean bl2 = false;
                IATHCustomVideoEffectHandler it = iATHCustomVideoEffectHandler2;
                boolean bl3 = false;
                it.removeObserveFaceFrameData(observer);
                break block1;
            }
            VideoEffectServiceImpl videoEffectServiceImpl = this;
            boolean bl = false;
            boolean bl4 = false;
            VideoEffectServiceImpl it = videoEffectServiceImpl;
            boolean bl5 = false;
            VideoEffectManager videoEffectManager = sVideoEffectManager;
            if (videoEffectManager == null) break block1;
            videoEffectManager.removeObserveFaceFrameData(observer);
        }
    }

    public void setFilterBeauty6Param(float param) {
        block3: {
            block2: {
                LogWrapper.i(TAG, "setFilterBeauty6Param " + param + ' ' + sEnableDynamicBeauty + ' ' + sDynamicBeautyEffectId);
                IATHCustomVideoEffectHandler iATHCustomVideoEffectHandler = this.mCustomVideoEffectHandler;
                if (iATHCustomVideoEffectHandler == null) break block2;
                IATHCustomVideoEffectHandler iATHCustomVideoEffectHandler2 = iATHCustomVideoEffectHandler;
                boolean bl = false;
                boolean bl2 = false;
                IATHCustomVideoEffectHandler it = iATHCustomVideoEffectHandler2;
                boolean bl3 = false;
                if (sEnableDynamicBeauty && sDynamicBeautyEffectId != -1) {
                    boolean bl4 = false;
                    Map paramMap = new LinkedHashMap();
                    paramMap.put("0:Opacity", Float.valueOf(param));
                    it.updateEffect(sDynamicBeautyEffectId, paramMap);
                } else {
                    it.setFilterBeautyParam(param);
                }
                break block3;
            }
            VideoEffectServiceImpl videoEffectServiceImpl = this;
            boolean bl = false;
            boolean bl5 = false;
            VideoEffectServiceImpl it = videoEffectServiceImpl;
            boolean bl6 = false;
            VideoEffectManager videoEffectManager = sVideoEffectManager;
            if (videoEffectManager == null) break block3;
            videoEffectManager.setFilterBeauty6Param(param);
        }
    }

    public void playARGiftEffect(@NotNull String effectResDir, @Nullable PlayARGiftEffectListener listener) {
        block1: {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)effectResDir, (String)"effectResDir");
                LogWrapper.i(TAG, "playARGiftEffect " + effectResDir);
                IATHCustomVideoEffectHandler iATHCustomVideoEffectHandler = this.mCustomVideoEffectHandler;
                if (iATHCustomVideoEffectHandler == null) break block0;
                IATHCustomVideoEffectHandler iATHCustomVideoEffectHandler2 = iATHCustomVideoEffectHandler;
                boolean bl = false;
                boolean bl2 = false;
                IATHCustomVideoEffectHandler it = iATHCustomVideoEffectHandler2;
                boolean bl3 = false;
                it.playARGiftEffect(effectResDir, new IATHPlayARGiftEffectListener(effectResDir, listener){
                    final /* synthetic */ String $effectResDir$inlined;
                    final /* synthetic */ PlayARGiftEffectListener $listener$inlined;
                    {
                        this.$effectResDir$inlined = string;
                        this.$listener$inlined = playARGiftEffectListener;
                    }

                    public void onComplete(@Nullable String effectPath) {
                        block0: {
                            PlayARGiftEffectListener playARGiftEffectListener = this.$listener$inlined;
                            if (playARGiftEffectListener == null) break block0;
                            playARGiftEffectListener.onComplete(effectPath);
                        }
                    }
                });
                break block1;
            }
            VideoEffectServiceImpl videoEffectServiceImpl = this;
            boolean bl = false;
            boolean bl4 = false;
            VideoEffectServiceImpl it = videoEffectServiceImpl;
            boolean bl5 = false;
            VideoEffectManager videoEffectManager = sVideoEffectManager;
            if (videoEffectManager == null) break block1;
            videoEffectManager.playARGiftEffect(effectResDir, listener);
        }
    }

    public void setNeedDefaultFace(boolean need) {
        block0: {
            LogWrapper.i(TAG, "setNeedDefaultFace " + need);
            VideoEffectManager videoEffectManager = sVideoEffectManager;
            if (videoEffectManager == null) break block0;
            videoEffectManager.setNeedDefaultFace(need);
        }
    }

    public void setFacePoints(@NotNull float[] facePointsPortrait, @NotNull float[] facePointsHorizontal) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)facePointsPortrait, (String)"facePointsPortrait");
            Intrinsics.checkParameterIsNotNull((Object)facePointsHorizontal, (String)"facePointsHorizontal");
            LogWrapper.i(TAG, "setFacePoints facePointsPortrait = " + facePointsPortrait + "  facePointsHorizontal = " + facePointsHorizontal);
            VideoEffectManager videoEffectManager = sVideoEffectManager;
            if (videoEffectManager == null) break block0;
            videoEffectManager.setFacePoints(facePointsPortrait, facePointsHorizontal);
        }
    }

    public void setCustomVideoEffectHandler(@Nullable IATHCustomVideoEffectHandler customVideoEffectHandler) {
        this.mCustomVideoEffectHandler = customVideoEffectHandler;
        this.createDynamicBeauty();
    }

    public void enableDynamicBeauty(boolean enable) {
        LogWrapper.i(TAG, "enableDynamicBeauty " + enable);
        sEnableDynamicBeauty = enable;
        if (sEnableDynamicBeauty) {
            this.createDynamicBeauty();
        } else {
            this.removeDynamicBeauty();
        }
    }

    private final void createDynamicBeauty() {
        block3: {
            BaseDataConfig.DynamicBeautyConfig config;
            BaseDataConfig.DynamicBeautyConfig dynamicBeautyConfig = config = BaseDataConfig.getDynamicBeautyConfig();
            if (dynamicBeautyConfig == null) break block3;
            BaseDataConfig.DynamicBeautyConfig dynamicBeautyConfig2 = dynamicBeautyConfig;
            boolean bl = false;
            boolean bl2 = false;
            BaseDataConfig.DynamicBeautyConfig it = dynamicBeautyConfig2;
            boolean bl3 = false;
            if (!TextUtils.isEmpty((CharSequence)it.storgePath) && new File(it.storgePath).exists() && sEnableDynamicBeauty) {
                int n;
                this.removeDynamicBeauty();
                IATHCustomVideoEffectHandler iATHCustomVideoEffectHandler = this.mCustomVideoEffectHandler;
                if (iATHCustomVideoEffectHandler != null) {
                    String string = it.storgePath;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.storgePath");
                    n = iATHCustomVideoEffectHandler.createEffectFromDirectory(string);
                } else {
                    n = -1;
                }
                sDynamicBeautyEffectId = n;
                LogWrapper.i(TAG, "createEffectFromDirectory sDynamicBeautyEffectId " + sDynamicBeautyEffectId);
            }
        }
    }

    private final void removeDynamicBeauty() {
        ALog.i((String)TAG, (String)("removeDynamicBeauty sDynamicBeautyEffectId = " + sDynamicBeautyEffectId));
        if (sDynamicBeautyEffectId > -1) {
            IATHCustomVideoEffectHandler iATHCustomVideoEffectHandler = this.mCustomVideoEffectHandler;
            if (iATHCustomVideoEffectHandler != null) {
                iATHCustomVideoEffectHandler.removeEffect(sDynamicBeautyEffectId);
            }
            sDynamicBeautyEffectId = -1;
        }
    }

    static {
        Companion = new Companion(null);
        sDynamicBeautyEffectId = -1;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Ltv/athena/live/component/videoeffect/VideoEffectServiceImpl$Companion;", "", "()V", "TAG", "", "sDynamicBeautyEffectId", "", "sEnableDynamicBeauty", "", "sVideoEffectManager", "Ltv/athena/live/component/videoeffect/VideoEffectManager;", "getSVideoEffectManager", "()Ltv/athena/live/component/videoeffect/VideoEffectManager;", "setSVideoEffectManager", "(Ltv/athena/live/component/videoeffect/VideoEffectManager;)V", "createDefaultConfig", "Ltv/athena/live/component/videoeffect/render/VideoEffectConfig;", "videoeffect_release"})
    public static final class Companion {
        @Nullable
        public final VideoEffectManager getSVideoEffectManager() {
            return sVideoEffectManager;
        }

        public final void setSVideoEffectManager(@Nullable VideoEffectManager videoEffectManager) {
            sVideoEffectManager = videoEffectManager;
        }

        @NotNull
        public final VideoEffectConfig createDefaultConfig() {
            VideoEffectConfig videoEffectConfig = new VideoEffectConfig.Builder().setFaceModelInitFromAssetsPath("facemodel/facemodel.zip").setFaceModelInitVersion("v1.1").setFaceRecognitionEnable(true).setIsCropOFVersion(false).setPhonePerformanceLevel(PerformanceLevel.Level_1).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)videoEffectConfig, (String)"VideoEffectConfig.Builde\u2026\n                .build()");
            return videoEffectConfig;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

