/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.videoeffect;

import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.Observer;
import android.content.Context;
import com.orangefilter.OrangeFilter;
import com.venus.Venus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.live.basesdk.thunderblotwrapper.AbscThunderEventListener;
import tv.athena.live.basesdk.thunderblotwrapper.AthLiveThunderEventCallback;
import tv.athena.live.basesdk.thunderblotwrapper.ThunderHandleManager;
import tv.athena.live.component.videoeffect.PlayARGiftEffectListener;
import tv.athena.live.component.videoeffect.render.EffectRender;
import tv.athena.live.component.videoeffect.render.VideoEffectConfig;
import tv.athena.live.component.videoeffect.thunderbolt.FaceBeautyConsumer;
import tv.athena.live.component.videoeffect.thunderbolt.FaceDetectionConsumer;
import tv.athena.live.component.videoeffect.thunderbolt.beauty.IPreProcessListener;
import tv.athena.live.component.videoeffect.thunderbolt.util.LogWrapper;
import tv.athena.live.vsprotocol.ATHFaceDetectionResult;

public class VideoEffectManager {
    private static final String TAG = "VideoEffectManager";
    private static final String OF_TAG = "OF_SDK";
    private static final String VENUS_TAG = "VENUS_SDK";
    private FaceBeautyConsumer mFaceBeautyConsumer;
    private FaceDetectionConsumer mFaceDetectionConsumer;
    private MutableLiveData mHasFacePointInfo = new MutableLiveData();
    private boolean isVideoPreview;
    private final AbscThunderEventListener mVideoPreviewCallback = new AbscThunderEventListener(){

        public void onStartPreview() {
            LogWrapper.i(VideoEffectManager.TAG, "********** Preview.onStart() **********");
            VideoEffectManager.this.register();
        }

        public void onStopPreview() {
            LogWrapper.i(VideoEffectManager.TAG, "********** Preview.onStop() **********");
            VideoEffectManager.this.unRegister();
        }
    };
    private final IPreProcessListener mOFPreProcessListener = new IPreProcessListener(){

        @Override
        public void onPreProcessStatus(int status) {
            if (1 == status) {
                VideoEffectManager.this.mHasFacePointInfo.postValue((Object)true);
            } else if (2 == status) {
                VideoEffectManager.this.mHasFacePointInfo.postValue((Object)false);
            }
        }

        @Override
        public void animationCallbackBlock(String s, int i, int i1) {
        }
    };

    public VideoEffectManager(Context context, VideoEffectConfig config) {
        LogWrapper.i(TAG, "new VideoEffectManager()");
        if (config.isFaceRecognitionEnable()) {
            this.mFaceDetectionConsumer = new FaceDetectionConsumer(context, config);
        }
        this.mFaceBeautyConsumer = new FaceBeautyConsumer(config);
        AthLiveThunderEventCallback thunderEvent = ThunderHandleManager.INSTANCE.getMAthLiveThunderEventCallback();
        if (thunderEvent != null) {
            thunderEvent.registerThunderEventListener(this.mVideoPreviewCallback);
            if (ThunderHandleManager.INSTANCE.getMIsOnPreview()) {
                this.mVideoPreviewCallback.onStartPreview();
            }
        }
        OrangeFilter.setLogCallback((OrangeFilter.OF_LogListener)new OrangeFilter.OF_LogListener(){

            public void logCallBackFunc(String s) {
                LogWrapper.i(VideoEffectManager.OF_TAG, s);
            }

            public void logCallBackFunc2(String s, int i) {
                LogWrapper.i(VideoEffectManager.OF_TAG, s + " i = " + i);
            }
        });
        Venus.setLogLevel((int)4);
        Venus.setLogCallback(s -> LogWrapper.i(VENUS_TAG, s));
    }

    private void register() {
        if (!this.isVideoPreview) {
            LogWrapper.i(TAG, "=== register ===");
            this.isVideoPreview = true;
            if (this.mFaceDetectionConsumer != null) {
                this.mFaceDetectionConsumer.start();
            }
            if (this.mFaceBeautyConsumer != null) {
                this.mFaceBeautyConsumer.setFaceDetectionProducer(this.mFaceDetectionConsumer != null ? this.mFaceDetectionConsumer.getFaceDetectionProducer() : null);
                this.mFaceBeautyConsumer.setVideoEffectListener(this.mOFPreProcessListener);
                this.mFaceBeautyConsumer.start();
            }
        } else {
            LogWrapper.w(TAG, "Error ****** Lost unRegister *******");
            this.unRegister();
            this.register();
        }
    }

    private void unRegister() {
        LogWrapper.i(TAG, "=== unRegister ===");
        this.isVideoPreview = false;
        if (this.mFaceDetectionConsumer != null) {
            this.mFaceDetectionConsumer.stop();
        }
        if (this.mFaceBeautyConsumer != null) {
            this.mFaceBeautyConsumer.stop();
        }
    }

    public void destroy() {
        if (this.mFaceBeautyConsumer != null) {
            this.mFaceBeautyConsumer.setFaceDetectionProducer(null);
            this.mFaceBeautyConsumer.setVideoEffectListener(null);
            this.mFaceBeautyConsumer.destroy();
            this.mFaceBeautyConsumer = null;
        }
        if (this.mFaceDetectionConsumer != null) {
            this.mFaceDetectionConsumer.destroy();
            this.mFaceDetectionConsumer = null;
        }
        ThunderHandleManager.INSTANCE.getMAthLiveThunderEventCallback().unRegisterRtcEventListener(this.mVideoPreviewCallback);
        this.isVideoPreview = false;
        LogWrapper.w(TAG, "===== destroy() =======");
    }

    public void consumeFaceEffect(EffectRender thunderRender) {
        if (this.mFaceBeautyConsumer != null) {
            this.mFaceBeautyConsumer.consume(thunderRender);
        } else {
            LogWrapper.w(TAG, "Ignore consumeFaceEffect: " + thunderRender);
        }
    }

    public void observeFaceFrameData(Observer<ATHFaceDetectionResult> observer) {
        if (this.mFaceDetectionConsumer != null) {
            this.mFaceDetectionConsumer.observeFaceFrameData(observer);
        }
    }

    public void playARGiftEffect(@NotNull String effectResDir, @Nullable PlayARGiftEffectListener listener) {
        if (this.mFaceBeautyConsumer != null) {
            this.mFaceBeautyConsumer.playARGiftEffect(effectResDir, listener);
        }
    }

    public void removeObserveFaceFrameData(Observer<ATHFaceDetectionResult> observer) {
        if (this.mFaceDetectionConsumer != null) {
            this.mFaceDetectionConsumer.removeObserveFaceFrameData(observer);
        }
    }

    public void setFilterBeauty6Param(float param) {
        if (this.mFaceBeautyConsumer != null) {
            this.mFaceBeautyConsumer.setFilterBeauty6Param(param);
        } else {
            LogWrapper.w(TAG, "Ignore setFilterBeauty6Param: " + param);
        }
    }

    public void setNeedDefaultFace(boolean need) {
        if (this.mFaceBeautyConsumer != null) {
            this.mFaceBeautyConsumer.setNeedDefaultFace(need);
        }
    }

    public void setFacePoints(@NotNull float[] facePointsPortrait, @NotNull float[] facePointsHorizontal) {
        if (this.mFaceBeautyConsumer != null) {
            this.mFaceBeautyConsumer.setFacePoints(facePointsPortrait, facePointsHorizontal);
        }
    }
}

